/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import com.trsupdate.RightUpdaterHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InheritResultAssertor {
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private static Logger logger = Logger.getLogger(InheritResultAssertor.class);
    private List m_listInheritInfo = null;
    public static boolean ALL_USER_IS_SAME_MODE = false;
    private Users m_oAdmins = null;

    public InheritResultAssertor(List list) {
        this.m_listInheritInfo = list;
    }

    public void assertResult() throws WCMException {
        this.m_oAdmins = Users.findAdministrators();
        Users users = Users.openWCMObjs(null, null);
        int n = users.size();
        DebugTimer debugTimer = new DebugTimer();
        int n2 = this.m_listInheritInfo.size();
        for (int i = 0; i < n2; ++i) {
            InheritInfo inheritInfo = (InheritInfo)this.m_listInheritInfo.get(i);
            Users users2 = inheritInfo.getUsers();
            boolean bl = (double)(n / users2.size()) <= 1.2;
            debugTimer.start();
            logger.debug((Object)("dowith " + inheritInfo.getChannel() + "....."));
            int n3 = users2.size();
            for (int j = 0; j < n3; ++j) {
                Object object;
                User user = (User)users2.getAt(j);
                DebugTimer debugTimer2 = new DebugTimer();
                debugTimer2.start();
                List list = this.makeInheritRights(user, inheritInfo.getChannel());
                debugTimer2.stop();
                debugTimer2.start();
                if (list.size() == 1 && ((Right)(object = (Right)list.get(0))).getOperatorType() == 204) continue;
                object = this.makeNewRightOpratorIds(list, 201);
                String string = this.makeNewRightOpratorIds(list, 203);
                Users users3 = null;
                users3 = bl ? users : this.makeUsersInSameGroupOrRole(user, (String)object, string);
                debugTimer2.stop();
                debugTimer2.start();
                int n4 = users3.size();
                for (int k = 0; k < n4; ++k) {
                    User user2;
                    boolean bl2;
                    int n5 = users3.getIdAt(k);
                    if (users2.indexOf(n5) >= 0 || this.m_oAdmins.indexOf(n5) >= 0 || !(bl2 = this.assertEnlargeRightOfUser(inheritInfo, user2 = (User)users3.getAt(k), list))) continue;
                    logger.error((Object)("!!!!!!!!!!! The " + user + " enlarge the  " + user2 + "'s right on " + inheritInfo.getChannel() + " !!!!!!!!!!! "));
                }
                debugTimer2.stop();
                debugTimer2.start();
            }
            debugTimer.stop();
            logger.debug((Object)("dowith " + inheritInfo.getChannel() + " us[" + debugTimer.getTime() + "]ms!"));
        }
    }

    private String makeNewRightOpratorIds(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer(list.size() * 4);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Right right = (Right)list.get(i);
            if (right.getOperatorType() == n) continue;
            stringBuffer.append(right.getOperatorId());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private boolean assertEnlargeRightOfUser(InheritInfo inheritInfo, User user, List list) throws WCMException {
        long l;
        CMSObj cMSObj;
        int n;
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        Channel channel = inheritInfo.getChannel();
        long l2 = this.makeRightValue(channel, user);
        if (l2 != -1L) {
            debugTimer.stop();
            return false;
        }
        Groups groups = user.getGroups();
        Roles roles = user.getRoles();
        debugTimer.stop();
        debugTimer.start();
        l2 = 0L;
        int n2 = groups.size();
        for (n = 0; n < n2; ++n) {
            cMSObj = (Group)groups.getAt(n);
            l = this.makeRightValue(channel, cMSObj);
            if (l == -1L) continue;
            l2 |= l;
        }
        debugTimer.stop();
        debugTimer.start();
        n2 = roles.size();
        for (n = 0; n < n2; ++n) {
            cMSObj = (Role)roles.getAt(n);
            l = this.makeRightValue(channel, cMSObj);
            if (l == -1L) continue;
            l2 |= l;
        }
        debugTimer.stop();
        debugTimer.start();
        if (l2 == 0L) {
            return false;
        }
        long l3 = 0L;
        int n3 = list.size();
        block6: for (int i = 0; i < n3; ++i) {
            Right right = (Right)list.get(i);
            switch (right.getOperatorType()) {
                case 201: {
                    if (groups.indexOf(right.getOperatorId()) >= 0) break;
                    continue block6;
                }
                case 203: {
                    if (roles.indexOf(right.getOperatorId()) >= 0) break;
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
            l3 |= right.getValueAsLong();
        }
        debugTimer.stop();
        debugTimer.start();
        return !RightUpdaterHelper.containsValue(l2, l3);
    }

    private List makeInheritRights(User user, Channel channel) throws WCMException {
        ArrayList<Right> arrayList = new ArrayList<Right>();
        Groups groups = user.getGroups();
        Roles roles = user.getRoles();
        for (BaseChannel baseChannel = channel.getHost(); baseChannel != null; baseChannel = baseChannel.getHost()) {
            Right right;
            CMSObj cMSObj;
            int n;
            long l = this.makeRightValue(baseChannel, user);
            if (l != -1L) {
                Right right2 = new Right();
                right2.setValue(l);
                right2.setOperator(user);
                arrayList.add(right2);
                return arrayList;
            }
            int n2 = groups.size();
            for (n = 0; n < n2; ++n) {
                cMSObj = (Group)groups.getAt(n);
                l = this.makeRightValue(baseChannel, cMSObj);
                if (l == -1L) continue;
                right = new Right();
                right.setValue(l);
                right.setOperator(cMSObj);
                arrayList.add(right);
            }
            n2 = roles.size();
            for (n = 0; n < n2; ++n) {
                cMSObj = (Role)roles.getAt(n);
                if (cMSObj.getId() == 1 || (l = this.makeRightValue(baseChannel, cMSObj)) == -1L) continue;
                right = new Right();
                right.setValue(l);
                right.setOperator(cMSObj);
                arrayList.add(right);
            }
            if (arrayList.isEmpty()) {
                continue;
            }
            return arrayList;
        }
        throw new WCMException("\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0d\u53ef\u80fd\u6ca1\u6709\u4efb\u4f55\u7ee7\u627f\u7684\u6743\u9650\uff01User=[" + user + "] Channel=[" + channel + "]");
    }

    private long makeRightValue(BaseChannel baseChannel, CMSObj cMSObj) throws WCMException {
        long l = this.rightCacheMgr.getRightValue(baseChannel.getWCMType(), baseChannel.getId(), cMSObj.getWCMType(), cMSObj.getId(), -1L);
        if (l == -1L) {
            return l;
        }
        CMyBitsValue cMyBitsValue = new CMyBitsValue(l);
        for (int i = 0; i < 11; ++i) {
            cMyBitsValue.setBit(i, false);
        }
        long l2 = cMyBitsValue.getValue();
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    private Users makeUsersInSameGroupOrRole(User user, String string, String string2) throws WCMException {
        String string3 = "exists(select 1 from WCMGrpUser b where b.UserId=WCMUser.UserId" + (string.length() > 0 ? " and b.GroupId in(" + string + ") " : "") + " and exists(" + " select 1 from WCMGrpUser c" + " where b.GroupId=c.GroupId and c.UserId=?" + ")" + ")";
        String string4 = "exists(select 1 from WCMRoleUser b where b.UserId=WCMUser.UserId" + (string2.length() > 0 ? " and b.RoleId in(" + string2 + ") " : "") + " and exists(" + " select 1 from WCMRoleUser c" + " where b.RoleId=c.RoleId and c.UserId=?" + ")" + ")";
        WCMFilter wCMFilter = new WCMFilter("", string3 + " or " + string4, "");
        wCMFilter.addSearchValues(user.getId());
        wCMFilter.addSearchValues(user.getId());
        return Users.openWCMObjs(null, wCMFilter);
    }
}

