/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.infra.I18NMessage;
import com.trs.webframework.WebServiceHelper;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.controler.servlet.XMLParamsValidator;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.BaseServiceDecorator;
import com.trs.webframework.xmlserver.parser.XMLParseException;
import com.trs.webframework.xmlserver.server.IObserver;
import com.trs.webframework.xmlserver.server.IObserverable;
import com.trs.webframework.xmlserver.server.XMLDataProcessingHandler;
import org.apache.log4j.Logger;

public class InvocationObserver
implements IObserver {
    private static Logger logger = Logger.getLogger(InvocationObserver.class);
    private MethodConfig m_oMethodConfig = null;
    private XMLDataProcessingHandler m_oVisitor;
    private ServiceContext m_oServiceContext = null;
    private Object m_oVisitorArg = null;

    public InvocationObserver() {
    }

    public InvocationObserver(ServiceContext serviceContext) {
        this.m_oServiceContext = serviceContext;
    }

    public void clear() {
        this.m_oMethodConfig = null;
        this.m_oVisitorArg = null;
    }

    public void update(IObserverable iObserverable) {
        this.update(iObserverable, null);
    }

    public void update(IObserverable iObserverable, Object object) {
        this.m_oVisitor = (XMLDataProcessingHandler)iObserverable;
        this.m_oVisitorArg = object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">> update at status: " + this.m_oVisitor.getParsingStatus()));
        }
        switch (this.m_oVisitor.getParsingStatus()) {
            case 1: {
                this.doOnTypeDetected();
                break;
            }
            case 2: {
                this.doOnInvocationNameDetected();
                break;
            }
            case 3: 
            case 4: {
                this.doOnParameterDetected();
                break;
            }
        }
    }

    private void doOnTypeDetected() {
        int n = this.m_oVisitor.getParsingInfo().getInvocationType();
        if (n == 1) {
            // empty if block
        }
    }

    private void doOnInvocationNameDetected() {
        String string = this.m_oVisitor.getParsingInfo().getInvocationId();
        if (string == null) {
            throw new XMLParseException("No Service defined in the xml stream\uff01");
        }
        ServiceConfig serviceConfig = ServiceConfigHelper.findServiceConfig(string);
        if (serviceConfig == null) {
            throw new ServiceCreationFailException(I18NMessage.get(InvocationObserver.class, "InvocationObserver.label1", "\u6ca1\u6709\u53d1\u73b0Service[") + string + I18NMessage.get(InvocationObserver.class, "InvocationObserver.label2", "]\u7684\u914d\u7f6e\u6587\u4ef6 [") + ServiceConfigHelper.getSevicesConfigFileName(string) + "].");
        }
        String string2 = this.m_oVisitor.getParsingInfo().getMethodName();
        this.m_oMethodConfig = ServiceConfigHelper.findMethodConfig(string, string2);
        if (this.m_oMethodConfig == null) {
            throw new ServiceCreationFailException(I18NMessage.get(InvocationObserver.class, "InvocationObserver.label3", "\u662f\u5426\u5728\u6587\u4ef6[") + ServiceConfigHelper.getSevicesConfigFileName(string) + I18NMessage.get(InvocationObserver.class, "InvocationObserver.label4", "]\u4e2d\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + string2 + "]?");
        }
        if (!this.m_oMethodConfig.isParamsRequired()) {
            this.execute(4);
        }
    }

    private void doOnParameterDetected() {
        int n = this.m_oVisitor.getParsingInfo().getInvocationType();
        this.execute(n);
    }

    private void execute(int n) {
        if (this.m_oMethodConfig == null) {
            return;
        }
        Object object = null;
        MethodContext methodContext = new XMLParamsValidator(this.m_oVisitor.getParsingInfo().getNamedParamsMap(), this.m_oMethodConfig).getMethodContext();
        MethodContext methodContext2 = methodContext != null ? methodContext : new MethodContext(this.m_oMethodConfig);
        try {
            switch (n) {
                case 1: {
                    methodContext2.setObjectIds(this.m_oVisitor.getParsingInfo().getObjectIds());
                    break;
                }
                case 5: {
                    methodContext2.setObjectId(this.m_oVisitor.getParsingInfo().getObjectId());
                    break;
                }
                case 7: {
                    methodContext2.setObjectIds(this.m_oVisitor.getParsingInfo().getObjectIds());
                }
            }
        }
        catch (Throwable throwable) {
            throw new ServiceInvocationException(throwable);
        }
        if (this.m_oMethodConfig.getProvider() instanceof BaseServiceDecorator) {
            ((BaseServiceDecorator)this.m_oMethodConfig.getProvider()).decorate(this.m_oServiceContext);
        }
        if (this.m_oVisitorArg != null && this.m_oVisitorArg instanceof ServiceContext) {
            methodContext2.setServiceContext((ServiceContext)this.m_oVisitorArg);
        }
        object = WebServiceHelper.execute(this.m_oMethodConfig, methodContext2);
        this.m_oVisitor.stopOnParsingCompleted(object);
    }
}

