/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.server.RequestParmasParseException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseValidator {
    public static final String PARAM_NAME_SEARCH_KEY = "SearchKey";
    public static final String PARAM_NAME_SEARCH_TABLE = "SearchTable";
    public static final String PARAM_NAME_SEARCH_VALUE = "SearchValue";
    public static final String PARAM_NAME_ORDER_FIELD = "OrderField";
    public static final String PARAM_NAME_ORDER_TYPE = "OrderType";
    protected MethodContext m_oMethodContext = null;
    protected MethodConfig m_oMethoConfig = null;
    protected static Logger logger = Logger.getLogger(BaseValidator.class);

    public BaseValidator(MethodConfig methodConfig) {
        this.m_oMethoConfig = methodConfig;
    }

    protected abstract String getParameterValue(String var1);

    protected void doValidate() {
        this.m_oMethodContext = new MethodContext(this.m_oMethoConfig);
        if (!this.m_oMethoConfig.isParamsRequired()) {
            return;
        }
        TRSPageParameter[] tRSPageParameterArray = this.m_oMethoConfig.getPageParameter();
        TRSPageParameter tRSPageParameter = null;
        for (int i = 0; i < tRSPageParameterArray.length; ++i) {
            tRSPageParameter = tRSPageParameterArray[i];
            if (tRSPageParameter == null || this.m_oMethodContext.containsParameter(tRSPageParameter.getName())) continue;
            String string = this.getParameterValue(tRSPageParameter.getName());
            if (tRSPageParameter.isRequired() && string == null) {
                throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label1", "\u670d\u52a1[") + this.m_oMethoConfig.getServiceConfig().getServiceId() + "." + this.m_oMethoConfig.toString() + I18NMessage.get(BaseValidator.class, "BaseValidator.label2", "]\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label3", "]\u6ca1\u6709\u4f20\u5165!"));
            }
            this.doValueValidate(tRSPageParameter, string);
        }
    }

    private void doValueValidate(TRSPageParameter tRSPageParameter, String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = tRSPageParameter.getDefault();
            if (string2 == null) {
                return;
            }
        } else {
            string2 = string.trim();
        }
        String string3 = tRSPageParameter.getName();
        if (tRSPageParameter.getMinValue() != null && tRSPageParameter.getMinValue().length() > 0 && Long.parseLong(string2) < Long.parseLong(tRSPageParameter.getMinValue())) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label5", "]\u503c[") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label6", "]\u5c0f\u4e8e\u6700\u5c0f\u503c[") + tRSPageParameter.getMinValue() + "]\uff01");
        }
        if (tRSPageParameter.getMaxValue() != null && tRSPageParameter.getMaxValue().length() > 0 && Long.parseLong(string2) > Long.parseLong(tRSPageParameter.getMaxValue())) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label5", "]\u503c[") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label7", "]\u5927\u4e8e\u6700\u5927\u503c[") + tRSPageParameter.getMaxValue() + "]\uff01");
        }
        if (tRSPageParameter.getMinLength() > 0 && string2.length() < tRSPageParameter.getMinLength()) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label8", "]\u957f\u5ea6[") + string2.length() + I18NMessage.get(BaseValidator.class, "BaseValidator.label9", "]\u5c0f\u4e8e\u6700\u5c0f\u957f\u5ea6[") + tRSPageParameter.getMinLength() + "]\uff01");
        }
        if (tRSPageParameter.getMaxLength() > 0 && string2.length() > tRSPageParameter.getMaxLength()) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label8", "]\u957f\u5ea6[") + string2.length() + I18NMessage.get(BaseValidator.class, "BaseValidator.label10", "]\u5927\u4e8e\u6700\u5927\u957f\u5ea6[") + tRSPageParameter.getMaxLength() + "]\uff01");
        }
        String string4 = tRSPageParameter.getType().toLowerCase();
        switch (string4.hashCode()) {
            case -891985903: {
                this.m_oMethodContext.setValue(tRSPageParameter.getName(), string2);
                break;
            }
            case 104431: {
                string2 = string2.trim();
                if (string2.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(tRSPageParameter.getName(), Integer.parseInt(string2));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getDesc() + "][" + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), numberFormatException);
                }
            }
            case 64711720: {
                string2 = string2.trim();
                if (string2.length() == 0) break;
                try {
                    if (string2.length() == 1) {
                        int n = Integer.parseInt(string2);
                        if (n != 1 && n != 0) {
                            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label14", "\u4f20\u5165\u7684\u5e03\u5c14\u578b\u53c2\u6570\u4e0d\u662f0\uff0c1"));
                        }
                        this.m_oMethodContext.setValue(string3, n);
                        break;
                    }
                    this.m_oMethodContext.setValue(string3, string2.equalsIgnoreCase("true") ? 1 : 0);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getDesc() + "][" + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), numberFormatException);
                }
            }
            case 3327612: {
                string2 = string2.trim();
                if (string2.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(tRSPageParameter.getName(), Long.parseLong(string2));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getDesc() + "][" + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), numberFormatException);
                }
            }
            case 97526364: {
                string2 = string2.trim();
                if (string2.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(tRSPageParameter.getName(), Float.parseFloat(string2));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getDesc() + "][" + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label15", "]\u4e0d\u662f\u6d6e\u70b9\u6570"), numberFormatException);
                }
            }
            case 1793702779: {
                string2 = string2.trim();
                if (string2.length() == 0) break;
                CMyDateTime cMyDateTime = new CMyDateTime();
                try {
                    cMyDateTime.setDateTimeWithString(string2);
                }
                catch (CMyException cMyException) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + tRSPageParameter.getDesc() + "][" + tRSPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + string2 + I18NMessage.get(BaseValidator.class, "BaseValidator.label16", "]\u4e0d\u662f\u65e5\u671f\u578b"), cMyException);
                }
                this.m_oMethodContext.setValue(string3, cMyDateTime);
                break;
            }
        }
    }

    public MethodContext getMethodContext() {
        if (this.m_oMethodContext == null) {
            this.doValidate();
        }
        Map map = FrameworkConstants.KeywordedParams;
        for (String string : map.keySet()) {
            this.m_oMethodContext.setValue(string, this.getParameterValue(string));
        }
        return this.m_oMethodContext;
    }
}

