/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.context;

import com.trs.infra.I18NMessage;
import com.trs.infra.db.QueryFilter;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.ServiceContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MethodContext {
    private static final int DFVALUE_OBJECT_ID = -99999;
    private static Logger logger = Logger.getLogger(MethodContext.class);
    private String m_sObjectIds = null;
    private int m_nObjectId = -99999;
    private QueryFilter m_oQueryFilter = null;
    private Map m_hValidatedValues = null;
    private MethodConfig m_oMethodConfig;
    private ServiceContext m_oServiceContext = null;
    private Map m_oContextCacheData = null;
    private BaseObj m_oCurrHost = null;
    private String[] m_pFieldNamesNotTrim = null;

    public boolean isReturnHTML() {
        return this.getServiceContext().isReturnHTML();
    }

    public void setReturnHTML(boolean bl) {
        this.getServiceContext().setReturnHTML(bl);
    }

    public MethodContext(MethodConfig methodConfig) {
        this.m_oMethodConfig = methodConfig;
    }

    public QueryFilter getQueryFilter() {
        if (this.m_oQueryFilter == null) {
            this.makeQueryFilter();
        }
        return this.m_oQueryFilter;
    }

    public WCMFilter getExtraWCMFilter() {
        return new WCMFilter(this.getQueryFilter());
    }

    private void makeQueryFilter() {
        if (this.m_hValidatedValues == null) {
            return;
        }
        String string = null;
        QueryFilter queryFilter = new QueryFilter();
        TRSPageParameter[] tRSPageParameterArray = this.m_oMethodConfig.getPageParameter();
        block8: for (int i = 0; i < tRSPageParameterArray.length; ++i) {
            String string2;
            TRSPageParameter tRSPageParameter = tRSPageParameterArray[i];
            if (tRSPageParameter == null) continue;
            if (tRSPageParameter.isFromTable()) {
                string2 = this.getValue(tRSPageParameter.getName());
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = tRSPageParameter.getDefault();
                }
                queryFilter.setFrom(string2);
                continue;
            }
            if (tRSPageParameter.isSelectFields()) {
                string2 = this.getValue(tRSPageParameter.getName());
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = tRSPageParameter.getDefault();
                }
                queryFilter.setSelect(string2);
                continue;
            }
            if (tRSPageParameter.isOrderBy()) {
                string2 = this.getValue(tRSPageParameter.getName());
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = tRSPageParameter.getDefault();
                }
                queryFilter.setOrder(string2);
                continue;
            }
            if (!tRSPageParameter.isSearch() || !this.containsParameter(tRSPageParameter.getName()) || (string2 = this.getValue(tRSPageParameter.getName())).length() == 0 && (tRSPageParameter.getDefault() == null || tRSPageParameter.getDefault().length() == 0) || tRSPageParameter.isExcludeValue(string2)) continue;
            int n = 1;
            switch (tRSPageParameter.getType().toLowerCase().hashCode()) {
                case 3076014: 
                case 1793702779: {
                    CMyDateTime cMyDateTime = this.getValue(tRSPageParameter.getName(), null);
                    if (cMyDateTime == null) continue block8;
                    queryFilter.addSearchValues(cMyDateTime);
                    break;
                }
                case -1325958191: {
                    double d = this.getValue(tRSPageParameter.getName(), tRSPageParameter.getDefaultAsDouble(0.0));
                    queryFilter.addSearchValues(d);
                    break;
                }
                case 97526364: {
                    float f = this.getValue(tRSPageParameter.getName(), tRSPageParameter.getDefaultAsFloat(0.0f));
                    queryFilter.addSearchValues(f);
                    break;
                }
                case 104431: {
                    int n2 = this.getValue(tRSPageParameter.getName(), tRSPageParameter.getDefaultAsInt(0));
                    queryFilter.addSearchValues(n2);
                    break;
                }
                case 3327612: {
                    long l = this.getValue(tRSPageParameter.getName(), tRSPageParameter.getDefaultAsLong(0L));
                    queryFilter.addSearchValues(l);
                    break;
                }
                case -891985903: {
                    int n3;
                    Object[] objectArray;
                    if ("pint".equalsIgnoreCase(tRSPageParameter.getSearchType())) {
                        objectArray = CMyString.splitToInt(string2, ",");
                        n = objectArray.length;
                        for (n3 = 0; n3 < n; ++n3) {
                            queryFilter.addSearchValues(objectArray[n3]);
                        }
                    } else {
                        objectArray = string2.trim().split(" ");
                        n = objectArray.length;
                        for (n3 = 0; n3 < n; ++n3) {
                            Object object = objectArray[n3];
                            if (tRSPageParameter.getSearchOperator() == null || tRSPageParameter.getSearchOperator().equalsIgnoreCase("like")) {
                                object = '%' + (String)object + '%';
                            }
                            queryFilter.addSearchValues((String)object);
                        }
                    }
                    break;
                }
                default: {
                    continue block8;
                }
            }
            string = string != null ? string + (this.getValue("IsOr", false) ? " or " : " and ") : "";
            string = string + tRSPageParameter.getSearchExpress(n);
        }
        queryFilter.setWhere(string);
        String string3 = this.getValue("SelectFields");
        if (string3 != null && string3.trim().length() != 0) {
            queryFilter.setSelect(string3);
        }
        this.m_oQueryFilter = queryFilter;
    }

    public void setQueryFilter(QueryFilter queryFilter) {
        this.m_oQueryFilter = queryFilter;
    }

    public String getObjectIds() {
        if (this.m_sObjectIds == null) {
            this.m_sObjectIds = this.getValue("ObjectIds");
        }
        return this.m_sObjectIds;
    }

    public void setObjectIds(String string) {
        this.m_sObjectIds = string != null ? string.trim() : string;
    }

    public int getObjectId() {
        if (this.m_nObjectId == -99999) {
            this.m_nObjectId = this.getValue("ObjectId", -99999);
        }
        return this.m_nObjectId;
    }

    public void setObjectId(int n) {
        this.m_nObjectId = n;
    }

    private Object getParameterValue(String string) {
        if (this.m_hValidatedValues == null || string == null) {
            return null;
        }
        return this.m_hValidatedValues.get(string.toUpperCase());
    }

    public String getValue(String string) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return null;
        }
        boolean bl = this.isNeedTrim(string.toUpperCase());
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return stringArray == null || stringArray.length == 0 ? null : (bl ? stringArray[0].trim() : stringArray[0]);
        }
        return bl ? object.toString().trim() : object.toString();
    }

    public Object getObjectValue(String string) {
        return this.getParameterValue(string);
    }

    public boolean getValue(String string, boolean bl) {
        String string2 = this.getValue(string);
        if (CMyString.isEmpty(string2)) {
            return bl;
        }
        if ("true".equals(string2 = string2.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        int n = this.getValue(string, bl ? 1 : 0);
        return n != 0;
    }

    public int getValue(String string, int n) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return n;
        }
        if (object instanceof Integer) {
            Integer n2 = (Integer)object;
            return n2;
        }
        try {
            String string2 = object.toString().trim();
            if (string2.length() == 0) {
                return n;
            }
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + string + I18NMessage.get(MethodContext.class, "MethodContext.label2", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[int]\uff01")));
            return n;
        }
    }

    public long getValue(String string, long l) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return l;
        }
        if (object instanceof Long) {
            Long l2 = (Long)object;
            return l2;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + string + I18NMessage.get(MethodContext.class, "MethodContext.label3", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[long]\uff01")), (Throwable)numberFormatException);
            return l;
        }
    }

    public double getValue(String string, double d) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            Double d2 = (Double)object;
            return d2;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + string + I18NMessage.get(MethodContext.class, "MethodContext.label4", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[double]\uff01")), (Throwable)numberFormatException);
            return d;
        }
    }

    public float getValue(String string, float f) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return f;
        }
        if (object instanceof Float) {
            Float f2 = (Float)object;
            return f2.floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + string + I18NMessage.get(MethodContext.class, "MethodContext.label5", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[float]\uff01")), (Throwable)numberFormatException);
            return f;
        }
    }

    public CMyDateTime getValue(String string, CMyDateTime cMyDateTime) {
        Object object = this.getParameterValue(string);
        if (object == null || object.toString().length() == 0) {
            return cMyDateTime;
        }
        if (object instanceof CMyDateTime) {
            CMyDateTime cMyDateTime2 = (CMyDateTime)object;
            return cMyDateTime2;
        }
        try {
            CMyDateTime cMyDateTime3 = new CMyDateTime();
            cMyDateTime3.setDateTimeWithString(object.toString());
            return cMyDateTime3;
        }
        catch (CMyException cMyException) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + string + I18NMessage.get(MethodContext.class, "MethodContext.label6", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[CMyDateTime]\uff01")), (Throwable)cMyException);
            return cMyDateTime;
        }
    }

    public void setParamValues(String string, String[] stringArray) {
        this.setObjectValue(string, stringArray);
    }

    public String[] getParamValues(String string) {
        Object object = this.getParameterValue(string);
        if (object == null || !(object instanceof String[])) {
            return new String[0];
        }
        return (String[])object;
    }

    public Map getParams() {
        if (this.m_hValidatedValues == null || this.m_hValidatedValues.isEmpty()) {
            return new HashMap(0);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.m_hValidatedValues.entrySet()) {
            String string = (String)entry.getKey();
            if (FrameworkConstants.isKeyWordedParam(string)) continue;
            hashMap.put(string, entry.getValue());
        }
        return this.m_hValidatedValues;
    }

    private void setObjectValue(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (this.m_hValidatedValues == null) {
            this.m_hValidatedValues = new HashMap();
        }
        this.m_hValidatedValues.put(string.toUpperCase(), object);
    }

    public void setValue(String string, Object object) {
        this.setObjectValue(string, object);
    }

    public void setValue(String string, String string2) {
        this.setObjectValue(string, string2);
    }

    public void setValue(String string, int n) {
        this.setObjectValue(string, new Integer(n));
    }

    public void setValue(String string, long l) {
        this.setObjectValue(string, new Long(l));
    }

    public void setValue(String string, float f) {
        this.setObjectValue(string, new Float(f));
    }

    public void setValue(String string, double d) {
        this.setObjectValue(string, new Double(d));
    }

    public void setValue(String string, CMyDateTime cMyDateTime) {
        this.setObjectValue(string, cMyDateTime);
    }

    public Map getValues() {
        return this.m_hValidatedValues;
    }

    public void setValues(Map map) {
        this.m_hValidatedValues = map;
    }

    public boolean containsParameter(String string) {
        return this.m_hValidatedValues != null && this.m_hValidatedValues.containsKey(string.toUpperCase());
    }

    public boolean isEmptyOfParameterValues() {
        return this.m_hValidatedValues == null || this.m_hValidatedValues.isEmpty();
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.m_oServiceContext = serviceContext;
    }

    public ServiceContext getServiceContext() {
        return this.m_oServiceContext;
    }

    public MethodConfig getMethodConfig() {
        return this.m_oMethodConfig;
    }

    public boolean isValidObjectId() {
        return this.getObjectId() != -99999;
    }

    public boolean isReturnJSON() {
        return this.getServiceContext().isReturnJSON();
    }

    public void setReturnJSON(boolean bl) {
        this.getServiceContext().setReturnJSON(bl);
    }

    public void setContentType(String string) {
        this.getServiceContext().setContentType(string);
    }

    public void setContentTypeIsHTML() {
        this.getServiceContext().setContentTypeIsHTML();
    }

    public void putContextCacheData(Map map) {
        this.getContextCacheData().putAll(map);
    }

    public void putContextCacheData(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        this.getContextCacheData().put(object, object2);
    }

    public Object getContextCacheData(Object object) {
        if (object == null) {
            return null;
        }
        return this.getContextCacheData().get(object);
    }

    public int getPageSize() {
        if (this.containsParameter("PAGESIZE")) {
            return this.getValue("PAGESIZE", 20);
        }
        if (this.containsParameter("PageItemCount")) {
            return this.getValue("PageItemCount", 20);
        }
        return 20;
    }

    public int getPageIndex() {
        if (this.containsParameter("PageIndex")) {
            return this.getValue("PageIndex", 1);
        }
        if (this.containsParameter("CURRPAGE")) {
            return this.getValue("CURRPAGE", 1);
        }
        return 1;
    }

    private Map getContextCacheData() {
        if (this.m_oContextCacheData == null) {
            this.m_oContextCacheData = new HashMap(1);
        }
        return this.m_oContextCacheData;
    }

    private boolean isNeedTrim(String string) {
        if (this.m_pFieldNamesNotTrim == null) {
            Object object = this.getParameterValue("FieldNamesNotTrim");
            String string2 = null;
            this.m_pFieldNamesNotTrim = object == null || (string2 = object.toString().trim()).length() == 0 ? new String[0] : string2.toUpperCase().split(",");
        }
        for (int i = 0; i < this.m_pFieldNamesNotTrim.length; ++i) {
            if (!this.m_pFieldNamesNotTrim[i].equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public BaseObj getCurrHost() {
        return this.m_oCurrHost;
    }

    public void setCurrHost(BaseObj baseObj) {
        this.m_oCurrHost = baseObj;
    }
}

