/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.support.log.OperType;
import com.trs.infra.support.log.OperTypes;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import org.apache.log4j.Logger;

public abstract class AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(AbstractLogger.class);
    protected static final Class CMSOBJS_KLASS = CMSBaseObjs.class;
    protected static final Class BASEOBJ_KLASS = BaseObj.class;

    protected String getLogType(MethodConfig methodConfig) {
        String string = methodConfig.getName();
        String string2 = methodConfig.getServiceConfig().getServiceId();
        String string3 = string2.replaceAll("wcm61", "wcm6") + "_" + string;
        String string4 = methodConfig.getDesc();
        if (CMyString.isEmpty(string4)) {
            string4 = string;
        }
        string4 = string4 + " (wcm6)";
        try {
            if (!LogServer.existsLogType(string3)) {
                this.createLogTypeIfNeed(string3, string4);
            }
        }
        catch (Exception exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return string3;
    }

    protected void createLogTypeIfNeed(String string, String string2) throws WCMException {
        OperTypes operTypes = new OperTypes();
        WCMFilter wCMFilter = new WCMFilter("", "NAME=?", "");
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(string);
        operTypes.open(wCMFilter);
        if (!operTypes.isEmpty()) {
            LogServer.cachedLogtype((OperType)operTypes.getAt(0));
            return;
        }
        OperType operType = new OperType();
        operType.setName(string);
        operType.setDesc(string2);
        operType.setProperty("CRTIME", CMyDateTime.now());
        operType.setProperty("CRUSER", "admin");
        operType.insert();
        LogServer.cachedLogtype(operType);
    }

    protected int log(MethodConfig methodConfig, String string, BaseObj baseObj) {
        try {
            String string2 = ContextHelper.getLoginUser().getName();
            String string3 = this.getLogType(methodConfig);
            if (string3 == null) {
                string3 = "UNKNOWN_OPERTYPE";
            }
            return (int)LogServer.startRecord(string2, string3, string, baseObj);
        }
        catch (Exception exception) {
            LOG.error((Object)("Exception to record error![MethodInfo=" + methodConfig + "]"), (Throwable)exception);
            return 0;
        }
    }

    public void endLog(int n) {
        LogServer.endRecordSucceedOperation(n);
    }

    public void endLogWithFaliure(int n, Throwable throwable) {
        LogServer.endRecordFailedOperation(n, throwable);
    }
}

