/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.wcm.photo.ImageLibConstants;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ImageMagickCmd {
    private static final int SUCCESS = 0;
    private static String CMD_CONVERT;
    private static String CMD_COMPOSITE;
    private static String CMD_IDENTIFY;
    private static final String[] GRAVITIES;

    public static void setCmds(Map map) {
        CMD_CONVERT = (String)map.get("CMD_CONVERT");
        CMD_COMPOSITE = (String)map.get("CMD_COMPOSITE");
        CMD_IDENTIFY = (String)map.get("CMD_IDENTIFY");
    }

    public static int scale(ImageObj imageObj, ImageObj imageObj2) throws Exception {
        int n;
        int n2 = imageObj2.width;
        if (n2 <= 0) {
            n2 = imageObj.width * imageObj2.height / imageObj.height;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if ((n = imageObj2.height) <= 0) {
            n = imageObj.height * imageObj2.width / imageObj.width;
        }
        if (n == 0) {
            n = 1;
        }
        String[] stringArray = new String[7];
        stringArray[0] = CMD_CONVERT;
        stringArray[1] = "-scale";
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(n2).append('x').append(n).append('!');
        stringArray[2] = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer = null;
        stringArray[3] = "-quality";
        stringArray[4] = "70";
        stringArray[5] = imageObj.filename;
        stringArray[6] = imageObj2.filename;
        return ImageMagickCmd.exec(stringArray);
    }

    static int execSimple(String[] stringArray) throws Exception {
        Process process = Runtime.getRuntime().exec(stringArray);
        return process.waitFor();
    }

    public static int addWaterkmark(String string, String string2, int[] nArray) throws Exception {
        if (ImageMagickCmd.isSelfDefinePosition(nArray, ImageLibConstants.MARKPOS_SELF_DEFIND)) {
            ImageMagickCmd.addWaterMarkInDefindePosition(string, string2, nArray);
        } else {
            ImageMagickCmd.addWaterMarkInPosition(string, string2, nArray);
        }
        return 0;
    }

    private static void addWaterMarkInDefindePosition(String string, String string2, int[] nArray) throws Exception {
        ImageObj imageObj = new ImageObj(string2);
        imageObj.setFilename(string2);
        Float f = new Float((float)nArray[2] / (float)nArray[3] * (float)imageObj.width);
        int n = f.intValue();
        f = new Float((float)nArray[1] / (float)nArray[4] * (float)imageObj.height);
        int n2 = f.intValue();
        String[] stringArray = new String[8];
        stringArray[0] = CMD_COMPOSITE;
        stringArray[1] = "-compose";
        stringArray[2] = "atop";
        stringArray[3] = "-geometry";
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append('+').append(n).append('+').append(n2);
        stringArray[4] = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringArray[5] = string;
        stringArray[6] = string2;
        stringArray[7] = string2;
        ImageMagickCmd.exec(stringArray);
    }

    private static void addWaterMarkInPosition(String string, String string2, int[] nArray) throws Exception {
        String[] stringArray = new String[8];
        stringArray[0] = CMD_COMPOSITE;
        stringArray[1] = "-compose";
        stringArray[2] = "atop";
        stringArray[3] = "-gravity";
        stringArray[5] = string;
        stringArray[6] = string2;
        stringArray[7] = string2;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[4] = GRAVITIES[nArray[i] - 1];
            ImageMagickCmd.exec(stringArray);
        }
    }

    private static boolean isSelfDefinePosition(int[] nArray, int n) {
        if (nArray == null || nArray.length < 5) {
            return false;
        }
        return nArray[0] == n;
    }

    public static void roateImg(ImageObj imageObj, String string) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
        String[] stringArray = new String[]{CMD_CONVERT, "-rotate", string, imageObj.filename, string2};
        ImageMagickCmd.exec(stringArray);
        imageObj.setFilename(string2);
    }

    public static void borderImg(ImageObj imageObj, String string, int n, int n2) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
        String[] stringArray = new String[7];
        stringArray[0] = CMD_CONVERT;
        stringArray[1] = "-border";
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(n).append('x').append(n2).append('!');
        stringArray[2] = stringBuffer.toString();
        stringArray[3] = "-bordercolor";
        stringArray[4] = string;
        stringArray[5] = imageObj.filename;
        stringArray[6] = string2;
        ImageMagickCmd.exec(stringArray);
        imageObj.setFilename(string2);
    }

    public static void raiseImg(ImageObj imageObj, int n, int n2, boolean bl) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
        String[] stringArray = new String[5];
        stringArray[0] = CMD_CONVERT;
        stringArray[1] = bl ? "-raise" : "+raise";
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(n).append('x').append(n2).append('!');
        stringArray[2] = stringBuffer.toString();
        stringArray[3] = imageObj.filename;
        stringArray[4] = string;
        ImageMagickCmd.exec(stringArray);
        imageObj.setFilename(string);
    }

    public static void convertBmp(ImageObj imageObj, String string) throws Exception {
        String[] stringArray;
        stringArray = new String[]{CMD_CONVERT, imageObj.filename, stringArray[1].substring(0, stringArray[1].lastIndexOf(46) + 1) + string};
        ImageMagickCmd.exec(stringArray);
        imageObj.filename = stringArray[2];
    }

    public static void crop(ImageObj imageObj, int n, int n2, int n3, int n4) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
        String[] stringArray = new String[]{CMD_CONVERT, imageObj.filename, "-crop", n3 + "x" + n4 + "+" + n + "+" + n2, string};
        ImageMagickCmd.exec(stringArray);
        imageObj.setFilename(string);
    }

    static int exec(String[] stringArray) throws Exception {
        return ImageMagickCmd.exec(stringArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int exec(String[] stringArray, String[] stringArray2) throws Exception {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getInputStream();
        final InputStream inputStream2 = process.getErrorStream();
        try {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        int n = 0;
                        while ((n = inputStream2.read()) != -1) {
                            byteArrayOutputStream.write(n);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            thread.start();
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            thread.join();
            int n2 = process.waitFor();
            String string = new String(byteArrayOutputStream.toByteArray());
            if (n2 != 0) {
                throw new Exception("process fail:" + n2 + ",msg=" + string);
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray2[0] = string.trim();
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int[] getImageSize(ImageObj imageObj) throws Exception {
        String[] stringArray = new String[]{CMD_IDENTIFY, "-format", "%wx%h", imageObj.filename};
        String[] stringArray2 = new String[1];
        ImageMagickCmd.exec(stringArray, stringArray2);
        String[] stringArray3 = stringArray2[0].split("x");
        int[] nArray = new int[]{Integer.parseInt(stringArray3[0]), Integer.parseInt(stringArray3[1])};
        return nArray;
    }

    public static String scale(String string, String string2, int n, boolean bl) throws Exception {
        if (n <= 0) {
            throw new Exception("Illeagal options: target scalelen is zero.");
        }
        String[] stringArray = new String[7];
        stringArray[0] = CMD_CONVERT;
        stringArray[1] = "-scale";
        StringBuffer stringBuffer = new StringBuffer(16);
        ImageObj imageObj = new ImageObj();
        imageObj.setFilename(string);
        boolean bl2 = false;
        if (bl || imageObj.width >= imageObj.height) {
            stringBuffer.append(n).append('x');
            bl2 = n >= imageObj.width;
        } else {
            bl2 = n >= imageObj.height;
            stringBuffer.append('x').append(n);
        }
        if (bl2) {
            return string;
        }
        stringArray[2] = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer = null;
        stringArray[3] = "-quality";
        stringArray[4] = "100";
        stringArray[5] = imageObj.filename;
        stringArray[6] = string2;
        if (ImageMagickCmd.exec(stringArray) == 0) {
            return string2;
        }
        return string;
    }

    protected static String makeFileName(String string, int n) {
        int n2 = string.lastIndexOf(46);
        StringBuffer stringBuffer = new StringBuffer(string.length() + String.valueOf(n).length() + 1);
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append('_');
        stringBuffer.append(n);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static {
        GRAVITIES = new String[]{"northwest", "center", "southeast"};
    }

    public static class ImageObj {
        public String filename;
        public int width;
        public int height;

        public ImageObj() {
        }

        public ImageObj(String string) throws WCMException {
            File file = new File(string);
            if (!file.exists()) {
                FilesMan filesMan = FilesMan.getFilesMan();
                string = filesMan.mapFilePath(string, 0) + string;
                file = new File(string);
            }
            this.filename = file.getAbsolutePath();
        }

        public ImageObj(String string, int n, int n2) {
            this.filename = string;
            this.width = n;
            this.height = n2;
        }

        public void setFilename(String string) throws Exception {
            Object object;
            File file = new File(string);
            if (!file.exists()) {
                object = FilesMan.getFilesMan();
                string = ((FilesMan)object).mapFilePath(string, 0) + string;
                file = new File(string);
            }
            this.filename = file.getAbsolutePath();
            try {
                object = ImageMagickCmd.getImageSize(this);
                this.width = (int)object[0];
                this.height = (int)object[1];
            }
            catch (Exception exception) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    this.width = bufferedImage.getWidth();
                    this.height = bufferedImage.getHeight();
                    return;
                }
                catch (Exception exception2) {
                    Image image = Toolkit.getDefaultToolkit().getImage(this.filename);
                    Component component = new Component(){};
                    MediaTracker mediaTracker = new MediaTracker(component);
                    mediaTracker.addImage(image, 1);
                    mediaTracker.waitForID(1, 0L);
                    this.width = image.getWidth(null);
                    this.height = image.getHeight(null);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.filename);
            stringBuffer.append(":width=").append(this.width);
            stringBuffer.append(",height=").append(this.height);
            return stringBuffer.toString();
        }
    }
}

