/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IChannelService;
import com.trs.service.IDocumentService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.IImageLibService;
import com.trs.wcm.photo.ImageInfo;
import java.util.List;

public class ImageLibServiceImpl
implements IImageLibService {
    private IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private IChannelService m_oChannelService = (IChannelService)DreamFactory.createObjectById("IChannelService");
    private IDocumentService m_oDocumentService = (IDocumentService)DreamFactory.createObjectById("IDocumentService");
    private IImageLibMgr m_oImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");

    public void deleteImage(String string) throws WCMException {
        this.m_oDocumentService.delete(string, null, false);
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.m_oImageLibMgr.deleteDocumentQuoteImage(n);
        }
    }

    public void deleteImage(String string, int n) throws WCMException {
        this.m_oDocumentService.delete(string, Channel.findById(n), false);
    }

    public List getChannels(User user, int n) throws WCMException {
        ContextHelper.initContext(user);
        return this.m_oChannelService.getChildren(this.m_oImageLibConfig.getRelateSite(), n);
    }

    public List getChannels(User user, int n, Channel channel) throws WCMException {
        ContextHelper.initContext(user);
        return this.m_oChannelService.getChildren(channel, n);
    }

    public List getChannels(User user, int n, Channel channel, WCMFilter wCMFilter) throws WCMException {
        throw new WCMException(I18NMessage.get(ImageLibServiceImpl.class, "ImageLibServiceImpl.label1", "\u6ca1\u6709\u5b9e\u73b0\uff0c\u4f9d\u8d56\u4e8eWCM52\uff01"));
    }

    public Documents getDocuments(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        return this.m_oChannelService.getDocuments(baseChannel, wCMFilter);
    }

    public Document saveImageDetail(Document document) throws WCMException {
        return this.m_oDocumentService.save(document, null, null);
    }

    public ImageInfo saveImageInfo(ImageInfo imageInfo) throws WCMException {
        return this.m_oImageLibMgr.saveImageInfo(imageInfo);
    }

    public void quoteImages(int n, String string) throws WCMException {
        this.m_oImageLibMgr.deleteDocumentQuoteImage(n, string);
        if (string == null || string.length() == 0 || string == "null") {
            return;
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            this.m_oImageLibMgr.recordDocumentQuoteImage(n, n2);
        }
    }

    public Documents getDocumentsQuoteImage(int n) throws WCMException {
        return this.m_oImageLibMgr.getDocumentsQuoteImage(n);
    }

    public Appendixes getImageAppendixes(WCMFilter wCMFilter, BaseChannel baseChannel, boolean bl) throws WCMException {
        return this.m_oImageLibMgr.getImageAppendixes(wCMFilter, baseChannel, bl);
    }

    public ImageInfo[] importImageAppendix(String string, ImageInfo imageInfo) throws WCMException {
        int[] nArray = CMyString.splitToInt(string, ",");
        ImageInfo[] imageInfoArray = new ImageInfo[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            try {
                imageInfoArray[i] = this.importImageAppendix(nArray[i], (ImageInfo)imageInfo.clone());
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new WCMException(I18NMessage.get(ImageLibServiceImpl.class, "ImageLibServiceImpl.label2", "\u590d\u5236ImageInfo\u5bf9\u8c61\u5931\u8d25\uff01"), cloneNotSupportedException);
            }
        }
        return imageInfoArray;
    }

    public ImageInfo importImageAppendix(int n, ImageInfo imageInfo) throws WCMException {
        User user = ContextHelper.getLoginUser();
        return this.m_oImageLibMgr.importImageAppendix(user, n, imageInfo);
    }

    public void clearQuotedImages(int n) throws WCMException {
        this.m_oImageLibMgr.deleteDocumentQuoteImage(n);
    }
}

