/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.Alertion;
import com.trs.wcag2.validator.BiTagValidator;
import com.trs.wcag2.validator.DocTypeValidator;
import com.trs.wcag2.validator.EmbedAltValidator;
import com.trs.wcag2.validator.EventsValidator;
import com.trs.wcag2.validator.FormElementsValidator;
import com.trs.wcag2.validator.FormSubmitValidator;
import com.trs.wcag2.validator.FrameTitleValidator;
import com.trs.wcag2.validator.HtmlCharsetValidator;
import com.trs.wcag2.validator.HtmlH1Validator;
import com.trs.wcag2.validator.HtmlH1_H6Validator;
import com.trs.wcag2.validator.HtmlLangValidator;
import com.trs.wcag2.validator.HtmlTitleValidator;
import com.trs.wcag2.validator.IValidator;
import com.trs.wcag2.validator.ImgAltValidator;
import com.trs.wcag2.validator.ObjectBodyValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WCAG2Helper {
    private static List m_lstValidators = new ArrayList();

    private static List getAlertions(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap hashMap = new HashMap();
        for (IValidator iValidator : m_lstValidators) {
            Object object;
            Object object2 = iValidator.doValid(string, hashMap);
            if (object2 == Boolean.TRUE || object2 == null) continue;
            if (object2 instanceof HashMap) {
                object = (HashMap)object2;
                for (String string2 : ((HashMap)object).keySet()) {
                    WCAG2Helper.arrAlertions((List)((HashMap)object).get(string2), arrayList, iValidator, string2);
                }
                continue;
            }
            if (object2 instanceof List) {
                WCAG2Helper.arrAlertions((List)object2, arrayList, iValidator, null);
                continue;
            }
            object = new Alertion();
            ((Alertion)object).setHTML("");
            ((Alertion)object).setKlass(iValidator.getType());
            ((Alertion)object).setWarning(iValidator.getWarning(object2));
            ((Alertion)object).setLevel(Alertion.FAIL);
            ((Alertion)object).setNum(1);
            ((Alertion)object).setExample(iValidator.getExample(object2));
            arrayList.add(object);
        }
        return arrayList;
    }

    private static void arrAlertions(List list, List list2, IValidator iValidator, String string) {
        if (list.size() == 0) {
            return;
        }
        Alertion alertion = new Alertion();
        alertion.setRst(list);
        alertion.setHTML(WCAG2Helper.getWarnHTML(list));
        alertion.setKlass(iValidator.getType());
        alertion.setWarning(iValidator.getWarning(string));
        alertion.setExample(iValidator.getExample(string));
        alertion.setLevel("warn".equalsIgnoreCase(string) ? Alertion.WARN : Alertion.FAIL);
        alertion.setNum(list.size());
        list2.add(alertion);
    }

    private static String getWarnHTML(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        String string = "\n";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            Object e = iterator.next();
            if (e instanceof String) {
                stringBuffer.append(e);
                continue;
            }
            if (!(e instanceof String[])) continue;
            String[] stringArray = (String[])e;
            stringBuffer.append(I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label1", "\u7b2c") + stringArray[0] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label2", "\u884c,\u7b2c") + stringArray[1] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label3", "\u5217:") + stringArray[2]);
        }
        return stringBuffer.toString();
    }

    public static void registerValidator(IValidator iValidator) {
        m_lstValidators.add(iValidator);
    }

    public static Object doValid(String string) {
        List list = WCAG2Helper.getAlertions(string);
        return list;
    }

    public static void main(String[] stringArray) {
        String string = "fas\nasdfasdf\nasdfsdf\n<html>as\nd\n<meta http-equiv='content' content='text/html'>\n fasd<title>abc</title>fasdf\nasdf<H1>ab</H1>asd\nasdf<A></A><IMG alt=\"asf\"><B onmouseover=aa>iiasdfs</b>sadf<I>asdfsfda</I>asdf<b>dfasd</b><A class=a-gray title='<TRS_DOCUMENT FIELD=\"DocTitle\"/>' href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\ndasfasdf\n" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label4", "<IMG class=a-gray title=\"<TRS_DOCUMENT FIELD=\"DocTitle\"/>\" src=\"<TRS_DOCUMENT FIELD=\"_RECURL\"/>\" target=_blank/>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acbasdfasd\n") + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label5", "<A class=a-gray title=\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\n") + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label6", "af<INPUT id=aa><label for=aa></label><INPUT title=bb><BUTTON>fads</BUTTON>sadfsad\n<A class=a-gray title=\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb  asdf='<\\'>' href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\n") + "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0\" width=\"404\" height=\"111\">\n" + "<param name=\"movie\" value=\"service/swf/head.swf\" />\n" + "<param name=\"quality\" value=\"high\" />\n" + "<embed src=\"service/swf/head.swf\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"404\" height=\"111\"></embed>\n" + "</object></html>";
        try {
            string = CMyFile.readFile("C:\\1.txt", "UTF-8");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        WCAG2Helper.doValid(string);
    }

    public static String toHTML(List list) {
        if (list.size() == 0) {
            return I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label7", "<REPORT><IS_SUCCESS>true</IS_SUCCESS><TITLE><![CDATA[\u65e0\u969c\u788d\u68c0\u67e5\u7ed3\u679c:\u7b26\u5408WCAG2\u89c4\u8303!]]></TITLE><TYPE>3</TYPE></REPORT>");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ul>");
        String string = "sys_alertion_";
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Alertion alertion = (Alertion)list.get(i);
            string2 = string + i;
            stringBuffer.append("<li>");
            stringBuffer.append("<span class=\"accessibility_level\">");
            stringBuffer.append(alertion.getLevel());
            stringBuffer.append("</span>");
            stringBuffer.append("<span class=\"accessibility_class\">");
            stringBuffer.append(alertion.getKlass());
            stringBuffer.append("</span>");
            stringBuffer.append("<span class=\"accessibility_warning\">");
            stringBuffer.append(alertion.getWarning());
            stringBuffer.append("</span>");
            stringBuffer.append("<a class=\"accessibility_detail\" href=\"#\" onclick=\"renderAccessibility('");
            stringBuffer.append(string2);
            stringBuffer.append("_example')\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label8", ">\u5efa\u8bae</a>"));
            stringBuffer.append("<span style=\"display:none;\" id=\"");
            stringBuffer.append(string2);
            stringBuffer.append("_example\">");
            stringBuffer.append(alertion.getExample());
            stringBuffer.append("</span>");
            List list2 = alertion.getRst();
            if (list2 == null) continue;
            stringBuffer.append("<span class=\"accessibility_num\">(");
            stringBuffer.append(alertion.getNum());
            stringBuffer.append(")</span>");
            stringBuffer.append("<a class=\"accessibility_detail\" href=\"#\" onclick=\"Element.toggle('");
            stringBuffer.append(string2);
            stringBuffer.append("')\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label9", ">\u8be6\u7ec6</a>"));
            stringBuffer.append("<table border=\"1\" bordercolor=\"gray\" style=\"display:none;\" id=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\">");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("<tr>");
                Object object = iterator.next();
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    object = "<span class=\"accessibility_rowpos\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label10", ">\u7b2c") + stringArray[0] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label2", "\u884c,\u7b2c") + stringArray[1] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label11", "\u5217</span>:") + CMyString.filterForHTMLValue(stringArray[2]);
                } else {
                    object = CMyString.filterForHTMLValue((String)object);
                }
                stringBuffer.append("<td>");
                stringBuffer.append(object.toString());
                stringBuffer.append("</td></tr>");
            }
            stringBuffer.append("</table>");
        }
        stringBuffer.append("</ul>");
        String string3 = I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label12", "<REPORT><IS_SUCCESS>false</IS_SUCCESS><TITLE><![CDATA[\u65e0\u969c\u788d\u68c0\u67e5\u7ed3\u679c:]]></TITLE><ERROR_INFO><![CDATA[ ") + stringBuffer.toString() + "]]></ERROR_INFO><TYPE>5</TYPE></REPORT>";
        return string3;
    }

    static {
        WCAG2Helper.registerValidator(new DocTypeValidator());
        WCAG2Helper.registerValidator(new HtmlLangValidator());
        WCAG2Helper.registerValidator(new HtmlCharsetValidator());
        WCAG2Helper.registerValidator(new HtmlTitleValidator());
        WCAG2Helper.registerValidator(new HtmlH1Validator());
        WCAG2Helper.registerValidator(new HtmlH1_H6Validator());
        WCAG2Helper.registerValidator(new ImgAltValidator());
        WCAG2Helper.registerValidator(new BiTagValidator());
        WCAG2Helper.registerValidator(new FrameTitleValidator());
        WCAG2Helper.registerValidator(new ObjectBodyValidator());
        WCAG2Helper.registerValidator(new EmbedAltValidator());
        WCAG2Helper.registerValidator(new FormSubmitValidator());
        WCAG2Helper.registerValidator(new FormElementsValidator());
        WCAG2Helper.registerValidator(new EventsValidator());
    }
}

