/*
 * Decompiled with CFR 0.152.
 */
package com.trs.update.wcm;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.tools.CommonResourceBuilder;
import com.trs.update.wcm.UpdateConfigManager;
import com.trs.update.wcm.UpdateFixStatus;
import com.trs.update.wcm.WCMUpdateServer;
import com.trs.update.wcm.WCMVersionInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateFixController
extends Thread {
    private static Logger logger = Logger.getLogger(UpdateFixController.class);
    private static Map paramMap = new HashMap();
    private static boolean m_bRunning = false;
    private User m_oLoginUser = null;
    private static WCMUpdateServer updateServer = null;
    private static String m_sFixUrl = null;
    private static final int SUCCESS = 0;
    private static String m_sTestAntPath = "WEB-INF" + File.separatorChar + "classes" + File.separatorChar + "updatefix" + File.separatorChar + "test_ant_path_build.xml";

    public static UpdateFixController newInstance(User _loginUser, boolean _bNewUpdateServer) throws Exception {
        UpdateFixController controller = new UpdateFixController();
        controller.m_oLoginUser = _loginUser;
        UpdateFixController.initUpdateServer(_bNewUpdateServer);
        return controller;
    }

    public static UpdateFixController newInstance(User _loginUser) throws Exception {
        return UpdateFixController.newInstance(_loginUser, false);
    }

    private static void initUpdateServer(boolean _bNewUpdateServer) throws Exception {
        if (!m_bRunning && _bNewUpdateServer) {
            UpdateFixController.validVersion();
            UpdateFixController.validConfig();
            UpdateFixController.initFixUrl();
            if (logger.isDebugEnabled()) {
                logger.info((Object)"=========\u5f00\u59cb\u521d\u59cb\u5316updateServer======");
            }
            updateServer = new WCMUpdateServer(m_sFixUrl);
        }
    }

    private static boolean validVersion() throws Exception {
        String[] sCurrVersionInfo = WCMVersionInfo.getVersionInfo();
        if (sCurrVersionInfo[1].indexOf("1095.14304") < 0) {
            throw new Exception("\u5f53\u524d\u7248\u672c\u4e3a[v" + sCurrVersionInfo[0] + "-" + sCurrVersionInfo[1] + "]\uff0c\u4e0d\u80fd\u505aFIX\u5347\u7ea7\uff0c\u8bf7\u5148\u5347\u7ea7\u7cfb\u7edf\u5230\u3010V65-1095.14304\u3011\u7248\u672c\uff01");
        }
        return true;
    }

    private static boolean validConfig() throws Exception {
        String sCmdAnt = UpdateConfigManager.getCmdAnt();
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if (!CMyFile.fileExists(sWCMPath)) {
            throw new Exception("\u8bf7\u4fee\u6539WEB-INF/classes/TRSWCMApp.ini\u6587\u4ef6\uff0c\u786e\u4fddWCM_Path\u8bbe\u7f6e\u6b63\u786e\uff01\u76ee\u524d\u914d\u7f6e\u4e3a\u3010" + sWCMPath + "\u3011");
        }
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        String sConfigFilePath = String.valueOf(sWCMPath) + m_sTestAntPath;
        try {
            UpdateFixController.exec(new String[]{sCmdAnt, "-f", sConfigFilePath}, null);
        }
        catch (Exception e) {
            throw new Exception("ant\u547d\u4ee4\u8def\u5f84\u914d\u7f6e\u6709\u8bef,\u8bf7\u5728\u6587\u4ef6\u3010WEB-INF/classes/updatefix/config.properties\u3011\u6587\u4ef6\u4e2d\u914d\u7f6e\u6b63\u786eCMD_ANT\u7684\u8def\u5f84\uff0c\u8bbe\u7f6e\u540e\u9700\u8981\u91cd\u542f\u5e94\u7528\uff01\uff01", e);
        }
        return true;
    }

    public boolean validFixIndexFile() throws Exception {
        return updateServer.validUploadFixIndexFile();
    }

    public boolean isConfigFixUrl() throws Exception {
        return !CMyString.isEmpty(m_sFixUrl);
    }

    public boolean isExistsIndexFile() throws Exception {
        return updateServer.isExistsIndexFile();
    }

    private static void initFixUrl() throws Exception {
        m_sFixUrl = UpdateConfigManager.getFixUrl();
        if (!CMyString.isEmpty(m_sFixUrl)) {
            m_sFixUrl = CMyString.setStrEndWith(m_sFixUrl, '/');
        }
    }

    public WCMUpdateServer getUpdateServer() throws Exception {
        return updateServer;
    }

    public String getUpdateTimeStamp() throws Exception {
        return updateServer.getTimestamp();
    }

    public String getCurrUpgradeMsg(boolean bContainUpdated) {
        String sAllInfo = "";
        try {
            sAllInfo = updateServer.getCurrFixInfo(bContainUpdated);
        }
        catch (Exception e) {
            sAllInfo = "\u83b7\u53d6\u7cfb\u7edffix\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38";
            logger.error((Object)sAllInfo, (Throwable)e);
        }
        return sAllInfo;
    }

    public Map getNeedUpdateFixes() throws Exception {
        return updateServer.getNeedUpdateFixes();
    }

    public boolean isUpdated(String _sFixKey) {
        return updateServer.isUpdated(_sFixKey);
    }

    public boolean hasError(String _sFixKey) {
        return updateServer.hasError(_sFixKey);
    }

    public String getError(String _sFixKey) {
        return updateServer.getErrorInfo(_sFixKey);
    }

    public ArrayList getAllFixes() {
        return updateServer.getAllFixes();
    }

    public void run() {
        if (m_bRunning) {
            return;
        }
        m_bRunning = true;
        UpdateFixStatus recodeBeginUpgrade = new UpdateFixStatus();
        try {
            try {
                ContextHelper.initContext(this.m_oLoginUser);
                recodeBeginUpgrade.recodeBeginUpgrade();
                HashMap uodateFixMap = updateServer.getNeedUpdateFixes();
                if (uodateFixMap.size() > 0) {
                    updateServer.update();
                    this.buildResource();
                }
                this.setParameter("PROCESSORFINISHEDFLAG", "true");
            }
            catch (Exception e) {
                logger.error((Object)"\u66f4\u65b0fix\u5305\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                this.setParameter("ERRORMSG", "\u66f4\u65b0fix\u5305\u51fa\u73b0\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\u6587\u4ef6!");
                if (logger.isDebugEnabled()) {
                    logger.info((Object)"=========\u90e8\u7f72\u8fd0\u884c\u5b8c\u6210======");
                }
                try {
                    try {
                        recodeBeginUpgrade.recodeEndUpgrade();
                    }
                    catch (Exception exception) {
                        this.setParameter("TIMESTAMP", updateServer.getTimestamp());
                        this.setParameter("CONFLICTFILES", updateServer.getConflictFiles());
                        this.setParameter("MANUALWORKINFO", updateServer.getManualWorkInfo());
                        m_bRunning = false;
                        ContextHelper.clear();
                    }
                }
                finally {
                    this.setParameter("TIMESTAMP", updateServer.getTimestamp());
                    this.setParameter("CONFLICTFILES", updateServer.getConflictFiles());
                    this.setParameter("MANUALWORKINFO", updateServer.getManualWorkInfo());
                    m_bRunning = false;
                    ContextHelper.clear();
                }
            }
        }
        finally {
            block24: {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)"=========\u90e8\u7f72\u8fd0\u884c\u5b8c\u6210======");
                }
                try {
                    try {
                        recodeBeginUpgrade.recodeEndUpgrade();
                    }
                    catch (Exception exception) {
                        this.setParameter("TIMESTAMP", updateServer.getTimestamp());
                        this.setParameter("CONFLICTFILES", updateServer.getConflictFiles());
                        this.setParameter("MANUALWORKINFO", updateServer.getManualWorkInfo());
                        m_bRunning = false;
                        ContextHelper.clear();
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.setParameter("TIMESTAMP", updateServer.getTimestamp());
                    this.setParameter("CONFLICTFILES", updateServer.getConflictFiles());
                    this.setParameter("MANUALWORKINFO", updateServer.getManualWorkInfo());
                    m_bRunning = false;
                    ContextHelper.clear();
                    throw throwable;
                }
                this.setParameter("TIMESTAMP", updateServer.getTimestamp());
                this.setParameter("CONFLICTFILES", updateServer.getConflictFiles());
                this.setParameter("MANUALWORKINFO", updateServer.getManualWorkInfo());
                m_bRunning = false;
                ContextHelper.clear();
            }
        }
    }

    public void setParameter(String _paramName, Object _paramValue) {
        paramMap.put(_paramName.toUpperCase(), _paramValue);
    }

    public boolean isRunning() {
        return m_bRunning;
    }

    public void resetParams() {
        paramMap.clear();
    }

    public Object getParameter(String _paramName) {
        if (logger.isDebugEnabled()) {
            logger.info((Object)("=========paramname:===========" + _paramName + "============"));
        }
        return paramMap.get(_paramName.toUpperCase());
    }

    private void buildResource() throws Exception {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        String sAppPath = String.valueOf(sWCMPath) + "app" + File.separator;
        CommonResourceBuilder.build(sAppPath);
    }

    static int exec(String[] cmd, String[] result) throws Exception {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream pis = proc.getInputStream();
        final InputStream per = proc.getErrorStream();
        try {
            Thread t = new Thread(){

                public void run() {
                    try {
                        int a = 0;
                        while ((a = per.read()) != -1) {
                            baos.write(a);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            int a = 0;
            while ((a = pis.read()) != -1) {
                baos.write(a);
            }
            t.join();
            int exitCode = proc.waitFor();
            String msg = new String(baos.toByteArray());
            if (exitCode != 0) {
                throw new Exception("ant exe fail:" + exitCode + ",msg=" + msg);
            }
            if (result != null && result.length > 0) {
                result[0] = msg.trim();
            }
            return 0;
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception exception) {}
            }
            if (per != null) {
                try {
                    per.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

