/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.JavaScriptVARProcessor;
import com.trs.infra.util.PropertiesVARProcessor;
import com.trs.tools.LocaleServerCollector;
import com.trs.tools.Localizer2;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MediaBuilder {
    private static Logger logger = Logger.getLogger(MediaBuilder.class);
    private static String root;
    private static String releaseDir;
    private static String runtimeDir;
    private static String baseDir;
    private static String basePath4CNAndEN;
    private static List jsResources;
    private static List propertiesResources;

    public static void init(String string, String string2) {
        root = new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        root = CMyString.setStrEndWith(root, File.separatorChar);
        baseDir = root + "wcm_locales\\en\\";
        basePath4CNAndEN = root + "app";
        releaseDir = string2;
        runtimeDir = new File(string2).getParentFile().getAbsolutePath();
    }

    public static void processJavaScript() throws Exception {
        JavaScriptVARProcessor javaScriptVARProcessor = null;
        int n = jsResources.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])jsResources.get(i);
            javaScriptVARProcessor = new JavaScriptVARProcessor(root + stringArray[0], root + stringArray[1], releaseDir, stringArray.length == 3 ? stringArray[2] : baseDir);
            if (stringArray[0].endsWith(".js")) {
                javaScriptVARProcessor.process(root + stringArray[0], root + stringArray[1]);
                continue;
            }
            javaScriptVARProcessor.process();
        }
        logger.info((Object)"\u5f00\u59cb\u5904\u7406_cn.js\u4e0e_en.js\u540e\u7f00\u6587\u4ef6\u7684\u5bf9\u6bd4");
        new File(basePath4CNAndEN).listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    file.listFiles(this);
                    return false;
                }
                String string = file.getName();
                if (!string.endsWith("_cn.js")) {
                    return false;
                }
                String string2 = file.getAbsolutePath();
                String string3 = string2.substring(0, string2.length() - "_cn.js".length()) + "_en.js";
                JavaScriptVARProcessor javaScriptVARProcessor = new JavaScriptVARProcessor(string2, string2, releaseDir, root);
                try {
                    javaScriptVARProcessor.process(string2, string3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
        });
    }

    public static void processProperties() throws Exception {
        PropertiesVARProcessor propertiesVARProcessor = null;
        int n = propertiesResources.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])propertiesResources.get(i);
            propertiesVARProcessor = new PropertiesVARProcessor(root + stringArray[0], root + stringArray[1], releaseDir, baseDir);
            if (stringArray[0].endsWith(".properties")) {
                propertiesVARProcessor.process(root + stringArray[0], root + stringArray[1]);
                continue;
            }
            propertiesVARProcessor.process();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            stringBuffer.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u5de5\u7a0bWebApp\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\u5982\uff1a\n");
            stringBuffer.append("E:/MyWorkspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/");
            stringBuffer.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u4e2d\u82f1\u6587\u8d44\u6e90\u6587\u4ef6\u6bd4\u8f83\u540e\uff0c\u6709\u4e2d\u6587\u7684\u82f1\u6587\u8d44\u6e90\u6587\u4ef6\u8f93\u51fa\u6839\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\u5982\uff1a\n");
            stringBuffer.append("E:\\wcm65\\increase\\\n");
            logger.error((Object)stringBuffer);
            return;
        }
        MediaBuilder.init(stringArray[0], stringArray[1]);
        Localizer2.main(new String[]{root, runtimeDir, "en", "true"});
        String string = root + "WEB-INF/classes/locale/";
        LocaleServerCollector.main(new String[]{root + "app", string + "zh_CN.properties"});
        new PropertiesVARProcessor(string, string, releaseDir, root).process(string + "zh_CN.properties", string + "presentation_zh_CN.properties");
        CMyFile.deleteFile(string + "zh_CN.properties");
        CMyFile.copyFile(string + "presentation_zh_CN.properties", string + "presentation_en.properties");
        MediaBuilder.processProperties();
    }

    static {
        jsResources = new ArrayList();
        jsResources.add(new String[]{"app\\js\\data\\locale\\", "wcm_locales\\en\\app\\js\\data\\locale\\"});
        jsResources.add(new String[]{"app\\editor\\editor\\lang\\cn.js", "app\\editor\\editor\\lang\\en.js", root});
        propertiesResources = new ArrayList();
        propertiesResources.add(new String[]{"WEB-INF\\classes\\i18nmessage\\", "wcm_locales\\en\\WEB-INF\\classes\\i18nmessage\\"});
        propertiesResources.add(new String[]{"WEB-INF\\classes\\locale\\", "wcm_locales\\en\\WEB-INF\\classes\\locale\\"});
        propertiesResources.add(new String[]{"WEB-INF\\classes\\wcm6-locale\\", "wcm_locales\\en\\WEB-INF\\classes\\wcm6-locale\\"});
    }
}

