/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet.acl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.presentation.util.RequestHelper;
import com.trs.servlet.Acl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SourceDelete
extends Acl {
    protected boolean check(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            return false;
        }
        if (user.isAdministrator()) {
            return true;
        }
        RequestHelper requestHelper = new RequestHelper(httpServletRequest, httpServletResponse, httpServletRequest.getSession().getServletContext());
        String string = requestHelper.getString("SourceIds");
        Sources sources = Sources.findByIds(user, string);
        if (sources == null || sources.isEmpty()) {
            return true;
        }
        int n = sources.size();
        for (int i = 0; i < n; ++i) {
            Source source = (Source)sources.getAt(i);
            if (source == null) continue;
            WebSite webSite = WebSite.findById(source.getPropertyAsInt("siteid", 0));
            if (webSite == null) {
                return false;
            }
            if (AuthServer.hasRight(user, (CMSObj)webSite, 1)) continue;
            return false;
        }
        return true;
    }
}

