/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.FlowMgr;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowParamers;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Reports;
import com.trs.service.IWCMProcessService;
import java.io.File;
import org.apache.log4j.Logger;

public class WCMProcessServiceImpl
implements IWCMProcessService {
    private static Logger s_logger = Logger.getLogger(WCMProcessServiceImpl.class);
    private FlowServer m_oFlowServer = null;

    public WCMProcessServiceImpl() {
        try {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label1", "\u83b7\u53d6FlowServer\u5931\u8d25"), (Throwable)wCMException);
        }
    }

    public Flows getFlows(WCMFilter wCMFilter) throws WCMException {
        return Flows.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    public void deleteFlows(String string) throws WCMException {
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label2", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664\u5de5\u4f5c\u6d41\uff01"));
        }
        Flows flows = Flows.findByIds(this.getLoginUser(), string);
        Flow flow = null;
        for (int i = 0; i < flows.size(); ++i) {
            flow = (Flow)flows.getAt(i);
            if (flow == null) continue;
            this.getFlowMgr().delete(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reports saveFlow(String string) throws WCMException {
        Reports reports;
        block6: {
            User user = this.getLoginUser();
            if (!this.getLoginUser().isAdministrator()) {
                throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
            }
            File file = null;
            String string2 = null;
            try {
                try {
                    file = File.createTempFile("wcm", ".xml");
                    string2 = file.getPath();
                    CMyFile.writeFile(string2, string, "UTF-8");
                }
                catch (Exception exception) {
                    s_logger.error((Object)"fail to create the temp xml file", (Throwable)exception);
                    throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label4", "\u4ea7\u751f\u6587\u4ef6\u5931\u8d25!") + exception.getMessage());
                }
                FlowImporter flowImporter = new FlowImporter(user, 3);
                Reports reports2 = flowImporter.importFromFile(string2, null);
                if (!reports2.getFailedReporter().isEmpty()) {
                    throw new WCMException(reports2.getFailedReporterAt(0).getRportDetail());
                }
                reports = reports2;
                Object var9_9 = null;
                if (file == null) break block6;
                file.delete();
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_10 = null;
                    if (file == null) break block7;
                    file.delete();
                    file = null;
                }
                throw throwable;
            }
            file = null;
        }
        return reports;
    }

    public Reports importFlows(String string) throws WCMException {
        return this.importFlows(string, null);
    }

    public Reports importFlows(String string, String string2) throws WCMException {
        FlowImporter flowImporter = new FlowImporter(1);
        return flowImporter.importFromFile(string, string2);
    }

    public String exportFlow(int n) throws WCMException {
        return this.exportFlows(String.valueOf(n));
    }

    public String exportFlows(String string) throws WCMException {
        Flows flows = Flows.findByIds(this.getLoginUser(), string);
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        String string2 = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
        flowXmlConverter.toXMLFile(flows, string2);
        return CMyFile.extractFileName(string2);
    }

    public FlowDocs getFlowDocs(int n, WCMFilter wCMFilter) throws WCMException {
        return FlowServer.getFlowServer().getFlowDocs(this.getLoginUser(), n, wCMFilter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void submitTo(FlowParamers flowParamers) throws WCMException {
        this.m_oFlowServer.submitTo(flowParamers);
    }

    public void submitBack(User user, String string, String string2) throws WCMException {
        FlowDocs flowDocs = FlowDocs.findByIds(user, string);
        int n = flowDocs.size();
        FlowDoc flowDoc = null;
        for (int i = 0; i < n; ++i) {
            flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            this.m_oFlowServer.submitBack(user, flowDoc.getFlowContent(), string2);
        }
        flowDocs.clear();
    }

    public String toFlowXMLString(Flow flow) throws WCMException {
        if (flow == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label5", "\u6ca1\u6709\u6307\u5b9a\u5de5\u4f5c\u6d41"));
        }
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        return flowXmlConverter.toXMLString(flow);
    }

    public String toFlowsXMLString(String string) throws WCMException {
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        return flowXmlConverter.toXMLString(Flows.findByIds(this.getLoginUser(), string));
    }

    public void setFlowEmploy(BaseObj baseObj, int n) throws WCMException {
        this.getFlowEmployMgr().setFlow(baseObj, n);
    }

    public Flow getFlowOfEmployer(BaseObj baseObj) throws WCMException {
        return this.getFlowEmployMgr().getFlow(baseObj);
    }

    public FlowDoc startContentInFlow(int n, int n2) throws WCMException {
        IFlowContent iFlowContent = FlowContentHelper.createFlowContent(n, n2);
        if (iFlowContent == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label6", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9\u5f00\u59cb\u6d41\u8f6c\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5185\u5bb9\u5bf9\u8c61\uff01ContentTypeConfig:") + n + " ContentId:" + n2);
        }
        CMSObj cMSObj = iFlowContent.getSubinstance();
        String string = I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label7", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9[") + cMSObj + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label8", "]\u5f00\u59cb\u6d41\u8f6c");
        int n3 = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), cMSObj, n3)) {
            throw new WCMException(string + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label9", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUser().getName(), "FLOW_START", string, cMSObj);
        try {
            FlowDoc flowDoc = this.m_oFlowServer.startContentInFlow(this.getLoginUser(), iFlowContent);
            LogServer.endRecordSucceedOperation(l);
            return flowDoc;
        }
        catch (WCMException wCMException) {
            LogServer.endRecordFailedOperation(l, wCMException);
            throw new WCMException(string + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label10", "\u5931\u8d25!"), wCMException);
        }
    }

    public void forceContentEndInFlow(int n, int n2) throws WCMException {
        IFlowContent iFlowContent = FlowContentHelper.createFlowContent(n, n2);
        if (iFlowContent == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label6", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9\u5f00\u59cb\u6d41\u8f6c\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5185\u5bb9\u5bf9\u8c61\uff01ContentTypeConfig:") + n + " ContentId:" + n2);
        }
        CMSObj cMSObj = iFlowContent.getSubinstance();
        String string = I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label7", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9[") + cMSObj + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label11", "]\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c");
        int n3 = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), cMSObj, n3)) {
            throw new WCMException(string + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label9", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long l = LogServer.startRecord(this.getLoginUser().getName(), "FLOW_FORCE_END", string, cMSObj);
        try {
            this.m_oFlowServer.forceDocToEnd(iFlowContent, this.getLoginUser());
            LogServer.endRecordSucceedOperation(l);
        }
        catch (Exception exception) {
            LogServer.endRecordFailedOperation(l, exception);
            throw new WCMException(string + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label10", "\u5931\u8d25!"), exception);
        }
    }

    private FlowMgr getFlowMgr() {
        return (FlowMgr)DreamFactory.createObjectById("FlowMgr");
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    public FlowDoc getCurrentFlowDoc(int n, int n2) {
        return this.m_oFlowServer.getFlowDoc(n, n2);
    }

    public String getCurrFlowFlagDesc(int n, int n2) throws WCMException {
        return ProcessConstants.getFlagDesc(this.getCurrFlowFlag(n, n2));
    }

    public int getCurrFlowFlag(int n, int n2) throws WCMException {
        return this.m_oFlowServer.getCurrFlowFlag(n, n2);
    }

    public FlowDocs getFlowDocsOfContent(int n, int n2) throws WCMException {
        return this.m_oFlowServer.getFlowDocsOfContent(n, n2);
    }

    public void submitAgain(User user, int n, String string) throws WCMException {
        this.m_oFlowServer.submitAgain(user, n, string);
    }

    public FlowDocs getSubmitFlowDocs(User user, WCMFilter wCMFilter) throws WCMException {
        return this.m_oFlowServer.getSubmitFlowDocs(user, wCMFilter);
    }

    public boolean isCanInFlow(int n, int n2) throws WCMException {
        IFlowContent iFlowContent = FlowContentHelper.createFlowContent(n, n2);
        if (iFlowContent == null) {
            return false;
        }
        int n3 = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), iFlowContent.getSubinstance(), n3)) {
            return false;
        }
        return this.m_oFlowServer.isCanInFlow(iFlowContent);
    }
}

