/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import com.trs.service.ICDSService;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CDSServiceImpl
implements ICDSService {
    private static Logger logger = Logger.getLogger(CDSServiceImpl.class);
    private static final String XML_ENCODING = "GBK";

    public String getSystemInfo(String string, int n, int n2) throws WCMException {
        return this.getSystemInfo(string, n, n2, null, null);
    }

    public String getSystemInfo(String string, int n, int n2, String string2, String string3) throws WCMException {
        if (string == null) {
            throw new WCMDatainvalidException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label1", "\u6ca1\u6709\u4f20\u5165\u6307\u5b9a\u7684Type\uff01"));
        }
        String string4 = string.toUpperCase();
        if (string4.equals("CDS1") || string4.equals("CDS2")) {
            boolean bl = string4.equals("CDS2");
            if (n <= 0) {
                return this.getAllChannelsXML(bl);
            }
            WebSite webSite = WebSite.findById(n);
            if (webSite == null) {
                throw new WCMException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[SiteId=") + n + "].");
            }
            return this.toXMLInfo(webSite, bl, string2, string3);
        }
        if (string4.equals("CDS3")) {
            Channel channel = Channel.findById(n2);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053[ChannelId=") + n2 + "].");
            }
            Element element = this.toCDSXMLElement(channel);
            WebSite webSite = channel.getSite();
            WebSites webSites = new WebSites(null);
            webSites.addElement(webSite);
            ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
            Element element2 = objToXmlConverter.toXmlElement(webSites, null);
            Element element3 = DocumentHelper.createElement((String)"WCMCHANNELS");
            element3.add(element);
            element2.element("WCMWEBSITE").add(element3);
            return element2.asXML();
        }
        throw new WCMDatainvalidException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label4", "\u6ca1\u6709\u4f20\u5165\u6307\u5b9a\u7684Type[") + string4 + I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label5", "]\u65e0\u6548\uff01"));
    }

    public String getChannelsXML(BaseChannel baseChannel, boolean bl) throws WCMException {
        return this.toXMLInfo(baseChannel, bl, null, null);
    }

    public String getAllChannelsXML(boolean bl) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "Status>=0", "", "SiteOrder");
        WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
        return this.toXMLInfo(webSites, bl, null, null);
    }

    private String toXMLInfo(Object object, boolean bl, String string, String string2) throws WCMException {
        ChannelExporter channelExporter = new ChannelExporter(string, string2);
        channelExporter.setXMLEncoding(XML_ENCODING);
        return channelExporter.exportToXMLContent(object, bl, false);
    }

    private String getChannelWhere(Channel channel) {
        boolean bl;
        Object object;
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        String string = null;
        try {
            object = iFolderPubStatusCacheMgr.findStatusesCanDoPub(103, channel.getSiteId());
            string = "WCMCHNLDOC.DOCSTATUS in(" + object[0];
            int n = ((int[])object).length;
            for (int i = 1; i < n; ++i) {
                string = string + "," + object[i];
            }
            string = string + ")";
        }
        catch (Exception exception) {
            string = "WCMCHNLDOC.DOCSTATUS =10";
            logger.error((Object)I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label6", "\u83b7\u53d6\u7ad9\u70b9\u53ef\u53d1\u5e03\u72b6\u6001\u5931\u8d25\uff01"), (Throwable)exception);
        }
        object = string + " and WCMDocument.DocChannel>0 and WCMDocument.DocStatus>0";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = channel.getQuery();
        boolean bl2 = bl = CMyString.isEmpty(string2) || !channel.isOnlySearch();
        if (bl) {
            stringBuffer.append("WCMCHNLDOC").append(".CHNLID=" + channel.getId());
            stringBuffer.append(" AND ");
        }
        stringBuffer.append("WCMCHNLDOC").append(".DOCID=");
        stringBuffer.append("WCMDOCUMENT").append(".DOCID");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" AND (").append(string2).append(')');
        }
        if (channel.isOnlySearch()) {
            stringBuffer.append(" AND (").append("WCMCHNLDOC").append(".MODAL=").append(1).append(')');
        }
        object = (String)object + " and (" + stringBuffer.toString() + ")";
        return object;
    }

    private Element toCDSXMLElement(Channel channel) throws WCMException {
        channel.getProperties().put("CDSCHNLSQL", this.getChannelWhere(channel));
        String string = null;
        String string2 = channel.getOrderBy();
        if (string2 != null && string2.trim().length() > 0) {
            string = string2;
            string2 = this.filterOrderForChannel(string2);
            channel.getProperties().put("CHNLORDERBY", string2);
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        Element element = objToXmlConverter.toXmlElement(channel);
        channel.getProperties().remove("CDSCHNLSQL");
        if (string != null) {
            channel.getProperties().put("CHNLORDERBY", string);
        }
        if (channel.getChildrenSize(null) == 0) {
            return element;
        }
        Element element2 = DocumentHelper.createElement((String)"WCMCHANNELS");
        List list = channel.getChildren(null);
        for (int i = 0; i < list.size(); ++i) {
            Element element3;
            Channel channel2 = (Channel)list.get(i);
            if (channel2 == null || (element3 = this.toCDSXMLElement(channel2)) == null) continue;
            element2.add(element3);
        }
        element.add(element2);
        return element;
    }

    private String filterOrderForChannel(String string) throws WCMException {
        String string2 = "";
        DBManager dBManager = DBManager.getDBManager();
        if (ChnlDoc.IS_ORDER_BY_PRI) {
            string2 = "WCMCHNLDOC.DOCORDERPRI desc,";
        }
        string2 = string2 + "WCMCHNLDOC.DOCORDER desc ";
        if (string == null || string.length() == 0) {
            return string2;
        }
        TableInfo tableInfo = dBManager.getTableInfo("WCMDOCUMENT");
        if (tableInfo == null) {
            return string2;
        }
        TableInfo tableInfo2 = dBManager.getTableInfo("WCMCHNLDOC");
        if (tableInfo2 == null) {
            return string2;
        }
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = -1;
        do {
            String string4 = (String)stringTokenizer.nextElement();
            string4 = string4.trim();
            ++n;
            int n2 = string4.indexOf(" ");
            String string5 = "";
            String string6 = "";
            if (n2 < 0) {
                string5 = string4;
                string6 = "asc";
            } else {
                string5 = string4.substring(0, n2).toUpperCase();
                string6 = string4.substring(n2).toUpperCase();
            }
            int n3 = string5.indexOf(".");
            if (n3 >= 0) {
                if (n > 0) {
                    string3 = string3 + "," + string5 + " " + string6;
                    continue;
                }
                string3 = string5 + " " + string6;
                continue;
            }
            if (tableInfo.getFieldInfo(string5) != null) {
                string5 = "WCMDOCUMENT." + string5;
            } else if (tableInfo2.getFieldInfo(string5) != null) {
                string5 = "WCMCHNLDOC." + string5;
            } else {
                Exception exception = new Exception(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label7", "\u5b57\u6bb5\u4e0d\u5b58\u5728!"));
                throw new WCMException(10, I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label8", "\u6307\u5b9a\u7684\u6392\u5e8f\u5b57\u6bb5[") + string5 + I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label9", "]\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!"), exception);
            }
            string3 = n > 0 ? string3 + "," + string5 + " " + string6 : string5 + " " + string6;
        } while (stringTokenizer.hasMoreElements());
        return string3;
    }
}

