/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarkMgr;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.service.IBookMarkService;
import java.util.StringTokenizer;

public class BookMarkService
implements IBookMarkService {
    private BookMarkMgr currMgr = null;

    private BookMarkMgr getBookMarkMgr() throws WCMException {
        if (this.currMgr != null) {
            return this.currMgr;
        }
        this.currMgr = (BookMarkMgr)DreamFactory.createObjectById("BookMarkMgr");
        if (this.currMgr == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label1", "BookMarkMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return this.currMgr;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public BookMark save(BookMark bookMark) throws WCMException {
        return this.getBookMarkMgr().saveBookMark(bookMark);
    }

    public boolean deleteBookMark(int n) throws WCMException {
        return this.getBookMarkMgr().deleteBookMark(BookMark.findById(n));
    }

    public boolean deleteBookMark(String string) throws WCMException {
        BookMarks bookMarks = BookMarks.findByIds(this.getLoginUser(), string);
        if (bookMarks == null || bookMarks.isEmpty()) {
            return true;
        }
        for (int i = 0; i < bookMarks.size(); ++i) {
            BookMark bookMark = (BookMark)bookMarks.getAt(i);
            this.getBookMarkMgr().deleteBookMark(bookMark);
        }
        return true;
    }

    public boolean deleteMarkKind(int n) throws WCMException {
        return this.getBookMarkMgr().deleteMarkKind(MarkKind.findById(n));
    }

    public boolean deleteMarkKind(String string) throws WCMException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.deleteMarkKind(Integer.parseInt(stringTokenizer.nextToken()));
        }
        return true;
    }

    public void moveBookMark(int n, int n2) throws WCMException {
        this.getBookMarkMgr().moveBookMark(BookMark.findById(n), MarkKind.findById(n2));
    }

    public void moveBookMark(String string, int n) throws WCMException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.moveBookMark(Integer.parseInt(stringTokenizer.nextToken()), n);
        }
    }

    public Reports moveBookMarks(String string, int n) throws WCMException {
        BookMarks bookMarks = BookMarks.findByIds(this.getLoginUser(), string);
        MarkKind markKind = MarkKind.findById(n);
        if (markKind == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label2", "\u6ca1\u6709\u627e\u5230\u76ee\u6807\u6587\u4ef6\u5939[id=") + n + "]!");
        }
        Reports reports = new Reports("");
        BookMarkMgr bookMarkMgr = this.getBookMarkMgr();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < bookMarks.size(); ++i) {
            BookMark bookMark = (BookMark)bookMarks.getAt(i);
            if (bookMark == null) continue;
            try {
                bookMarkMgr.moveBookMark(bookMark, markKind);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(BookMarkService.class, "BookMarkService.label11", "\u79fb\u52a8\u4e66\u7b7e\u4ece{0}\u5230{1}\u6210\u529f."), new Object[]{bookMark, markKind}));
                ++n2;
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(BookMarkService.class, "BookMarkService.label12", "\u79fb\u52a8\u4e66\u7b7e\u4ece{0}\u5230{1}\u5931\u8d25."), new Object[]{bookMark, markKind}), throwable);
                ++n3;
            }
        }
        if (n3 > 0) {
            reports.setTitle(I18NMessage.get(BookMarkService.class, "BookMarkService.label13", "\u79fb\u52a8\u4e66\u7b7e\u5931\u8d25"));
        } else {
            reports.setTitle(I18NMessage.get(BookMarkService.class, "BookMarkService.label14", "\u79fb\u52a8\u4e66\u7b7e\u6210\u529f"));
        }
        return reports;
    }

    public BookMarks getBookMarks(int n) throws WCMException {
        return this.getBookMarks(n, null);
    }

    public BookMarks getBookMarks(int n, WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarkMgr().getBookMarks(n, wCMFilter);
    }

    public BookMarks getBookMarks(WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarkMgr().getBookMarks(wCMFilter);
    }

    public MarkKinds getChildren(int n, WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarkMgr().getChildren(MarkKind.findById(n), wCMFilter);
    }

    public BookMarks getSharedBookMarks(User user, WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarkMgr().getSharedBookMarks(user, wCMFilter);
    }

    public MarkKinds getSharedMarkKinds(User user, WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarkMgr().getSharedMarkKinds(user, wCMFilter);
    }

    public void moveMarkKind(int n, int n2) throws WCMException {
        this.getBookMarkMgr().moveMarkKind(MarkKind.findById(n), MarkKind.findById(n2));
    }

    public MarkKind save(MarkKind markKind) throws WCMException {
        return this.getBookMarkMgr().saveMarkKind(markKind);
    }

    public Groups getSharedGroups(int n, int n2) throws WCMException {
        CMSObj cMSObj = null;
        switch (n) {
            case 303: {
                cMSObj = BookMark.findById(n2);
                break;
            }
            case 307: {
                cMSObj = MarkKind.findById(n2);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        return this.getBookMarkMgr().getSharedGroups(n, cMSObj);
    }

    public Users getSharedUsers(int n, int n2) throws WCMException {
        CMSObj cMSObj = null;
        switch (n) {
            case 303: {
                cMSObj = BookMark.findById(n2);
                break;
            }
            case 307: {
                cMSObj = MarkKind.findById(n2);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        return this.getBookMarkMgr().getSharedUsers(n, cMSObj);
    }

    public void cancelShares(int n, String string) throws WCMException {
        CMSBaseObjs cMSBaseObjs = null;
        switch (n) {
            case 303: {
                cMSBaseObjs = BookMarks.findByIds(this.getLoginUser(), string);
                break;
            }
            case 307: {
                cMSBaseObjs = MarkKinds.findByIds(this.getLoginUser(), string);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        this.getBookMarkMgr().cancelShares(n, cMSBaseObjs);
    }

    public void moveMarkKind(String string, int n) throws WCMException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.moveMarkKind(Integer.parseInt(stringTokenizer.nextToken()), n);
        }
    }

    public void shareTo(int n, String string, int n2, String string2) throws WCMException {
        CMSBaseObjs cMSBaseObjs = null;
        switch (n) {
            case 303: {
                cMSBaseObjs = BookMarks.findByIds(this.getLoginUser(), string);
                break;
            }
            case 307: {
                cMSBaseObjs = MarkKinds.findByIds(this.getLoginUser(), string);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        this.getBookMarkMgr().shareTo(n, cMSBaseObjs, n2, string2);
    }
}

