/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.service.ITemplateService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SceneAutoCreator {
    private WebSites oWebSites = null;
    private WebSite newSite = null;
    private String localPath = null;
    private String sNewFileName = null;
    private BaseChannel baseChannel = null;
    private ITemplateService currTemplateService = (ITemplateService)DreamFactory.createObjectById("ITemplateService");
    private WCMFolderPublishConfig currPublishConfig = null;

    public int Create() throws Exception {
        WCMFilter wCMFilter = new WCMFilter("", "SITENAME=?", "");
        wCMFilter.addSearchValues(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.oWebSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (!this.oWebSites.isEmpty()) {
            return this.oWebSites.getIdAt(0);
        }
        int n = this.createSite();
        this.localPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.localPath = CMyString.setStrEndWith(this.localPath, File.separatorChar);
        this.localPath = this.localPath + "scene" + File.separatorChar + "data" + File.separatorChar + "default_load.zip";
        this.sNewFileName = FilesMan.getFilesMan().getNextFilePathName("U0", "zip");
        CMyFile.copyFile(this.localPath, this.sNewFileName);
        this.baseChannel = this.newSite;
        this.currTemplateService.importFromZip(this.baseChannel, this.sNewFileName, 1, 1, null);
        this.changeTempName();
        this.copyImage();
        return n;
    }

    private int createSite() throws WCMException {
        User user = this.getLoginUser();
        this.newSite = WebSite.createNewInstance();
        this.newSite.setName(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.newSite.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.newSite.setParent(0);
        this.newSite.save();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(103, this.newSite.getId());
        this.currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
        this.currPublishConfig.setFolderType(103, this.newSite.getId());
        this.currPublishConfig.setDataPath("scene");
        this.currPublishConfig.setRootDomain("http://127.0.0.1:8080/pub/scene");
        this.currPublishConfig.canEdit(user);
        this.currPublishConfig.setDefineStatus(true);
        this.currPublishConfig.setStatusesCanDoPub("10,1,2");
        this.currPublishConfig.setPageEncoding("UTF-8");
        this.currPublishConfig.save(user);
        return this.newSite.getId();
    }

    public void changeTempName() throws CMyException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.baseChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        String string = ConfigServer.getServer().getInitProperty("WCM_PATH");
        string = CMyString.setStrEndWith(string, File.separatorChar);
        String string2 = string + "scene" + File.separatorChar + "images" + File.separatorChar + "moban.gif";
        String string3 = FilesMan.getFilesMan().getNextFilePathName("P0", "gif");
        CMyFile.copyFile(string2, string3);
        String string4 = CMyFile.extractFileName(string3);
        Template template = templateCacheMgr.lookupByName(iPublishFolder, I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label2", "scene_defaultIndex_HTML"));
        template.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label3", "\u573a\u666f\u5f0f"));
        template.setAttribute("TempPicName", string4);
        template.save();
        template = templateCacheMgr.lookupByName(iPublishFolder, "scene_documentList");
        template.setOutputFileName("documentlist");
        template.save();
        template = templateCacheMgr.lookupByName(iPublishFolder, "scene_serviceProcess_XML");
        template.setOutputFileName("scene");
        template.save();
        String string5 = string + "scene" + File.separatorChar + "images" + File.separatorChar + "flash.gif";
        String string6 = FilesMan.getFilesMan().getNextFilePathName("P0", "gif");
        CMyFile.copyFile(string5, string6);
        String string7 = CMyFile.extractFileName(string6);
        template = templateCacheMgr.lookupByName(iPublishFolder, "scene_defaultIndex_Flash");
        template.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label3", "\u573a\u666f\u5f0f"));
        template.setAttribute("TempPicName", string7);
        template.save();
    }

    public void copyImage() throws CMyException {
        String string = ConfigServer.getServer().getInitProperty("WCM_PATH");
        string = CMyString.setStrEndWith(string, File.separatorChar);
        String string2 = string + "scene" + File.separatorChar + "data" + File.separator + "images";
        String string3 = FilesMan.getFilesMan().getPathConfigValue("LV", 0);
        String[] stringArray = string3.split(";");
        String string4 = stringArray[0];
        string4 = string4 + File.separatorChar + "scene";
        File file = new File(string2);
        File file2 = new File(string4);
        SceneAutoCreator.copy(file, file2);
        String string5 = FilesMan.getFilesMan().getPathConfigValue("LP", 0);
        String[] stringArray2 = string5.split(";");
        String string6 = stringArray2[0];
        string6 = string6 + File.separatorChar + "scene";
        File file3 = new File(string6);
        SceneAutoCreator.copy(file, file3);
    }

    public void deleteAll() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SITENAME=?", "");
        wCMFilter.addSearchValues(0, I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        WebSites webSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (webSites.size() != 0) {
            webSites.removeAll(true);
        }
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    public static void copy(File file, File file2) {
        File file3 = new File(file2, file.getName());
        if (file.isDirectory()) {
            file3.mkdir();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                SceneAutoCreator.copy(fileArray[i], file3);
            }
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

