/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.parser;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.scene.parser.SceneConnector;
import com.trs.scene.parser.SceneNode;
import java.util.ArrayList;

public class ScenePathsParser {
    private SceneNode m_oFirstNode = null;
    private ArrayList m_arNodeStack = new ArrayList();

    public ScenePathsParser(SceneNode sceneNode) {
        this.m_oFirstNode = sceneNode;
    }

    public SceneConnector[][] parse() throws WCMException {
        SceneNode sceneNode = this.m_oFirstNode;
        SceneConnector[][] sceneConnectorArray = new SceneConnector[1][];
        SceneConnector[] sceneConnectorArray2 = new SceneConnector[]{};
        sceneConnectorArray[0] = this.parser(sceneNode, sceneConnectorArray2, 0);
        if (!this.m_arNodeStack.isEmpty()) {
            StackNode stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
            int n = 1;
            while (stackNode != null) {
                SceneConnector[] sceneConnectorArray3 = this.parser(stackNode.m_oNode, stackNode.m_path, stackNode.m_nConnectorIndex + 1);
                SceneConnector[][] sceneConnectorArrayArray = new SceneConnector[sceneConnectorArray.length + 1][];
                System.arraycopy(sceneConnectorArray, 0, sceneConnectorArrayArray, 0, sceneConnectorArray.length);
                sceneConnectorArrayArray[sceneConnectorArray.length] = sceneConnectorArray3;
                sceneConnectorArray = sceneConnectorArrayArray;
                if (this.m_arNodeStack.isEmpty()) break;
                stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
                ++n;
            }
        }
        return sceneConnectorArray;
    }

    private SceneConnector[] parser(SceneNode sceneNode, SceneConnector[] sceneConnectorArray, int n) throws WCMException {
        if (sceneNode == null) {
            return sceneConnectorArray;
        }
        ArrayList arrayList = sceneNode.getNextConnectors();
        if (arrayList == null) {
            return sceneConnectorArray;
        }
        int n2 = arrayList.size();
        if (n2 == 0 || n >= n2) {
            return sceneConnectorArray;
        }
        SceneConnector sceneConnector = (SceneConnector)arrayList.get(n);
        for (int i = 0; i < sceneConnectorArray.length; ++i) {
            if (sceneConnectorArray[i].getId() != sceneConnector.getId()) continue;
            throw new WCMException(I18NMessage.get(ScenePathsParser.class, "ScenePathsParser.label1", "\u5f53\u524d\u7684\u573a\u666f\u5b58\u5728\u56de\u8def\uff01\u8fde\u7ebf\u4fe1\u606f\u4e3a:Name=[") + sceneConnector.getName() + "] ID=[" + sceneConnector.getId() + "] StartNode=[" + sceneConnector.getPreNode().getName() + "] EndNode=[" + sceneConnector.getNextNode().getName() + "]");
        }
        SceneConnector[] sceneConnectorArray2 = new SceneConnector[sceneConnectorArray.length + 1];
        sceneConnectorArray2[sceneConnectorArray.length] = sceneConnector;
        if (sceneConnectorArray.length > 0) {
            System.arraycopy(sceneConnectorArray, 0, sceneConnectorArray2, 0, sceneConnectorArray.length);
        }
        StackNode stackNode = null;
        if (!this.m_arNodeStack.isEmpty()) {
            stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
        }
        if (stackNode != null && stackNode.m_oNode == sceneNode) {
            if (n + 1 == n2) {
                this.m_arNodeStack.remove(this.m_arNodeStack.size() - 1);
            } else {
                ++stackNode.m_nConnectorIndex;
            }
        } else if (n2 > 1) {
            stackNode = new StackNode(sceneNode, n, sceneConnectorArray);
            this.m_arNodeStack.add(stackNode);
        }
        return this.parser(sceneConnector.getNextNode(), sceneConnectorArray2, 0);
    }

    private class StackNode {
        public SceneNode m_oNode = null;
        public int m_nConnectorIndex = 0;
        public SceneConnector[] m_path = null;

        public StackNode(SceneNode sceneNode, int n, SceneConnector[] sceneConnectorArray) {
            this.m_oNode = sceneNode;
            this.m_nConnectorIndex = n;
            this.m_path = sceneConnectorArray;
        }
    }
}

