/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.FieldInfo;
import com.trs.presentation.util.DefaultWhereSQLMaker;
import com.trs.presentation.util.PageParameter;
import com.trs.presentation.util.PageParameters;
import com.trs.presentation.util.WhereSQLMaker;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHelper {
    private Hashtable m_hParameterValue;
    private HttpServletRequest m_oRequest;
    private HttpServletResponse m_oResponse;
    private ServletContext m_oServletContext;
    private boolean m_bParsed = false;
    private boolean m_bPostMethod = false;
    private static final int MAX_ROW_NUM = 1000;
    public static final String PARAM_NAME_SEARCH_KEY = "SearchKey";
    public static final String PARAM_NAME_SEARCH_TABLE = "SearchTable";
    public static final String PARAM_NAME_SEARCH_VALUE = "SearchValue";
    public static final String PARAM_NAME_ORDER_FIELD = "OrderField";
    public static final String PARAM_NAME_ORDER_TYPE = "OrderType";
    private PageParameters m_oPageParameters = null;
    private HashMap m_hNameMap = null;

    public RequestHelper() {
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
        this.m_bParsed = true;
    }

    public RequestHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        this.setRequest(httpServletRequest);
        this.setResponse(httpServletResponse);
        this.m_oServletContext = servletContext;
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
    }

    public RequestHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext, boolean bl) {
        this(httpServletRequest, httpServletResponse, servletContext);
        this.m_bPostMethod = bl;
        this.m_hParameterValue = new Hashtable();
        this.m_hNameMap = new HashMap();
    }

    public HttpServletRequest getRequest() {
        return this.m_oRequest;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this.m_oRequest = httpServletRequest;
    }

    public HttpServletResponse getResponse() {
        return this.m_oResponse;
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        this.m_oResponse = httpServletResponse;
    }

    public void doValid() throws WCMException {
        this.doValid(false);
    }

    public void doValid(boolean bl) throws WCMException {
        if (this.m_oRequest == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label1", "\u6307\u5b9a\u7684HttpServletRequest\u5bf9\u8c61\u65e0\u6548!"));
        }
        String string = this.m_oRequest.getRequestURI();
        String string2 = CMyFile.extractHttpFileName(string);
        String string3 = this.m_oRequest.getContextPath();
        String string4 = string.substring(string3.length());
        String string5 = CMyFile.extractFilePath(this.m_oServletContext.getRealPath(string4));
        int n = string2.indexOf(".");
        String string6 = "";
        string6 = n > 0 ? string2.substring(0, n) : string2;
        String string7 = string5 + string6 + ".xml";
        if (!CMyFile.fileExists(string7)) {
            if (bl) {
                throw new WCMException(55, I18NMessage.get(RequestHelper.class, "RequestHelper.label2", "\u9875\u9762\u914d\u7f6e\u6587\u4ef6[") + string6 + ".xml" + I18NMessage.get(RequestHelper.class, "RequestHelper.label3", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            return;
        }
        this.m_oPageParameters = PageParameters.getParametersOfPage(string2, string5);
        Enumeration enumeration = this.m_oRequest.getParameterNames();
        PageParameter pageParameter = null;
        while (enumeration.hasMoreElements()) {
            String string8;
            String string9 = (String)enumeration.nextElement();
            pageParameter = null;
            int n2 = this.m_oPageParameters.size();
            for (int i = 0; i < n2; ++i) {
                PageParameter pageParameter2 = (PageParameter)this.m_oPageParameters.get(i);
                if (!pageParameter2.getName().equalsIgnoreCase(string9)) continue;
                pageParameter = pageParameter2;
                break;
            }
            if (((string8 = this.getValueFromRequest(string9)) == null || (string8 = string8.trim()).length() == 0) && pageParameter != null) {
                string8 = CMyString.showNull(pageParameter.getDefault());
            }
            if (string8 == null || CMyString.isEmpty(string8) && pageParameter != null && !"string".equalsIgnoreCase(pageParameter.getType())) continue;
            this.setValue(string9, string8);
        }
        this.m_bParsed = true;
        for (int i = 0; i < this.m_oPageParameters.size(); ++i) {
            pageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (pageParameter == null) continue;
            this.doValidAndSaveParamValue(pageParameter);
        }
        this.putPageMaxCount();
    }

    private void putPageMaxCount() throws WCMException {
        String string = (String)this.getValue("PageMaxCount");
        if (CMyString.isEmpty(string)) {
            this.setValue("PageMaxCount", "1000");
        }
    }

    private boolean existPageMaxCount() throws WCMException {
        String string = (String)this.getValue("PageMaxCount");
        return string != null;
    }

    private void validTypeOfParamValue(PageParameter pageParameter, String string) throws WCMException {
        String string2 = pageParameter.getType().toLowerCase();
        if (string2.equals("string")) {
            return;
        }
        if (string2.equals("int")) {
            try {
                Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + pageParameter.getDesc() + "][" + pageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + string + I18NMessage.get(RequestHelper.class, "RequestHelper.label6", "]\u4e0d\u662f\u6574\u578b\u6570"), exception);
            }
        }
        if (string2.equals("long")) {
            try {
                Long.parseLong(string);
            }
            catch (Exception exception) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + pageParameter.getDesc() + "][" + pageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + string + I18NMessage.get(RequestHelper.class, "RequestHelper.label7", "]\u4e0d\u662f\u957f\u6574\u578b"));
            }
        }
        if (string2.equals("boolean")) {
            try {
                int n = Integer.parseInt(string);
                if (n != 1 && n != 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + pageParameter.getDesc() + "][" + pageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + string + I18NMessage.get(RequestHelper.class, "RequestHelper.label8", "]\u4e0d\u662f\u5e03\u5c14\u578b"));
            }
        }
        if (string2.equals("float")) {
            try {
                Float.parseFloat(string);
            }
            catch (Exception exception) {
                throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label4", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + pageParameter.getDesc() + "][" + pageParameter.getName() + I18NMessage.get(RequestHelper.class, "RequestHelper.label5", "]\u7c7b\u578b\u4e0d\u5bf9![") + string + I18NMessage.get(RequestHelper.class, "RequestHelper.label9", "]\u4e0d\u662f\u6d6e\u70b9\u6570"));
            }
        }
    }

    private String getValueFromRequest(String string) {
        String[] stringArray = this.m_oRequest.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return CMyString.getStr(stringArray[0], this.m_bPostMethod);
        }
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = i == 0 ? CMyString.getStr(stringArray[i], this.m_bPostMethod) : string2 + "," + CMyString.getStr(stringArray[i], this.m_bPostMethod);
        }
        return string2;
    }

    private Object getValue(String string) throws WCMException {
        String string2;
        if (!this.m_bParsed) {
            this.doValid(true);
        }
        if ((string2 = (String)this.m_hNameMap.get(string.toUpperCase())) == null) {
            string2 = string;
        }
        return this.m_hParameterValue.get(string2);
    }

    public String getString(String string) throws WCMException {
        Object object = this.getValue(string);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public CMyDateTime getDateTime(String string) throws WCMException {
        Object object = this.getValue(string);
        if (object == null) {
            return null;
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString((String)object);
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label10", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u65e5\u671f\u578b\uff01[") + object + "]");
        }
        return cMyDateTime;
    }

    public CMyDateTime getDateTime(String string, String string2) throws WCMException {
        Object object = this.getValue(string);
        if (object == null) {
            return null;
        }
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateTimeWithString((String)object, string2);
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label10", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u65e5\u671f\u578b\uff01[") + object + "]");
        }
        return cMyDateTime;
    }

    public long getLong(String string, long l) throws WCMException {
        Object object = this.getValue(string);
        if (object == null) {
            return l;
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label11", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u957f\u6574\u578b\uff01[") + object + "]");
        }
    }

    public int getInt(String string, int n) throws WCMException {
        Object object = this.getValue(string);
        if (object == null) {
            return n;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(RequestHelper.class, "RequestHelper.label12", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u6574\u578b\uff01[") + object + "]");
        }
    }

    public boolean getBoolean(String string, boolean bl) throws WCMException {
        int n = this.getInt(string, bl ? 1 : 0);
        return n != 0;
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.m_hParameterValue.keys();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object v = this.m_hParameterValue.get(object);
            if (v == null) continue;
            string = string + "Parameter Name:" + object.toString() + "     Parameter Value:" + v + "\n";
        }
        return string;
    }

    public String toURL() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        return this.m_oRequest.getRequestURI() + "?" + this.toURLParameters();
    }

    public String toURLParameters() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String string = "";
        Enumeration enumeration = this.m_hParameterValue.keys();
        Object object = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object v;
            object = enumeration.nextElement();
            if (object.equals("PageMaxCount") && !this.existPageMaxCount() || (v = this.m_hParameterValue.get(object)) == null) continue;
            if (bl) {
                string = string + "&";
            } else {
                bl = true;
                string = "";
            }
            string = string + object.toString() + "=" + CMyString.URLEncode(v.toString());
        }
        return string;
    }

    public String toHTMLHidden() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String string = "";
        Enumeration enumeration = this.m_hParameterValue.keys();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            Object v;
            object = enumeration.nextElement();
            if (object.equals("PageMaxCount") && !this.existPageMaxCount() || (v = this.m_hParameterValue.get(object)) == null) continue;
            string = string + "<input type=hidden name=\"" + CMyString.filterForHTMLValue(object.toString()) + "\" value=\"" + CMyString.filterForHTMLValue(v.toString()) + "\">\n";
        }
        return string;
    }

    public String toTRSRequestParam() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String string = "<script>\n";
        Enumeration enumeration = this.m_hParameterValue.keys();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            Object v;
            object = enumeration.nextElement();
            if (object.equals("PageMaxCount") && !this.existPageMaxCount() || (v = this.m_hParameterValue.get(object)) == null) continue;
            string = string + "TRSRequestParam.setParameter(\"" + CMyString.filterForJs(object.toString()) + "\", \"" + CMyString.filterForJs(v.toString()) + "\");\n";
        }
        string = string + "</script>";
        return string;
    }

    public String toInitSearchJavaScript() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String string = "<script>\n" + I18NMessage.get(RequestHelper.class, "RequestHelper.label13", "//\u521d\u59cb\u5316\u68c0\u7d22Form\n") + " var frmSearch = document.frmSearch;";
        int n = this.m_oPageParameters.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            PageParameter pageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (pageParameter == null || !pageParameter.isSearch() || (string3 = pageParameter.getName()).equals("PageMaxCount") && !this.existPageMaxCount() || (string2 = (String)this.m_hParameterValue.get(string3)) == null) continue;
            string = string + "    //" + pageParameter.getDesc() + "\n";
            string = string + "    frmSearch." + string3 + ".value=" + this.getInitSearchValue(pageParameter, string2) + ";\n";
        }
        string = string + "</script>";
        return string;
    }

    private String getInitSearchValue(PageParameter pageParameter, String string) {
        String string2 = CMyString.filterForJs(string);
        int n = pageParameter.getType().hashCode();
        switch (n) {
            case -891985903: {
                return "\"" + string2 + "\"";
            }
            case 3076014: 
            case 3560141: 
            case 1793702779: {
                return "\"" + string2 + "\"";
            }
        }
        return string2;
    }

    public void reloadPageConfig() throws WCMException {
        String string = this.m_oRequest.getHeader("referer");
        String string2 = CMyFile.extractHttpFileName(string);
        int n = string2.indexOf("?");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        String string3 = this.m_oRequest.getScheme() + "://" + this.m_oRequest.getServerName();
        if (this.m_oRequest.getServerPort() != 80) {
            string3 = string3 + ":" + this.m_oRequest.getServerPort();
        }
        string3 = string3 + this.m_oRequest.getContextPath();
        int n2 = string.toLowerCase().indexOf(string3.toLowerCase());
        if (n2 < 0) {
            System.out.println("Error Request:" + string);
        }
        String string4 = string.substring(n2 + string3.length());
        String string5 = CMyFile.extractFilePath(this.m_oServletContext.getRealPath(string4));
        PageParameters.reloadParametersOfPageName(string2, string5);
    }

    public void removePageConfig(String string) {
        PageParameters.removeParametersOfPageName(string);
    }

    public String getSearchKey() throws WCMException {
        if (CMyString.isEmpty(this.getString(PARAM_NAME_SEARCH_KEY))) {
            return null;
        }
        return CMyString.filterForHTMLValue(this.getString(PARAM_NAME_SEARCH_KEY).replaceAll("(?i)[;'\n\r\\-]|delete|update|insert", ""));
    }

    public void setSearchKey(String string) {
        this.setValue(PARAM_NAME_SEARCH_KEY, string);
    }

    public String getSearchValue() throws WCMException {
        return this.getString(PARAM_NAME_SEARCH_VALUE);
    }

    public void setSearchValue(String string) {
        this.setValue(PARAM_NAME_SEARCH_VALUE, string);
    }

    private void doValidAndSaveParamValue(PageParameter pageParameter) throws WCMException {
        String string = (String)this.getValue(pageParameter.getName());
        if (pageParameter.isRequired() && string == null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(RequestHelper.class, "RequestHelper.label14", "\u9875\u9762\u6240\u9700\u53c2\u6570[{0}]\u6ca1\u6709\u4f20\u5165!"), new String[]{pageParameter.getName()}));
        }
        if (!CMyString.isEmpty(string)) {
            this.validTypeOfParamValue(pageParameter, string);
        }
        if (CMyString.isEmpty(string) && pageParameter.getDefault() != null) {
            this.setValue(pageParameter.getName(), pageParameter.getDefault());
        }
    }

    public Object setValue(String string, String string2) {
        String string3 = string.toUpperCase();
        if (!this.m_hNameMap.containsKey(string3)) {
            this.m_hNameMap.put(string3, string);
        }
        return this.m_hParameterValue.put(string, string2);
    }

    public String getSearchTableName() throws WCMException {
        return this.getString(PARAM_NAME_SEARCH_TABLE);
    }

    public void setSearchTableName(String string) {
        this.setValue(PARAM_NAME_SEARCH_TABLE, string);
    }

    public String getOrderField() throws WCMException {
        return this.getString(PARAM_NAME_ORDER_FIELD);
    }

    public void setOrderField(String string) {
        this.setValue(PARAM_NAME_ORDER_FIELD, string);
    }

    public String getOrderType() throws WCMException {
        return this.getString(PARAM_NAME_ORDER_TYPE);
    }

    public void setOrderType(String string) {
        this.setValue(PARAM_NAME_ORDER_TYPE, string);
    }

    public WCMFilter getPageFilter(WCMFilter wCMFilter) throws WCMException {
        int n;
        WhereSQLMaker whereSQLMaker = new WhereSQLMaker(this.m_oPageParameters);
        whereSQLMaker.makeWhereSQL(this);
        String string = whereSQLMaker.getWhereSQL();
        DefaultWhereSQLMaker defaultWhereSQLMaker = new DefaultWhereSQLMaker(this.getSearchTableName(), this.getSearchKey(), this.getSearchValue());
        defaultWhereSQLMaker.makeWhereSQL();
        String string2 = defaultWhereSQLMaker.getWhereSQL();
        if (string == null || string.length() == 0) {
            string = string2 == null ? "" : string2;
        } else if (string2 != null && string2.length() > 0) {
            string = string + " and (" + string2 + ")";
        }
        List list = whereSQLMaker.getSearchValues();
        if (defaultWhereSQLMaker.getSearchValues() != null) {
            if (list == null) {
                list = defaultWhereSQLMaker.getSearchValues();
            } else {
                list.addAll(defaultWhereSQLMaker.getSearchValues());
            }
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string, this.getOrderSQL());
        wCMFilter2.setSearchValues(list);
        wCMFilter2.mergeWith(wCMFilter);
        String string3 = this.getString("PageMaxCount");
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1000;
        }
        wCMFilter2.setMaxRowNumber(n);
        return wCMFilter2;
    }

    public String getWhereSQL() throws WCMException {
        WhereSQLMaker whereSQLMaker = new WhereSQLMaker(this.m_oPageParameters);
        whereSQLMaker.makeWhereSQL(this);
        String string = whereSQLMaker.getWhereSQL();
        String string2 = this.getDefaultWhereSQL();
        if (string == null || string.length() == 0) {
            string = string2;
        } else if (string2 != null && string2.length() > 0) {
            string = string + " and (" + string2 + ")";
        }
        return string;
    }

    private String getDefaultWhereSQL() throws WCMException {
        String string = this.getSearchTableName();
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = this.getSearchKey();
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        String string3 = this.getSearchValue();
        if (string3 == null || string3.length() == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string4 = "";
        boolean bl = true;
        String[] stringArray = CMyString.split(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            for (int i = 0; i < stringArray.length; ++i) {
                if (bl) {
                    string4 = this.getSingleWhereSQL(stringArray[i], string5, string3);
                    bl = string4.length() == 0;
                    continue;
                }
                String string6 = this.getSingleWhereSQL(string, string5, string3);
                if (string6.length() <= 0) continue;
                string4 = string4 + " or " + string6;
            }
        }
        return string4;
    }

    private String getSingleWhereSQL(String string, String string2, String string3) throws WCMException {
        String string4 = CMyString.filterForSQL(string3);
        string4 = string4.replaceAll("(?i)([;'\n\r\\-]).*", "");
        DBManager dBManager = DBManager.getDBManager();
        FieldInfo fieldInfo = dBManager.getFieldInfo(string, string2);
        if (fieldInfo == null) {
            return "";
        }
        switch (fieldInfo.getDataType().getType()) {
            case 4: 
            case 6: {
                return string2 + "=" + string4;
            }
            case 91: {
                return "";
            }
            case 2005: {
                return this.getDBManager().getDBType().sqlFilterForClob(string2, string4);
            }
        }
        return string2 + " like '%" + string4 + "%'";
    }

    public String getOrderSQL() throws WCMException {
        if (this.getOrderField() == null || this.getOrderField().length() == 0) {
            return "";
        }
        if (this.getOrderType() == null || this.getOrderType().length() == 0) {
            return "";
        }
        String string = this.getOrderField() + " " + this.getOrderType();
        return CMyString.filterForSQL(string);
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label15", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label16", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public void handleOpReports(String string, Reports reports) throws Exception {
        if (string == null || string.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label17", "\u4f20\u5165\u54cd\u5e94Reports\u7684URL\u5730\u5740\u65e0\u6548\uff01"));
        }
        if (reports == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label18", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u64cd\u4f5c\u6267\u884c\u7ed3\u679c\u62a5\u544a\uff01"));
        }
        this.m_oRequest.setAttribute("OperReports", (Object)reports);
        this.m_oRequest.getRequestDispatcher(string).forward((ServletRequest)this.m_oRequest, (ServletResponse)this.m_oResponse);
    }

    public Reports getReports() {
        return (Reports)this.m_oRequest.getAttribute("OperReports");
    }

    public void forward(String string) throws Exception {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(RequestHelper.class, "RequestHelper.label19", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u4f20\u5165\u7a7a\u7684URL\u5b57\u7b26\u4e32\uff01"));
        }
        RequestDispatcher requestDispatcher = this.m_oRequest.getRequestDispatcher(string);
        if (requestDispatcher == null) {
            throw new WCMException(1100, I18NMessage.get(RequestHelper.class, "RequestHelper.label20", "\u64cd\u4f5c\u6267\u884c\u4e0d\u6210\u529f\uff0c\u6ca1\u6709\u627e\u5230\u8df3\u8f6c\u5230[]\u7684RequestDispatcher"));
        }
        requestDispatcher.forward((ServletRequest)this.m_oRequest, (ServletResponse)this.m_oResponse);
    }

    public String getServerName() {
        return this.m_oRequest.getServerName();
    }

    public int getServerPort() {
        return this.m_oRequest.getServerPort();
    }

    public void sendRedirect(String string) throws Exception {
        String string2 = string + "?" + this.realParameters2QueryString();
        this.m_oRequest.setAttribute("RedirectUrl", (Object)string2);
        this.forward("../tools/custom_page_redirect.jsp");
    }

    public String realParameters2QueryString() throws WCMException {
        if (!this.m_bParsed) {
            this.doValid();
        }
        String string = "";
        Enumeration enumeration = this.m_hParameterValue.keys();
        Object object = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object v;
            object = enumeration.nextElement();
            if (object.toString().equalsIgnoreCase("PageMaxCount") && !this.existPageMaxCount() || this.m_oRequest.getParameter(object.toString()) == null || (v = this.m_hParameterValue.get(object)) == null) continue;
            if (bl) {
                string = string + "&";
            } else {
                bl = true;
                string = "";
            }
            string = string + object.toString() + "=" + CMyString.URLEncode(v.toString());
        }
        return string;
    }
}

