/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.stat.UserLoginInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyKeyGenerator;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.key.wcm.BaseWCMKeyUtil;
import com.trs.presentation.locale.LocaleServer;
import com.trs.presentation.login.SessionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginHelper {
    private static Logger logger = Logger.getLogger(LoginHelper.class);
    private boolean m_bForceKick = false;
    private static Hashtable htUserNameToSessions = new Hashtable();
    private static Hashtable htIdToSession = new Hashtable();
    private HttpServletRequest m_oRequest;
    private HttpSession m_oSession;
    private User m_oLoginUser;
    private boolean m_bRecordUsedTime = true;
    private static LoginErrNumRecs m_errNumRecs = null;
    public static int ERRNUM_MAX = 10;
    public static final int ERR_USER_NOTEXIST = -8;
    public static final int ERR_USER_LOCKED = -2;
    public static final int ERR_PWD_WRONG = -1;
    public static final int ERR_USER_LOGINED = -3;
    public static final int ERR_USER_NOREG = 0;
    public static final int ERR_USER_FORBID = 20;
    public static final int ERR_USER_DELETED = 10;
    public static final int RESULT_OK = 30;
    public static final int ERR_USERDEF_FROM = -11;
    public static final String SESSION_NAME_USER = "WCM52.loginUser";
    public static final String ONLINE_USER_VERSION = "OnlineUsersListVersion";
    private static final int SESSION_EXPIRE = 60;
    private static final String PARAM_NAME_ENCODE = "RandomInfo";
    public static final String KEY_PRIVATE_LOGIN = "private_login.key";
    public static final String KEY_PUBLIC_LOGIN = "public_login.key";
    public static final String KEY_PRIVATE_PLATFORM_LOGIN;
    public static final String KEY_PUBLIC_PLATFORM_LOGIN;

    public LoginHelper() {
    }

    public LoginHelper(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        this.m_oRequest = httpServletRequest;
        this.m_oSession = httpServletRequest.getSession();
        Object object = this.m_oSession.getAttribute(SESSION_NAME_USER);
        if (object != null) {
            try {
                this.m_oLoginUser = User.findByKey(object);
            }
            catch (WCMException wCMException) {
                logger.debug((Object)"create LoginHelper fail:", (Throwable)wCMException);
            }
        }
        if (m_errNumRecs == null) {
            m_errNumRecs = new LoginErrNumRecs();
        }
    }

    public boolean checkLogin() {
        return this.checkLogin(false);
    }

    public boolean checkPluginLogin() {
        return this.checkEncodeInfoFromKey(KEY_PUBLIC_PLATFORM_LOGIN);
    }

    public boolean checkLogin(boolean bl) {
        if (bl) {
            return this.checkEncodeInfoFromKey();
        }
        return this.m_oLoginUser != null;
    }

    public User getLoginUser() {
        return this.m_oLoginUser;
    }

    public static final String getErrorMsg(int n) {
        return LoginHelper.getErrorMsg(n, null);
    }

    public static final String getErrorMsg(int n, String string) {
        switch (n) {
            case -8: 
            case -1: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label25", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            case -3: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label2", "\u7528\u6237\u5df2\u7ecf\u767b\u5f55");
            }
            case -2: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label3", "\u7528\u6237\u5df2\u9501\u5b9a");
            }
            case 0: 
            case 10: 
            case 20: {
                return I18NMessage.get(LoginHelper.class, "LoginHelper.label26", "\u5e10\u53f7\u5904\u4e8e\u975e\u5f00\u901a\u72b6\u6001\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
            }
        }
        return string != null ? string : I18NMessage.get(LoginHelper.class, "LoginHelper.label8", "\u672a\u77e5\u9519\u8bef[") + n + "]";
    }

    public boolean isRecordUsedTime() {
        return this.m_bRecordUsedTime;
    }

    public void setRecordUsedTime(boolean bl) {
        this.m_bRecordUsedTime = bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int login(String string, String string2) throws WCMException {
        long l;
        int n;
        block22: {
            int n2;
            block23: {
                block24: {
                    if (this.m_oLoginUser != null && this.m_oLoginUser.getName().equalsIgnoreCase(string)) {
                        return 30;
                    }
                    BaseWCMKeyUtil baseWCMKeyUtil = null;
                    try {
                        baseWCMKeyUtil = BaseWCMKeyUtil.getInstance();
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                        throw new WCMException(exception.getMessage());
                    }
                    int n3 = baseWCMKeyUtil.func1();
                    if (n3 > 0 && LoginHelper.getOnlineUserCount() >= n3) {
                        throw new WCMException(I18NMessage.get(LoginHelper.class, "LoginHelper.label9", "\u60a8\u7cfb\u7edf\u53ea\u5141\u8bb8\u3010") + n3 + I18NMessage.get(LoginHelper.class, "LoginHelper.label10", "\u3011\u4e2a\u7528\u6237\u540c\u65f6\u5728\u7ebf\uff01\u8bf7\u548cTRS\u516c\u53f8\u8d2d\u4e70\u7533\u8bf7\u66f4\u591a\u7684\u8bb8\u53ef\uff01\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01"));
                    }
                    boolean bl = n3 == 0 && "true".equals(ConfigServer.getServer().getSysConfigValue("REPEAT_LOGIN_ALLOWED", "false"));
                    n = -1;
                    l = 0L;
                    try {
                        try {
                            void var10_11;
                            User user = User.findByName(string);
                            if (user == null) {
                                User user2 = new User();
                                user2.setName(string);
                            } else {
                                this.m_oLoginUser = user;
                            }
                            String string3 = RemoteAddrUtil.getRemoteAddr(this.m_oRequest);
                            ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, string3);
                            String string4 = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label11", "\u7528\u6237({0})\u4e8e{1}\u4ece [{2}]\u767b\u5f55\u7cfb\u7edf."), new String[]{var10_11.toString(), CMyDateTime.now().toString(), string3});
                            l = LogServer.startRecord(string, "USER_LOGIN", string4, (BaseObj)var10_11);
                            if (this.m_oLoginUser == null) {
                                n = -8;
                                break block22;
                            }
                            if (!bl && LoginHelper.getSessionByUser(this.m_oLoginUser) != null) {
                                if (this.canReLogin(this.m_oLoginUser, string2, string3) || this.isForceKick()) {
                                    this.kickOffSelf(this.m_oLoginUser);
                                    this.m_oLoginUser = null;
                                    n2 = this.login(string, string2);
                                    Object var15_17 = null;
                                    if (l <= 0L) return n2;
                                    if (n != 30) break block23;
                                    break block24;
                                }
                                n = !this.m_oLoginUser.passwordIs(string2) ? -1 : -3;
                                break block22;
                            }
                            int n4 = m_errNumRecs.getErrNum(this.m_oLoginUser);
                            if (this.isOverMaxErrNum(n4)) {
                                n = 20;
                                break block22;
                            }
                            n = this.m_oLoginUser.login(string2, string3);
                            if (n == -1) {
                                n4 = m_errNumRecs.incErrNum(this.m_oLoginUser);
                                if (!this.isOverMaxErrNum(n4)) break block22;
                                this.forbidUser(this.m_oLoginUser);
                                if (this.m_oLoginUser.isForbidden()) {
                                    m_errNumRecs.clearErrNum(this.m_oLoginUser);
                                }
                                break block22;
                            }
                            if (n == 30 && n4 > 0) {
                                m_errNumRecs.clearErrNum(this.m_oLoginUser);
                            }
                            break block22;
                        }
                        catch (WCMException wCMException) {
                            LogServer.endRecordFailedOperation(l, wCMException);
                            l = 0L;
                            throw new WCMException(1100, I18NMessage.get(LoginHelper.class, "LoginHelper.label14", "\u7528\u6237\u767b\u5f55\u5931\u8d25(loginHelper.login)"), wCMException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        if (l <= 0L) throw throwable;
                        if (n == 30) {
                            LogServer.endRecordSucceedOperation(l);
                            throw throwable;
                        }
                        LogServer.endRecordFailedOperation(l, null);
                        throw throwable;
                    }
                }
                LogServer.endRecordSucceedOperation(l);
                return n2;
            }
            LogServer.endRecordFailedOperation(l, null);
            return n2;
        }
        Object var15_18 = null;
        if (l > 0L) {
            if (n == 30) {
                LogServer.endRecordSucceedOperation(l);
            } else {
                LogServer.endRecordFailedOperation(l, null);
            }
        }
        if (n == 30) {
            SessionListener sessionListener = new SessionListener((Integer)this.m_oLoginUser.getKey());
            this.m_oSession.setAttribute("listener", (Object)sessionListener);
            this.m_oSession.setAttribute(SESSION_NAME_USER, this.m_oLoginUser.getKey());
            this.m_oSession.setMaxInactiveInterval(3600);
        }
        if (n != 30) return n;
        this.addUserLoginInfo();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loginByIDS(String string) throws WCMException {
        Object object;
        Object object2;
        String string2;
        int n;
        block9: {
            long l;
            block8: {
                n = -1;
                l = 0L;
                string2 = "";
                try {
                    try {
                        string2 = RemoteAddrUtil.getRemoteAddr(this.m_oRequest);
                        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, string2);
                        object2 = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label11", "\u7528\u6237({0})\u4e8e{1}\u4ece [{2}]\u767b\u5f55\u7cfb\u7edf."), new String[]{string, CMyDateTime.now().toString(), string2});
                        object = User.findByName(string);
                        l = LogServer.startRecord(string, "USER_LOGIN", (String)object2, (BaseObj)object);
                        this.m_oLoginUser = User.findByName(string);
                        n = 30;
                    }
                    catch (Throwable throwable) {
                        LogServer.endRecordFailedOperation(l, throwable);
                        l = 0L;
                        throw new WCMException(1100, I18NMessage.get(LoginHelper.class, "LoginHelper.label14", "\u7528\u6237\u767b\u5f55\u5931\u8d25(loginHelper.login)"), throwable);
                    }
                    Object var9_9 = null;
                    if (l <= 0L || n != 30) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (l > 0L && n == 30) {
                        LogServer.endRecordSucceedOperation(l);
                        throw throwable;
                    }
                    LogServer.endRecordFailedOperation(l, null);
                    throw throwable;
                }
                LogServer.endRecordSucceedOperation(l);
                break block9;
            }
            LogServer.endRecordFailedOperation(l, null);
        }
        if (n != 30) return n;
        object2 = new SessionListener((Integer)this.m_oLoginUser.getKey());
        this.m_oSession.setAttribute("listener", object2);
        this.m_oSession.setAttribute(SESSION_NAME_USER, this.m_oLoginUser.getKey());
        this.m_oSession.setMaxInactiveInterval(3600);
        this.m_oLoginUser.setAttribute("LoginIP", string2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("login ok:" + this.m_oLoginUser + ":" + string2));
        }
        try {
            object = this.m_oSession.getAttribute("locale");
            if (object != null) return n;
            if (User.getSystem().getName().equals(this.m_oLoginUser.getName())) return n;
            this.m_oSession.setAttribute("locale", (Object)"zh_CN");
            LocaleServer.setFavorLanguage(this.m_oLoginUser, "zh_CN");
            return n;
        }
        catch (Exception exception) {
            logger.warn((Object)"set favor lang failed.", (Throwable)exception);
        }
        return n;
    }

    public void logout() {
        if (this.getLoginUser() == null) {
            return;
        }
        String string = I18NMessage.get(LoginHelper.class, "LoginHelper.label15", "\u7528\u6237[") + this.getLoginUser() + I18NMessage.get(LoginHelper.class, "LoginHelper.label16", "]\u9000\u51fa\u7cfb\u7edf");
        long l = LogServer.startRecord(this.getLoginUser().getName(), "USER_LOGOUT", string, this.getLoginUser());
        this.getLoginUser().logout();
        LogServer.endRecordSucceedOperation(l);
        if (this.m_oSession != null) {
            this.m_oSession.invalidate();
        }
    }

    private void forbidUser(User user) {
        if (user.getStatus() == 20) {
            return;
        }
        User user2 = User.getSystem();
        if (!user.canEdit(user2)) {
            return;
        }
        try {
            user.setStatus(20);
            user.update(user2);
        }
        catch (Exception exception) {
            user.cancelUpdate(user2);
        }
    }

    public int getLoginErrNum(User user) {
        if (user == null) {
            return 0;
        }
        return m_errNumRecs.getErrNum(user);
    }

    public static final void clearLoginErrNum(User user) {
        if (user != null) {
            m_errNumRecs.clearErrNum(user);
        }
    }

    public boolean isOverMaxErrNum(int n) throws WCMException {
        int n2;
        String string = ConfigServer.getServer().getSysConfigValue("LOGIN_ERRNUM_MAX", String.valueOf(ERRNUM_MAX));
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n2 = ERRNUM_MAX;
        }
        return n2 > 0 && n >= n2;
    }

    public boolean checkOnlineUserUpdate() {
        int n = SessionListener.getVersion();
        String string = (String)this.m_oSession.getAttribute(ONLINE_USER_VERSION);
        if (string == null) {
            this.m_oSession.setAttribute(ONLINE_USER_VERSION, (Object)String.valueOf(n));
            return true;
        }
        int n2 = Integer.parseInt(string);
        if (n2 == n) {
            return false;
        }
        this.m_oSession.setAttribute(ONLINE_USER_VERSION, (Object)String.valueOf(n));
        return true;
    }

    public static Users getOnlineUsers() {
        Vector vector = SessionListener.getOnlineUsers();
        Users users = new Users(User.getSystem());
        int n = vector.size();
        Integer n2 = null;
        for (int i = 0; i < n; ++i) {
            n2 = (Integer)vector.get(i);
            users.addElement(n2);
        }
        return users;
    }

    public static int getOnlineUserCount() {
        return SessionListener.getCount();
    }

    public String createEncodeUserInfo() {
        return this.createEncodeUserInfo(this.getLoginUser(), KEY_PRIVATE_LOGIN);
    }

    public String createPluginEncodeUserInfo() {
        try {
            return this.createEncodeUserInfo(User.findById(1), KEY_PRIVATE_PLATFORM_LOGIN);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public String createPluginEncodeUserInfo(String string) {
        try {
            return this.createEncodeUserInfo(User.findById(1), KEY_PRIVATE_PLATFORM_LOGIN, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public String createEncodeUserInfo(User user, String string) {
        return this.createEncodeUserInfo(user, string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createEncodeUserInfo(User user, String string, String string2) {
        Exception exception222;
        String string3;
        FilterOutputStream filterOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block18: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("_sPrivateKeyFile:" + string));
            }
            if (user == null) {
                return "";
            }
            byteArrayOutputStream = null;
            filterOutputStream = null;
            CMySign cMySign = CMySign.getSign(string);
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(user.getId());
            ((DataOutputStream)filterOutputStream).writeUTF(user.getName());
            String string4 = CMyString.showEmpty(string2);
            ((DataOutputStream)filterOutputStream).writeUTF(string4);
            ((DataOutputStream)filterOutputStream).flush();
            byte[] byArray = cMySign.sign(byteArrayOutputStream.toByteArray());
            ((DataOutputStream)filterOutputStream).writeInt(byArray.length);
            filterOutputStream.write(byArray);
            ((DataOutputStream)filterOutputStream).flush();
            String string5 = cMySign.encodeRadix64(byteArrayOutputStream.toByteArray());
            string3 = "RandomInfo=" + string5;
            Object var12_12 = null;
            if (filterOutputStream == null) break block18;
            try {
                filterOutputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        return string3;
        catch (Exception exception3) {
            Exception exception4222;
            block20: {
                try {
                    exception3.printStackTrace();
                    Object var12_13 = null;
                    if (filterOutputStream == null) break block20;
                }
                catch (Throwable throwable) {
                    Exception exception5222;
                    Object var12_14 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception4222) {}
            }
        }
        return "";
    }

    private boolean checkEncodeInfoFromKey() {
        String string = KEY_PUBLIC_LOGIN;
        return this.checkEncodeInfoFromKey(string);
    }

    public String getPluginParams() {
        try {
            String string = CMyString.getStr(this.m_oRequest.getParameter(PARAM_NAME_ENCODE));
            byte[] byArray = string.getBytes();
            CMySign cMySign = CMySign.getVerify(KEY_PUBLIC_PLATFORM_LOGIN);
            byArray = cMySign.decodeRadix64(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            dataInputStream.readInt();
            dataInputStream.readUTF();
            return dataInputStream.readUTF();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean checkEncodeInfoFromKey(String string) {
        String string2 = CMyString.getStr(this.m_oRequest.getParameter(PARAM_NAME_ENCODE));
        if (string2 == null) {
            return this.m_oLoginUser != null;
        }
        return this.checkEncodeInfo(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkEncodeInfo(String string, String string2) {
        boolean bl;
        Object object;
        Object object2;
        logger.debug((Object)("sPublicKey:" + string));
        User user = null;
        String string3 = "";
        try {
            int n;
            byte[] byArray = string2.getBytes();
            CMySign cMySign = CMySign.getVerify(string);
            byArray = cMySign.decodeRadix64(byArray);
            object2 = new ByteArrayInputStream(byArray);
            object = new DataInputStream((InputStream)object2);
            int n2 = ((DataInputStream)object).readInt();
            String string4 = ((DataInputStream)object).readUTF();
            string3 = ((DataInputStream)object).readUTF();
            if (string3 == null) {
                string3 = "";
            }
            if (!cMySign.verify(byArray, n = ((DataInputStream)object).readInt())) {
                logger.error((Object)"Invalid random info: Signature doesn't matched.");
                return false;
            }
            user = User.findById(n2);
            if (user == null) {
                user = User.findById(1);
                if (user == null) {
                    logger.error((Object)"No such user: default admin.");
                    return false;
                }
            } else if (n2 != 1 && !user.getName().equals(string4)) {
                logger.error((Object)("Invalid user: " + string4));
                return false;
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to check login.", (Throwable)exception);
            return false;
        }
        if (this.m_oLoginUser != null && this.m_oLoginUser.equals(user)) {
            return true;
        }
        long l = 0L;
        try {
            object2 = CMyString.format(I18NMessage.get(LoginHelper.class, "LoginHelper.label20", "\u7528\u6237\u4e8e{0}\u4ece [{1}]\u901a\u8fc7\u7b7e\u540d\u767b\u9646\u7cfb\u7edf."), new String[]{CMyDateTime.now().toString(), this.m_oRequest.getRemoteAddr()});
            object = new User();
            ((User)object).setName(I18NMessage.get(LoginHelper.class, "LoginHelper.label21", "\u533f\u540d"));
            l = LogServer.startRecord(I18NMessage.get(LoginHelper.class, "LoginHelper.label21", "\u533f\u540d"), "USER_LOGGIN", (String)object2, (BaseObj)object);
            this.m_oSession.setAttribute(SESSION_NAME_USER, user.getKey());
            this.m_oLoginUser = user;
            LogServer.endRecordSucceedOperation(l);
            bl = true;
            Object var13_16 = null;
            if (l <= 0L) return bl;
        }
        catch (Exception exception) {
            try {
                logger.error((Object)I18NMessage.get(LoginHelper.class, "LoginHelper.label22", "\u6821\u9a8c\u5931\u8d25\uff01"), (Throwable)exception);
                LogServer.endRecordFailedOperation(l, exception);
                l = 0L;
                Object var13_17 = null;
                if (l <= 0L) return false;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (l <= 0L) throw throwable;
                LogServer.endRecordSucceedOperation(l);
                throw throwable;
            }
            LogServer.endRecordSucceedOperation(l);
            return false;
        }
        LogServer.endRecordSucceedOperation(l);
        return bl;
    }

    public static void putSession(Integer n, HttpSession httpSession) {
        if (httpSession == null) {
            return;
        }
        htUserNameToSessions.put(n, httpSession);
        htIdToSession.put(httpSession.getId(), httpSession);
    }

    public static HttpSession getSessionByUser(User user) {
        if (user == null) {
            return null;
        }
        return (HttpSession)htUserNameToSessions.get(user.getKey());
    }

    public static HttpSession getSessionById(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return null;
        }
        return (HttpSession)htIdToSession.get(string);
    }

    public static void removeSession(HttpSession httpSession, Integer n) {
        if (httpSession == null) {
            return;
        }
        String string = httpSession.getId();
        htUserNameToSessions.remove(n);
        htIdToSession.remove(string);
    }

    public static void kickUser(User user, User user2) throws WCMException {
        if (user == null) {
            return;
        }
        HttpSession httpSession = LoginHelper.getSessionByUser(user2);
        if (httpSession == null) {
            return;
        }
        try {
            httpSession.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void kickOffSelf(User user) {
        if (user == null) {
            return;
        }
        HttpSession httpSession = LoginHelper.getSessionByUser(user);
        if (httpSession == null) {
            return;
        }
        try {
            httpSession.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean canReLogin(User user, String string, String string2) {
        if (user == null || !user.passwordIs(string)) {
            return false;
        }
        HttpSession httpSession = LoginHelper.getSessionByUser(user);
        if (httpSession == null) {
            return true;
        }
        String string3 = user.getLoginIP();
        return string3 == null || string3.equals(string2);
    }

    private static void createPlatformKey() {
        try {
            if (!CMyFile.fileExists(KEY_PRIVATE_PLATFORM_LOGIN)) {
                logger.info((Object)("create " + KEY_PRIVATE_PLATFORM_LOGIN + " file.."));
                CMyKeyGenerator.generatorKey(KEY_PRIVATE_PLATFORM_LOGIN, KEY_PUBLIC_PLATFORM_LOGIN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isForceKick() {
        return this.m_bForceKick;
    }

    public final void setForceKick(boolean bl) {
        this.m_bForceKick = bl;
    }

    private void addUserLoginInfo() {
        try {
            UserLoginInfo userLoginInfo = UserLoginInfo.createNewInstance();
            userLoginInfo.setUserId(this.m_oLoginUser.getId());
            userLoginInfo.setLoginTime(this.m_oLoginUser.getLoginTime());
            userLoginInfo.setIpAddress(this.m_oLoginUser.getLoginIP());
            userLoginInfo.save(this.m_oLoginUser);
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
    }

    public boolean isLoginWithVerifyCode() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("LOGIN_WITH_VERIFYCODE", "false");
        return "true".equalsIgnoreCase(string);
    }

    static {
        CMyKeyGenerator.generatorKey(KEY_PRIVATE_LOGIN, KEY_PUBLIC_LOGIN);
        KEY_PRIVATE_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "private_platform_log.key";
        KEY_PUBLIC_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "public_platform_log.key";
        LoginHelper.createPlatformKey();
    }

    private class LoginErrNumRecs {
        private Hashtable m_recs = new Hashtable();

        private Object key(User user) {
            return new Integer(user.getId());
        }

        private void setRec(User user, int n) {
            this.m_recs.put(this.key(user), new Integer(n));
        }

        public int getErrNum(User user) {
            Integer n = (Integer)this.m_recs.get(this.key(user));
            return n == null ? 0 : n;
        }

        public int incErrNum(User user) {
            int n = this.getErrNum(user) + 1;
            this.setRec(user, n);
            return n;
        }

        public void clearErrNum(User user) {
            this.setRec(user, 0);
        }
    }
}

