/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.LockerMgr;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public final class CmsObjUnlockTools {
    private static Logger s_logger = Logger.getLogger(CmsObjUnlockTools.class);
    private static final CMSBaseObjs EMPTY_OBJS = new CMSBaseObjs(User.getSystem()){

        protected String getDbTableName() {
            return null;
        }

        public String getIdFieldName() {
            return null;
        }

        public Class getElementClass() {
            return null;
        }

        public BaseObjs newInstance() throws Exception {
            return null;
        }
    };

    public static CMSObj findLockedObj(int n, int n2) throws WCMException {
        CMSObj cMSObj = null;
        try {
            cMSObj = (CMSObj)BaseObj.findById(n, n2);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return cMSObj;
    }

    public static boolean forceUnLocke(User user, CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            return true;
        }
        User user2 = cMSObj.getLockerUser();
        if (!user.isAdministrator()) {
            throw new WCMException(1002, CMyString.format(I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label1", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u89e3\u9501[{0}]\u9501\u5b9a\u7684[{1}]."), new String[]{user2.toString(), cMSObj.toString()}) + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label3", "]!\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u5f3a\u5236\u89e3\u9664\u5bf9\u8c61\u7684\u9501\u5b9a."));
        }
        cMSObj.unlock();
        CmsObjUnlockTools.notifyUnlock(user, user2, cMSObj);
        return true;
    }

    private static void notifyUnlock(User user, User user2, CMSObj cMSObj) {
        try {
            Message message = new Message();
            message.setTitle(I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label4", "\u5bf9\u8c61\u89e3\u9501\u901a\u77e5"));
            String string = user2.getNickName();
            if (CMyString.isEmpty(string)) {
                string = user2.getName();
            }
            message.setBody(string + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label5", ",\u60a8\u597d.\n    \u56e0\u5de5\u4f5c\u9700\u8981,\u60a8\u9501\u5b9a\u7f16\u8f91\u7684[") + cMSObj + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label6", "]\u5df2\u88ab\u7cfb\u7edf\u7ba1\u7406\u5458[") + user.getName() + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label7", "]\u5f3a\u5236\u89e3\u9501!\n    \u8bf7\u624b\u5de5\u5907\u4efd\u60a8\u5f53\u524d\u7684\u64cd\u4f5c,\u8c22\u8c22!"));
            message.setCrUser(user);
            message.setReceivers(204, String.valueOf(user2.getId()));
            message.setSendTypes("Message,Email");
            MessageServer.send(message);
        }
        catch (Exception exception) {
            s_logger.error((Object)("[" + user + "] failed to notify unlock[" + cMSObj + "]"), (Throwable)exception);
        }
    }

    public static CMSBaseObjs listLockedObjs(User user, int n) throws WCMException {
        LockerMgr lockerMgr = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        String string = lockerMgr.getLockedObjIds(n);
        if (CMyString.isEmpty(string)) {
            return EMPTY_OBJS;
        }
        CMSBaseObjs cMSBaseObjs = null;
        switch (n) {
            case 605: {
                cMSBaseObjs = Documents.findByIds(user, string);
                break;
            }
            case 102: {
                cMSBaseObjs = Templates.findByIds(user, string);
                break;
            }
            case 101: {
                cMSBaseObjs = Channels.findByIds(user, string);
                break;
            }
            case 103: {
                cMSBaseObjs = WebSites.findByIds(user, string);
                break;
            }
            default: {
                cMSBaseObjs = EMPTY_OBJS;
            }
        }
        return cMSBaseObjs;
    }
}

