/*
 * Decompiled with CFR 0.152.
 */
package com.trs.license;

public class LicenseUtil {
    private static final char[] encode_array;
    private static final byte[] decode_array;

    private static byte[] decodeRadix64(byte[] byArray) {
        int n = byArray.length / 4 * 3;
        if (n == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 46) {
            --n;
            if (byArray[byArray.length - 2] == 46) {
                --n;
            }
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (n = byArray.length; n > 0; n -= 4) {
            byte by = decode_array[byArray[n2++] & 0xFF];
            byte by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (byArray[n2] == 46) {
                return byArray2;
            }
            by = by2;
            by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            if (byArray[n2] == 46) {
                return byArray2;
            }
            by = by2;
            by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
        }
        return byArray2;
    }

    public static String decodeRadix64(String string) {
        LicenseUtil.assertNotNull(string);
        try {
            string = string.trim();
            return new String(LicenseUtil.decodeRadix64(string.getBytes()));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = string.charAt(string.length() - 1) == '.' ? string + '.' : string + "..";
            return new String(LicenseUtil.decodeRadix64(string.getBytes()));
        }
    }

    private static void assertNotNull(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
    }

    static {
        int n;
        encode_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decode_array = new byte[256];
        for (n = 0; n < 255; ++n) {
            LicenseUtil.decode_array[n] = -1;
        }
        for (n = 0; n < encode_array.length; ++n) {
            LicenseUtil.decode_array[LicenseUtil.encode_array[n]] = (byte)n;
        }
    }
}

