/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.InflaterInputStream;
import com.trs.infra.util.jazzlib.ZipConstants;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 2;
    private String name;
    RandomAccessFile raf;
    ZipEntry[] entries;
    private String encoding = null;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public ZipFile(String string) throws ZipException, IOException {
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        this.readEntries();
    }

    public ZipFile(String string, String string2) throws ZipException, IOException {
        this.encoding = string2;
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        this.readEntries();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getName();
        this.readEntries();
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        if ((n & 2) != 0) {
            throw new IllegalArgumentException("OPEN_DELETE mode not supported yet in java.util.zip.ZipFile");
        }
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getName();
        this.readEntries();
    }

    private final int readLeShort() throws IOException {
        int n = this.raf.readUnsignedByte() | this.raf.readUnsignedByte() << 8;
        return n;
    }

    private final int readLeInt() throws IOException {
        return this.readLeShort() | this.readLeShort() << 16;
    }

    private void readEntries() throws ZipException, IOException {
        long l = this.raf.length() - 22L;
        do {
            if (l < 0L) {
                throw new ZipException("central directory not found, probably not a zip file");
            }
            this.raf.seek(l--);
        } while (this.readLeInt() != 101010256);
        if (this.raf.skipBytes(6) != 6) {
            throw new EOFException();
        }
        int n = this.readLeShort();
        if (this.raf.skipBytes(4) != 4) {
            throw new EOFException();
        }
        int n2 = this.readLeInt();
        this.entries = new ZipEntry[n];
        this.raf.seek(n2);
        for (int i = 0; i < n; ++i) {
            if (this.readLeInt() != 33639248) {
                throw new ZipException("Wrong Central Directory signature");
            }
            if (this.raf.skipBytes(6) != 6) {
                throw new EOFException();
            }
            int n3 = this.readLeShort();
            int n4 = this.readLeInt();
            int n5 = this.readLeInt();
            int n6 = this.readLeInt();
            int n7 = this.readLeInt();
            int n8 = this.readLeShort();
            int n9 = this.readLeShort();
            int n10 = this.readLeShort();
            if (this.raf.skipBytes(8) != 8) {
                throw new EOFException();
            }
            int n11 = this.readLeInt();
            byte[] byArray = new byte[Math.max(n8, n10)];
            this.raf.readFully(byArray, 0, n8);
            String string = this.encoding == null ? new String(byArray, 0, n8) : new String(byArray, 0, n8, this.encoding);
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n3);
            zipEntry.setCrc((long)n5 & 0xFFFFFFFFL);
            zipEntry.setSize((long)n7 & 0xFFFFFFFFL);
            zipEntry.setCompressedSize((long)n6 & 0xFFFFFFFFL);
            zipEntry.setDOSTime(n4);
            if (n9 > 0) {
                byte[] byArray2 = new byte[n9];
                this.raf.readFully(byArray2);
                zipEntry.setExtra(byArray2);
            }
            if (n10 > 0) {
                this.raf.readFully(byArray, 0, n10);
                zipEntry.setComment(this.encoding == null ? new String(byArray, 0, n10) : new String(byArray, 0, n10, this.encoding));
            }
            zipEntry.zipFileIndex = i;
            zipEntry.offset = n11;
            this.entries[i] = zipEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.entries = null;
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.close();
        }
    }

    public Enumeration entries() {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        return new ZipEntryEnumeration(this.entries);
    }

    private int getEntryIndex(String string) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!string.equals(this.entries[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public ZipEntry getEntry(String string) {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        int n = this.getEntryIndex(string);
        return n >= 0 ? (ZipEntry)this.entries[n].clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkLocalHeader(ZipEntry zipEntry) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(zipEntry.offset);
            if (this.readLeInt() != 67324752) {
                throw new ZipException("Wrong Local header signature");
            }
            if (this.raf.skipBytes(4) != 4) {
                throw new EOFException();
            }
            if (zipEntry.getMethod() != this.readLeShort()) {
                throw new ZipException("Compression method mismatch");
            }
            if (this.raf.skipBytes(16) != 16) {
                throw new EOFException();
            }
            int n = zipEntry.getName().getBytes().length;
            if (n != this.readLeShort()) {
                throw new ZipException("file name length mismatch");
            }
            int n2 = n + this.readLeShort();
            return zipEntry.offset + 30 + n2;
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        int n = zipEntry.zipFileIndex;
        if ((n < 0 || n >= this.entries.length || this.entries[n].getName() != zipEntry.getName()) && (n = this.getEntryIndex(zipEntry.getName())) < 0) {
            throw new NoSuchElementException();
        }
        long l = this.checkLocalHeader(this.entries[n]);
        int n2 = this.entries[n].getMethod();
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, l, this.entries[n].getCompressedSize());
        switch (n2) {
            case 0: {
                return partialInputStream;
            }
            case 8: {
                return new InflaterInputStream(partialInputStream, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + n2);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        try {
            return this.entries.length;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("ZipFile has closed");
        }
    }

    private static class PartialInputStream
    extends InputStream {
        RandomAccessFile raf;
        long filepos;
        long end;

        public PartialInputStream(RandomAccessFile randomAccessFile, long l, long l2) {
            this.raf = randomAccessFile;
            this.filepos = l;
            this.end = l + l2;
        }

        public int available() {
            long l = this.end - this.filepos;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.filepos == this.end) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.filepos++);
                return this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((long)n2 > this.end - this.filepos && (n2 = (int)(this.end - this.filepos)) == 0) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.filepos);
                int n3 = this.raf.read(byArray, n, n2);
                if (n3 > 0) {
                    this.filepos += (long)n2;
                }
                return n3;
            }
        }

        public long skip(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l > this.end - this.filepos) {
                l = this.end - this.filepos;
            }
            this.filepos += l;
            return l;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        ZipEntry[] array;
        int ptr = 0;

        public ZipEntryEnumeration(ZipEntry[] zipEntryArray) {
            this.array = zipEntryArray;
        }

        public boolean hasMoreElements() {
            return this.ptr < this.array.length;
        }

        public Object nextElement() {
            try {
                return this.array[this.ptr++].clone();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }
    }
}

