/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.image;

import com.trs.DreamFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.image.ch.randelshofer.media.jpeg.CMYKJPEGImageReader;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;

public class CMyImage {
    public static int DEFAULT_WIDTH = 200;
    public static int NEED_SCALE_FILE_LENGTH = 512000;

    public static BufferedImage resize(BufferedImage bufferedImage, int n) {
        if (n <= 0) {
            n = DEFAULT_WIDTH;
        }
        double d = (double)n / (double)bufferedImage.getWidth();
        int n2 = (int)Math.floor((double)bufferedImage.getHeight() * d);
        return CMyImage.resize(bufferedImage, n, n2);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        Object object;
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        double d = (double)n / (double)bufferedImage.getWidth();
        double d2 = (double)n2 / (double)bufferedImage.getHeight();
        if (n3 == 0) {
            object = bufferedImage.getColorModel();
            WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(n, n2);
            boolean bl = ((ColorModel)object).isAlphaPremultiplied();
            bufferedImage2 = new BufferedImage((ColorModel)object, writableRaster, bl, null);
        } else {
            bufferedImage2 = new BufferedImage(n, n2, n3);
        }
        object = bufferedImage2.createGraphics();
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)object).drawRenderedImage(bufferedImage, AffineTransform.getScaleInstance(d, d2));
        ((Graphics)object).dispose();
        return bufferedImage2;
    }

    public static boolean ifNeedScale(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0) + string;
        return new File(string2).length() > (long)NEED_SCALE_FILE_LENGTH;
    }

    public static String scaleImg(String string, int n) throws IOException, WCMException {
        String string2 = CMyFile.extractFileExt(string);
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = CMyString.setStrEndWith(filesMan.mapFilePath(string, 0), File.separatorChar) + string;
        String string4 = CMyImage.getThumbFilePath(string, n);
        File file = new File(string4);
        File file2 = new File(string3);
        if (CMyImage.isPhotoLibCmdEnable()) {
            try {
                ImageMagickCmd.scale(file2.getAbsolutePath(), file.getAbsolutePath(), n, true);
                return file.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file2);
        }
        catch (IOException iOException) {
            String string5 = string2.toLowerCase();
            if (!"jpg".equals(string5) && !"jpeg".equals(string5)) {
                throw iOException;
            }
            bufferedImage = CMYKJPEGImageReader.read(new FileImageInputStream(file2), true);
        }
        bufferedImage = CMyImage.resize(bufferedImage, n);
        ImageIO.write((RenderedImage)bufferedImage, string2, file);
        return file.getName();
    }

    public static void moveThumbs(List list, String string) throws CMyException {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            String string3 = CMyImage.getThumbFilePath(string, CMyImage.getThumbWidth(string2));
            CMyFile.moveFile(string2, string3);
        }
    }

    public static String getThumbFileName(String string, int n) throws WCMException {
        return CMyFile.excludeFileExt(string) + "_" + n + "." + CMyFile.extractFileExt(string);
    }

    public static String getThumbFilePath(String string, int n) throws WCMException {
        String string2 = CMyString.setStrEndWith(FilesMan.getFilesMan().mapFilePath(string, 0), File.separatorChar);
        return string2 + CMyImage.getThumbFileName(string, n);
    }

    public static void formThumbsWidthSystemConfig(String string) throws Exception {
        String string2 = ConfigServer.getServer().getSysConfigValue("IMAGE_THUMB_WIDTHS", "");
        int[] nArray = CMyString.splitToInt(string2, ",");
        for (int i = 0; i < nArray.length; ++i) {
            CMyImage.scaleImg(string, nArray[i]);
        }
    }

    public static int getThumbWidth(String string) {
        String string2 = CMyFile.extractFileName(string);
        if (string2.indexOf("_") < 0) {
            return 0;
        }
        return Integer.parseInt(string2.substring(string2.indexOf("_") + 1, string2.indexOf(".")));
    }

    public static List getAllThumbFilePaths(String string) throws WCMException {
        String string2 = CMyString.setStrEndWith(FilesMan.getFilesMan().mapFilePath(string, 0), File.separatorChar);
        String string3 = CMyFile.excludeFileExt(string);
        File file = new File(string2);
        String[] stringArray = file.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(string3 + "_") < 0) continue;
            arrayList.add(CMyString.setStrEndWith(string2, File.separatorChar) + stringArray[i]);
        }
        return arrayList;
    }

    public static int[] getImageSize(String string) {
        int[] nArray = new int[]{-1, -1};
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return nArray;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(fileInputStream);
            return new int[]{bufferedImage.getWidth(), bufferedImage.getHeight()};
        }
        catch (Exception exception) {
            try {
                ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
                imageObj.setFilename(string);
                return new int[]{imageObj.width, imageObj.height};
            }
            catch (Exception exception2) {
                return nArray;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            CMyImage.moveThumbs(CMyImage.getAllThumbFilePaths("U020110211726748599846.jpg"), "UT2011021062266593104633333333.gif");
            System.out.println(CMyImage.getAllThumbFilePaths("UT20110210622665931046.bmp").toString());
            System.out.println(CMyImage.scaleImg("UT20110210622665931046.bmp", DEFAULT_WIDTH));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean isPhotoLibCmdEnable() {
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        try {
            return iImageLibConfig.isCmdUsed();
        }
        catch (WCMException wCMException) {
            return false;
        }
    }
}

