/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CMysqlText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.FieldInfo;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class MysqlDB
extends DBType {
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType BOOLEAN = new DataType("BOOLEAN", 16, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INTEGER = new DataType("INT", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType CHAR = new DataType("CHAR", 1);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -4000);
    public static final DataType TINYTEXT = new DataType("TINYTEXT", 12, 8);
    public static final DataType TEXT = new DataType("TEXT", 2005);
    public static final DataType MEDIUMTEXT = new DataType("MEDIUMTEXT", -1);
    public static final DataType LONGTEXT = new DataType("LONGTEXT", 2005);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType TINYBLOB = new DataType("TINYBLOB", -3);
    public static final DataType BLOB = new DataType("BLOB", -3);
    public static final DataType MEDIUBLOB = new DataType("MEDIUBLOB", -4);
    public static final DataType LONGBLOB = new DataType("LONGBLOB", 2004);
    public static final DataType DATE = new DataType("DATE", 91);
    public static final DataType TIME = new DataType("TIME", 92);
    public static final DataType DATETIME = new DataType("DATETIME", 93);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    private static final DataType[] m_allDataTypes = new DataType[]{BIT, BOOLEAN, TINYINT, SMALLINT, INTEGER, BIGINT, FLOAT, DECIMAL, NUMERIC, CHAR, VARCHAR, TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT, VARBINARY, TINYBLOB, BLOB, MEDIUBLOB, LONGBLOB, DATE, TIME, DATETIME, TIMESTAMP, NVARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT, TINYBLOB, MEDIUBLOB, LONGBLOB, NVARCHAR};
    private static final Map TYPE_CRPARAMS_COUNTER = new HashMap();

    public MysqlDB() {
        super("Mysql", "com.mysql.jdbc.Driver", true);
    }

    public MysqlDB(String string, String string2) {
        super(string, string2, true);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "BOOLEAN");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(4, "int($l)");
        this.registerColumnType(4, "int");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(3, "numeric($p,$s)");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(-1, 0xFFFFFF, "mediumtext");
        this.registerColumnType(2005, "text");
        this.registerColumnType(12, 65535, "varchar($l)");
        this.registerColumnType(12, 65535, "nvarchar($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, 0xFFFFFF, "mediumblob");
        this.registerColumnType(-3, 65535, "blob");
        this.registerColumnType(-3, 255, "tinyblob");
        this.registerColumnType(2004, "longblob");
        this.registerColumnType(2005, "longtext");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public boolean canWriteTextDirectly() {
        return false;
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlConcatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return "CONCAT(CONCAT(" + string + "," + string2 + ")," + string3 + ")";
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = "CONCAT(" + stringArray[0] + "," + stringArray[1] + ")";
        for (int i = 2; i < stringArray.length; ++i) {
            string = "CONCAT(" + string + "," + stringArray[i] + ")";
        }
        return string;
    }

    public String sqlFilterForClob(String string, String string2) {
        String string3 = string2.equals("?") ? "?" : "'" + CMyString.filterForSQL(string2) + "'";
        return "instr(" + string + "," + string3 + ")>0 ";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        String string5 = string3;
        int n3 = n;
        String string6 = "ALTER TABLE " + string + " ADD " + string2 + " " + string5;
        if (dataType.isLengthDefinedByUser()) {
            string6 = n2 > 0 ? string6 + "(" + n3 + ", " + n2 + ")" : string6 + "(" + n3 + ")";
        }
        if (bl) {
            string6 = string6 + " NULL";
        } else {
            if (string4 != null) {
                string6 = string6 + " DEFAULT ";
                string6 = dataType.isCharData() ? string6 + "'" + CMyString.filterForSQL(string4) + "'" : string6 + string4;
            }
            string6 = string6 + " NOT NULL ";
        }
        return string6;
    }

    public String sqlRenameTable(String string, String string2) {
        return "ALTER TABLE " + CMyString.filterForSQL(string) + " rename to " + CMyString.filterForSQL(string2);
    }

    public String sqlRenameField(String string, String string2, String string3) throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        FieldInfo fieldInfo = dBManager.getFieldInfo(string, string2);
        if (fieldInfo == null) {
            throw new WCMException(40, "No such field: " + string2 + ", TABLE=" + string);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(CMyString.filterForSQL(string));
        stringBuffer.append(" change column ");
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(string3);
        String string4 = fieldInfo.getDataTypeName();
        String string5 = (String)TYPE_CRPARAMS_COUNTER.get(string4.toLowerCase());
        stringBuffer.append(' ');
        stringBuffer.append(string4);
        stringBuffer.append(' ');
        if ("1".equals(string5)) {
            stringBuffer.append('(');
            stringBuffer.append(fieldInfo.getDataLength());
            stringBuffer.append(')');
        } else if ("2".equals(string5)) {
            stringBuffer.append('(');
            stringBuffer.append(fieldInfo.getDataLength());
            stringBuffer.append(',');
            stringBuffer.append(fieldInfo.getDataScale());
            stringBuffer.append(')');
        }
        if (!fieldInfo.isNullable()) {
            stringBuffer.append(" not null");
        }
        String string6 = fieldInfo.getDataDefault();
        if (fieldInfo.getDataDefault() != null && string6.length() > 0) {
            stringBuffer.append(" default ");
            if (fieldInfo.getDataType().isCharData()) {
                stringBuffer.append("'");
                stringBuffer.append(string6);
                stringBuffer.append("'");
            } else {
                stringBuffer.append(string6);
            }
        }
        return stringBuffer.toString();
    }

    protected String keywordsModifyField() {
        return "modify";
    }

    public String sqlGetSysDate() {
        return "now()";
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return "DateDiff(" + string + ",'" + string2 + "')=0";
    }

    public String sqlDateTime(String string, String string2) {
        return "'" + string + "'";
    }

    public String sqlDate(String string) {
        return "'" + string + "'";
    }

    public String sqlDateField(String string) {
        return string;
    }

    public String initQuerySQL(String string, int n, int n2) {
        return string;
    }

    public String sqlQueryTableInfos(String string) {
        return null;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        return null;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return CMysqlText.getClob(resultSet, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return CMysqlText.getClob(resultSet, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        return CMysqlText.setClob(connection, string, string2, string3, string4, string5);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        return CMysqlText.setClob(connection, string, string2, string3, stringArray);
    }

    public String sqlGetNextId() {
        return null;
    }

    public int getType() {
        return 7;
    }

    public void setStringFieldValue(PreparedStatement preparedStatement, int n, String string) throws Exception {
        if (string == null || string.length() <= 300) {
            preparedStatement.setString(n, string);
            return;
        }
        StringReader stringReader = new StringReader(string);
        preparedStatement.setCharacterStream(n, (Reader)stringReader, string.length());
    }

    public boolean canDropField() {
        return true;
    }

    static {
        TYPE_CRPARAMS_COUNTER.put("varbinary", "1");
        TYPE_CRPARAMS_COUNTER.put("binary", "1");
        TYPE_CRPARAMS_COUNTER.put("char", "1");
        TYPE_CRPARAMS_COUNTER.put("varchar", "1");
        TYPE_CRPARAMS_COUNTER.put("numeric", "2");
        TYPE_CRPARAMS_COUNTER.put("decimal", "2");
    }
}

