/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFData;
import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CFFolder;
import com.trs.infra.util.cabfile.CFHeader;
import com.trs.infra.util.cabfile.CabConstants;
import com.trs.infra.util.cabfile.CabEntry;
import com.trs.infra.util.cabfile.CabFileReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class CabFile
implements CabConstants {
    private File m_oCabFile;
    private CabFileReader m_oCabReader;
    private CFHeader m_oHeader;
    private CFFolder[] m_oFolders;
    private CFFile[] m_oFiles;
    private CFData m_oCFData;
    private CabEntry[] m_oEentries;

    public CabFile(File file) throws IOException {
        try {
            this.init(file);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public CabFile(String string) throws IOException {
        this(new File(string));
    }

    private void init(File file) throws IOException {
        int n;
        this.m_oCabFile = file;
        this.m_oCabReader = new CabFileReader(file);
        this.m_oHeader = this.m_oCabReader.readCFHeader();
        this.m_oFolders = new CFFolder[this.m_oHeader.cFolders];
        for (n = 0; n < this.m_oHeader.cFolders; ++n) {
            this.m_oFolders[n] = this.m_oCabReader.readCFFolder();
        }
        this.m_oFiles = new CFFile[this.m_oHeader.cFiles];
        this.m_oEentries = new CabEntry[this.m_oHeader.cFiles];
        for (n = 0; n < this.m_oHeader.cFiles; ++n) {
            this.m_oFiles[n] = this.m_oCabReader.readCFFile();
            this.m_oEentries[n] = new CabEntry(this.m_oFiles[n]);
        }
    }

    public void close() {
        if (this.m_oCabReader != null) {
            this.m_oCabReader.close();
        }
    }

    public Iterator entries() {
        Iterator iterator = new Iterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < CabFile.this.m_oEentries.length;
            }

            public Object next() {
                return CabFile.this.m_oEentries[this.i++];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    private void ensureDiretory(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("diretory is null");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IOException(file.getPath() + " not diretory");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            throw new IOException("create " + file.getPath() + " fail");
        }
    }

    private CFData getNextCFData(CFFile cFFile) throws IOException {
        if (this.m_oCFData == null) {
            this.m_oCFData = new CFData();
        }
        this.m_oCabReader.fillCFData(this.m_oCFData);
        try {
            this.m_oCFData.uncompress(this.m_oFolders[cFFile.iFolder].getCompressType());
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        return this.m_oCFData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int extract(File file) throws IOException {
        this.ensureDiretory(file);
        CFData cFData = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            File file2;
            CabEntry cabEntry;
            block7: {
                Object var14_12;
                if (n3 >= this.m_oEentries.length) {
                    return this.m_oEentries.length;
                }
                CFFile cFFile = this.m_oFiles[n3];
                cabEntry = this.m_oEentries[n3];
                file2 = new File(file, cabEntry.getName());
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n4;
                    for (long i = cabEntry.getSize(); i > 0L; i -= (long)n4, n -= n4, n2 += n4) {
                        if (n == 0) {
                            cFData = this.getNextCFData(cFFile);
                            n = cFData.cbUncomp;
                            n2 = 0;
                        }
                        n4 = (int)Math.min((long)n, i);
                        fileOutputStream.write(cFData.abUncomp, n2, n4);
                    }
                    var14_12 = null;
                    if (fileOutputStream == null) break block7;
                }
                catch (Throwable throwable) {
                    var14_12 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    throw throwable;
                }
                fileOutputStream.close();
            }
            file2.setLastModified(cabEntry.getTime());
            ++n3;
        }
    }

    public CabEntry getEntry(String string) {
        if (this.m_oEentries != null) {
            for (int i = this.m_oEentries.length - 1; i >= 0; --i) {
                CabEntry cabEntry = this.m_oEentries[i];
                if (!cabEntry.getName().equals(string)) continue;
                return cabEntry;
            }
        }
        return null;
    }

    public InputStream getInputStream(CabEntry cabEntry) throws IOException {
        throw new UnsupportedOperationException("getInputStream(CabEntry)");
    }

    public String getName() {
        return this.m_oCabFile.getPath();
    }

    public int size() {
        return this.m_oEentries != null ? this.m_oEentries.length : 0;
    }
}

