/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.cabfile;

import com.trs.infra.util.cabfile.CFFile;
import com.trs.infra.util.cabfile.CabConstants;
import java.util.Calendar;

public class CabEntry
implements CabConstants {
    private CFFile m_oCFFile;
    private String m_sName;
    private long m_tTime;

    CabEntry(CFFile cFFile) {
        this.m_oCFFile = cFFile;
        if ((cFFile.attribs & 0x80) != 0) {
            try {
                this.m_sName = new String(cFFile.szName, "UTF-8");
            }
            catch (Exception exception) {}
        } else {
            this.m_sName = new String(cFFile.szName);
        }
        int n = (cFFile.date >> 9) + 1980;
        int n2 = cFFile.date >> 5 & 0xF;
        int n3 = cFFile.date >> 0 & 0x1F;
        int n4 = cFFile.time >> 11;
        int n5 = cFFile.time >> 5 & 0x3F;
        int n6 = cFFile.time << 1 & 0x1E;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        this.m_tTime = calendar.getTimeInMillis();
    }

    public String getName() {
        return this.m_sName;
    }

    public long getSize() {
        return this.m_oCFFile.cbFile;
    }

    public long getTime() {
        return this.m_tTime;
    }

    public int getAttribute() {
        return this.m_oCFFile.attribs;
    }

    public boolean isReadonly() {
        return (this.m_oCFFile.attribs & 1) != 0;
    }

    public boolean isHidden() {
        return (this.m_oCFFile.attribs & 2) != 0;
    }

    public boolean isSystem() {
        return (this.m_oCFFile.attribs & 4) != 0;
    }
}

