/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.OptionConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;

public class Loader {
    private static Logger logger;
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean java1;
    private static boolean ignoreTCL;

    public static URL getResource(String string) {
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            if (!java1 && (classLoader = Loader.getTCL()) != null) {
                logger.debug((Object)("Trying to find [" + string + "] using context classloader " + classLoader + "."));
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
            if ((classLoader = Loader.class.getClassLoader()) != null) {
                LogLog.debug((String)("Trying to find [" + string + "] using " + classLoader + " class loader."));
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
        }
        catch (Throwable throwable) {
            LogLog.warn((String)TSTR, (Throwable)throwable);
        }
        LogLog.debug((String)("Trying to find [" + string + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResource(string);
    }

    public static boolean isJava1() {
        return java1;
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        if (java1 || ignoreTCL) {
            return Class.forName(string);
        }
        try {
            return Loader.getTCL().loadClass(string);
        }
        catch (Throwable throwable) {
            return Class.forName(string);
        }
    }

    static {
        String string;
        int n;
        logger = Logger.getLogger(Loader.class);
        java1 = true;
        ignoreTCL = false;
        String string2 = OptionConverter.getSystemProperty("java.version", null);
        if (string2 != null && (n = string2.indexOf(46)) != -1 && string2.charAt(n + 1) != '1') {
            java1 = false;
        }
        if ((string = OptionConverter.getSystemProperty("log4j.ignoreTCL", null)) != null) {
            ignoreTCL = OptionConverter.toBoolean(string, true);
        }
    }
}

