/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class CMyZip {
    public static boolean IS_DEBUG = false;
    private String m_sPath = "";
    private String m_sEntryPath = "";
    private String m_sDstZipFileName = "";
    private ZipOutputStream m_zos = null;
    private String encoding = null;
    private boolean m_bZipWithChildDirPath = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setZipFileName(String string) throws CMyException {
        if (this.m_zos != null) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label1", "\u975e\u6cd5\u64cd\u4f5c\uff1a\u672a\u5b8c\u6210\u4e0a\u6b21\u538b\u7f29\u64cd\u4f5c(CMyZip.setZipFileName)"));
        }
        this.m_sDstZipFileName = string;
    }

    public void addToZip(String string) throws CMyException {
        this.addToZip(string, true);
    }

    public void addToZip(String string, String string2) throws CMyException {
        File file = new File(string);
        if (file.isDirectory()) {
            throw new CMyException("Accept file only.");
        }
        if (this.m_zos == null) {
            try {
                this.m_zos = new ZipOutputStream(new FileOutputStream(this.m_sDstZipFileName));
                this.m_zos.setEncoding(this.encoding);
            }
            catch (Exception exception) {
                throw new CMyException(50, "\u521b\u5efazip\u8f93\u51fa\u6d41\u5931\u8d25(CMyZip.addToZip)", exception);
            }
            this.m_zos.setMethod(8);
        }
        this.m_sPath = string.replace(File.separatorChar, '/');
        this.m_sEntryPath = "";
        int n = this.m_sPath.lastIndexOf(47);
        if (n > 0) {
            this.m_sPath = this.m_sPath.substring(0, n);
            n = this.m_sPath.lastIndexOf(47);
            this.m_sEntryPath = n > 0 ? this.m_sPath.substring(n + 1) + "/" : this.m_sPath + "/";
            this.m_sPath = this.m_sPath + "/";
        }
        String string3 = file.getPath();
        string3 = this.makeEntryName(string3, true);
        string3 = CMyString.replaceStr(string3, CMyFile.extractMainFileName(file.getName()), string2);
        if (IS_DEBUG) {
            System.out.println("add to zip: " + string3);
        }
        try {
            if (!(string3.equals("") || string3.equals(".") || string3.equals(this.m_sPath))) {
                int n2;
                long l = file.length();
                ZipEntry zipEntry = new ZipEntry(this.m_sEntryPath + string3);
                zipEntry.setMethod(8);
                zipEntry.setTime(file.lastModified());
                zipEntry.setSize(l);
                this.m_zos.putNextEntry(zipEntry);
                byte[] byArray = new byte[1024];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                while ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                    this.m_zos.write(byArray, 0, n2);
                }
                ((InputStream)bufferedInputStream).close();
                this.m_zos.closeEntry();
            }
        }
        catch (Exception exception) {
            throw new CMyException(1, "\u538b\u7f29\u6587\u4ef6\u6216\u76ee\u5f55\u5931\u8d25(CMyZip.addFile)", exception);
        }
    }

    public void addToZip(String string, boolean bl) throws CMyException {
        if (this.m_zos == null) {
            try {
                this.m_zos = new ZipOutputStream(new FileOutputStream(this.m_sDstZipFileName));
                this.m_zos.setEncoding(this.encoding);
            }
            catch (Exception exception) {
                throw new CMyException(50, I18NMessage.get(CMyZip.class, "CMyZip.label2", "\u521b\u5efazip\u8f93\u51fa\u6d41\u5931\u8d25(CMyZip.addToZip)"), exception);
            }
            this.m_zos.setMethod(8);
        }
        this.m_sPath = string.replace(File.separatorChar, '/');
        this.m_sEntryPath = "";
        int n = this.m_sPath.lastIndexOf(47);
        if (n > 0) {
            this.m_sPath = this.m_sPath.substring(0, n);
            n = this.m_sPath.lastIndexOf(47);
            this.m_sEntryPath = n > 0 ? this.m_sPath.substring(n + 1) + "/" : this.m_sPath + "/";
            this.m_sPath = this.m_sPath + "/";
        }
        this.addFile(new File(string), bl);
    }

    public boolean done() throws CMyException {
        if (this.m_zos == null) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label3", "\u65e0\u6548\u8c03\u7528\uff1a\u672a\u8bbe\u5b9a\u76ee\u6807\u6587\u4ef6(CMyZip.done)"));
        }
        try {
            try {
                this.m_zos.finish();
                this.m_zos.close();
            }
            catch (Exception exception) {
                throw new CMyException(50, I18NMessage.get(CMyZip.class, "CMyZip.label4", "\u7ed3\u675fzip\u538b\u7f29\u65f6\u5931\u8d25(CMyZip.done)"), exception);
            }
            Object var3_1 = null;
            this.m_zos = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.m_zos = null;
            throw throwable;
        }
        return true;
    }

    public void zip(String string, String string2) throws CMyException {
        this.setZipFileName(string2);
        this.addToZip(string);
        this.done();
    }

    private void addFile(File file, boolean bl) throws CMyException {
        String string = file.getPath();
        boolean bl2 = file.isDirectory();
        if (bl2 && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = this.makeEntryName(string, bl);
        if (IS_DEBUG) {
            System.out.println("add to zip: " + string);
        }
        try {
            if (!(string.equals("") || string.equals(".") || string.equals(this.m_sPath))) {
                long l = bl2 ? 0L : file.length();
                ZipEntry zipEntry = new ZipEntry((bl ? this.m_sEntryPath : "") + string);
                zipEntry.setMethod(8);
                zipEntry.setTime(file.lastModified());
                zipEntry.setSize(l);
                this.m_zos.putNextEntry(zipEntry);
                if (!bl2) {
                    int n;
                    byte[] byArray = new byte[1024];
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                        this.m_zos.write(byArray, 0, n);
                    }
                    ((InputStream)bufferedInputStream).close();
                }
                this.m_zos.closeEntry();
            }
            if (bl2) {
                File[] fileArray = file.listFiles();
                if (this.m_bZipWithChildDirPath && !bl) {
                    this.m_sEntryPath = "";
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.addFile(fileArray[i], true);
                    }
                } else {
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.addFile(fileArray[i], bl);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new CMyException(1, I18NMessage.get(CMyZip.class, "CMyZip.label5", "\u538b\u7f29\u6587\u4ef6\u6216\u76ee\u5f55\u5931\u8d25(CMyZip.addFile)"), exception);
        }
    }

    private String makeEntryName(String string, boolean bl) {
        if (!bl) {
            return CMyFile.extractFileName(string);
        }
        String string2 = string.replace(File.separatorChar, '/');
        String string3 = "";
        if (string2.startsWith(this.m_sPath) && this.m_sPath.length() > 0) {
            string3 = this.m_sPath;
        }
        if ((string2 = string2.substring(string3.length())).startsWith("/")) {
            string2 = string2.substring(1);
        } else if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            CMyZip cMyZip = new CMyZip();
            cMyZip.setEncoding("UTF8");
            cMyZip.setZipFileName("d:\\test\\zip\\\u6d4b\u8bd5.zip");
            cMyZip.addToZip("d:\\test\\zip\\edit.htm", true);
            cMyZip.addToZip("d:\\test\\zip\\" + I18NMessage.get(CMyZip.class, "CMyZip.label6", "\u4e2d\u6587.txt"));
            cMyZip.done();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setZipWithChildDirPath(boolean bl) {
        this.m_bZipWithChildDirPath = bl;
    }
}

