/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipFile;
import com.trs.infra.util.jazzlib.ZipInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class CMyUnzip {
    public static boolean IS_DEBUG = false;
    private String zipFileName = null;
    private Hashtable hZipItems = null;
    private String encoding = null;
    private Set m_hStrictFileSet = new HashSet(8);

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    private Hashtable getMyZipItems() throws CMyException {
        if (this.hZipItems == null) {
            this.extractZipItems();
        }
        return this.hZipItems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractZipItems() throws CMyException {
        if (this.zipFileName == null) {
            throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label1", "zip\u6587\u4ef6\u5c1a\u672a\u8bbe\u7f6e\uff08CMyUnzip.getItems\uff09"));
        }
        this.hZipItems = new Hashtable();
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.zipFileName, this.encoding);
                Enumeration enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    this.hZipItems.put(zipEntry.getName().trim().toLowerCase(), zipEntry);
                }
                Object var5_6 = null;
                if (zipFile == null) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label2", "zip\u6587\u4ef6(") + this.zipFileName + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label3", ")\u6ca1\u6709\u627e\u5230\uff08CMyUnzip.getItems\uff09"), fileNotFoundException);
            }
            catch (Exception exception) {
                throw new CMyException(50, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label4", "\u63d0\u53d6zip\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff08CMyUnzip.getItems\uff09"), exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        zipFile.close();
        return;
    }

    public void setZipFile(String string) throws CMyException {
        if (string == null || string.length() == 0) {
            throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label5", "\u6307\u5b9azip\u6587\u4ef6\u540d\u65e0\u6548\uff08CMyUnzip.setZipFile\uff09"));
        }
        this.zipFileName = string;
        if (this.hZipItems != null) {
            this.hZipItems.clear();
            this.hZipItems = null;
        }
    }

    public Enumeration getItems() throws CMyException {
        return this.getMyZipItems().elements();
    }

    public ZipEntry getItem(String string) throws CMyException {
        if (string == null) {
            return null;
        }
        Hashtable hashtable = this.getMyZipItems();
        if (hashtable == null) {
            return null;
        }
        return (ZipEntry)hashtable.get(string.toLowerCase());
    }

    /*
     * Loose catch block
     */
    public void unzip(String string, boolean bl) throws CMyException {
        block38: {
            Exception exception4222;
            ZipInputStream zipInputStream;
            BufferedInputStream bufferedInputStream;
            FileInputStream fileInputStream;
            block36: {
                if (this.zipFileName == null) {
                    throw new CMyException(10, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label6", "zip\u6587\u4ef6\u5c1a\u672a\u8bbe\u7f6e\uff08CMyUnzip.unzip\uff09"));
                }
                if (!CMyFile.fileExists(string)) {
                    if (!bl) {
                        throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label7", "\u76ee\u6807\u76ee\u5f55") + string + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label8", "\u4e0d\u5b58\u5728\uff08CMyUnzip.unzip\uff09"));
                    }
                    CMyFile.makeDir(string, true);
                }
                fileInputStream = null;
                bufferedInputStream = null;
                zipInputStream = null;
                fileInputStream = new FileInputStream(this.zipFileName);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                zipInputStream = new ZipInputStream(bufferedInputStream);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry(this.encoding)) != null) {
                    String string2;
                    String string3;
                    if (IS_DEBUG) {
                        System.out.println("[unzip] name=" + zipEntry.getName() + "," + " size=" + zipEntry.getSize());
                    }
                    if (zipEntry.isDirectory() || !this.isStrictFile(string3 = zipEntry.getName())) continue;
                    if (File.separatorChar != '/') {
                        string3 = CMyString.replaceStr(string3, "/", File.separator);
                    }
                    string3 = string + string3;
                    if (IS_DEBUG) {
                        System.out.println("==>Dest=" + string3);
                    }
                    if (!CMyFile.pathExists(string2 = CMyFile.extractFilePath(string3))) {
                        CMyFile.makeDir(string2, true);
                    }
                    FileOutputStream fileOutputStream = null;
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    fileOutputStream = new FileOutputStream(string3);
                    while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    Object var13_15 = null;
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {}
                    continue;
                    {
                        catch (Exception exception3) {
                            throw new CMyException(50, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label9", "\u8bfb\u53d6\u6587\u4ef6\u6570\u636e\u6d41\u5931\u8d25\uff08CMyUnzip.unzip\uff09"), exception3);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_15 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                Object var16_18 = null;
                this.m_hStrictFileSet.clear();
                if (zipInputStream == null) break block36;
                try {
                    zipInputStream.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception4222) {}
            }
            break block38;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CMyException(55, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label10", "\u538b\u7f29\u6587\u4ef6") + this.zipFileName + I18NMessage.get(CMyUnzip.class, "CMyUnzip.label11", "\u6ca1\u6709\u627e\u5230\uff08CMyUnzip.unzip\uff09"), fileNotFoundException);
                }
                catch (Exception exception5) {
                    throw new CMyException(1, I18NMessage.get(CMyUnzip.class, "CMyUnzip.label12", "\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5b57\u7b26\u7f16\u7801\u96c6\u4e0d\u5339\u914d\uff08CMyUnzip.unzip\uff09"), exception5);
                }
            }
            catch (Throwable throwable) {
                Exception exception62222;
                Object var16_19 = null;
                this.m_hStrictFileSet.clear();
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception62222) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception62222) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception62222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static void unzip(String string, String string2, boolean bl) throws CMyException {
        CMyUnzip cMyUnzip = new CMyUnzip();
        cMyUnzip.setZipFile(string);
        cMyUnzip.unzip(string2, bl);
    }

    public void addStrictFile(String string) {
        if (CMyString.isEmpty(string)) {
            return;
        }
        string = string.toLowerCase();
        this.m_hStrictFileSet.addAll(Arrays.asList(CMyString.split(string, ",")));
    }

    private boolean isStrictFile(String string) {
        if (this.m_hStrictFileSet.isEmpty()) {
            return true;
        }
        String string2 = CMyFile.extractFileExt(string);
        return this.m_hStrictFileSet.contains(string2.toLowerCase());
    }

    public static void main(String[] stringArray) {
        CMyUnzip cMyUnzip = new CMyUnzip();
        try {
            cMyUnzip.setZipFile(I18NMessage.get(CMyUnzip.class, "CMyUnzip.label13", "d:\\test\\zip\\\u6d4b\u8bd5.zip"));
            cMyUnzip.setEncoding("UTF8");
            Enumeration enumeration = cMyUnzip.getItems();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                if (zipEntry == null) continue;
                System.out.println("[Item " + ++n + "] name=" + zipEntry.getName() + " size=" + zipEntry.getSize() + " compressed size=" + zipEntry.getCompressedSize());
            }
            cMyUnzip.unzip("d:\\test\\zip\\test\\", true);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

