/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFilenameFilter;
import com.trs.infra.util.CMyString;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class CMyFile {
    private static Logger m_oLogger = Logger.getLogger(CMyFile.class);

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static boolean pathExists(String string) {
        String string2 = CMyFile.extractFilePath(string);
        return CMyFile.fileExists(string2);
    }

    public static String extractFileName(String string) {
        return CMyFile.extractFileName(string, File.separator);
    }

    public static String extractFileName(String string, String string2) {
        int n = -1;
        if (string2 == null) {
            n = string.lastIndexOf(File.separatorChar);
            if (n < 0) {
                n = string.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            n = string.lastIndexOf(string2);
        }
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String extractHttpFileName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(n + 1);
    }

    public static String extractMainFileName(String string) {
        String string2 = CMyFile.extractFileName(string);
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            return string2.substring(0, n);
        }
        return string2;
    }

    public static String excludeFileExt(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String extractFileExt(String string) {
        if (string.endsWith("7png")) {
            return "png";
        }
        if (string.endsWith("7jpg")) {
            return "jpg";
        }
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : "";
    }

    public static String extractFilePath(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        return n >= 0 ? string.substring(0, n + 1) : "";
    }

    public static String toAbsolutePathName(String string) {
        File file = new File(string);
        return file.getAbsolutePath();
    }

    public static String extractFileDrive(String string) {
        int n = string.length();
        if (n > 2 && string.charAt(1) == ':') {
            return string.substring(0, 2);
        }
        if (n > 2 && string.charAt(0) == File.separatorChar && string.charAt(1) == File.separatorChar) {
            int n2 = string.indexOf(File.separatorChar, 2);
            if (n2 >= 0) {
                n2 = string.indexOf(File.separatorChar, n2 + 1);
            }
            return n2 >= 0 ? string.substring(0, n2) : string;
        }
        return "";
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        return file.exists() ? file.delete() : false;
    }

    public static boolean makeDir(String string, boolean bl) {
        boolean bl2 = false;
        File file = new File(string);
        bl2 = bl ? file.mkdirs() : file.mkdir();
        if (!bl2) {
            bl2 = file.exists();
        }
        return bl2;
    }

    public static boolean deleteDir(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (bl) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    CMyFile.deleteDir(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return file.delete();
    }

    public static boolean deleteDir(String string) {
        File file = new File(string);
        return CMyFile.deleteDir(file);
    }

    public static boolean deleteDir(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    CMyFile.deleteDir(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return file.delete();
    }

    public static File[] listFiles(String string, String string2) {
        File file = new File(string);
        if (string2.charAt(0) != '.') {
            string2 = "." + string2;
        }
        File[] fileArray = file.listFiles(new CMyFilenameFilter(string2));
        return fileArray;
    }

    public static File[] listSubDirectories(String string) {
        File file = new File(string);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        return fileArray;
    }

    public static String readFile(String string) throws CMyException {
        return CMyFile.readFile(string, CMyString.FILE_WRITING_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String string, String string2) throws CMyException {
        String string3;
        InputStreamReader inputStreamReader = null;
        StringBuffer stringBuffer = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        if (string2 == null) {
            string2 = "UTF-8";
        }
        try {
            try {
                String string4;
                fileInputStream = new FileInputStream(string);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string2));
                boolean bl = "UTF-8".equalsIgnoreCase(string2);
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append("\n");
                    }
                    if (bl) {
                        string4 = CMyFile.removeBomHeaderIfExists(string4);
                        bl = false;
                    }
                    stringBuffer.append(string4);
                }
                string3 = stringBuffer == null ? "" : stringBuffer.toString();
                Object var10_11 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CMyException(55, I18NMessage.get(CMyFile.class, "CMyFile.label1", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new CMyException(53, I18NMessage.get(CMyFile.class, "CMyFile.label2", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), iOException);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return string3;
        }
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream == null) return string3;
        fileInputStream.close();
        return string3;
    }

    private static String removeBomHeaderIfExists(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.length() > 0) {
            char c = string2.charAt(0);
            while ((c == '\ufeff' || c == '\ufffe') && (string2 = string2.substring(1)).length() != 0) {
                c = string2.charAt(0);
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    public static byte[] readBytesFromFile(String string) throws CMyException {
        Exception exception222;
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream fileInputStream;
        block13: {
            fileInputStream = null;
            byteArrayOutputStream = null;
            fileInputStream = new FileInputStream(string);
            byte[] byArray2 = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            int n = 0;
            while ((n = fileInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_7 = null;
            if (byteArrayOutputStream == null) break block13;
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        return byArray;
        catch (Exception exception3) {
            try {
                throw new CMyException("\u8bfb\u53d6\u6587\u4ef6[" + string + "]\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                block15: {
                    Exception exception4222;
                    Object var7_8 = null;
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception4222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream == null) break block15;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception4222) {}
                }
                throw throwable;
            }
        }
    }

    public static boolean writeFile(String string, String string2) throws CMyException {
        return CMyFile.writeFile(string, string2, CMyString.FILE_WRITING_ENCODING);
    }

    public static boolean writeFile(String string, String string2, String string3) throws CMyException {
        return CMyFile.writeFile(string, string2, string3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(String string, String string2, String string3, boolean bl) throws CMyException {
        String string4 = CMyFile.extractFilePath(string);
        if (!CMyFile.pathExists(string4)) {
            CMyFile.makeDir(string4, true);
        }
        String string5 = CMyString.showNull(string3, CMyString.FILE_WRITING_ENCODING);
        boolean bl2 = false;
        FileOutputStream fileOutputStream = null;
        Writer writer = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, string5);
                if (bl) {
                    writer.write(65279);
                }
                writer.write(string2);
                bl2 = true;
            }
            catch (Exception exception) {
                m_oLogger.error((Object)(I18NMessage.get(CMyFile.class, "CMyFile.label5", "\u5199\u6587\u4ef6[") + string + I18NMessage.get(CMyFile.class, "CMyFile.label6", "]\u53d1\u751f\u5f02\u5e38")), (Throwable)exception);
                throw new CMyException(54, I18NMessage.get(CMyFile.class, "CMyFile.label7", "\u5199\u6587\u4ef6\u9519\u8bef(CMyFile.writeFile)"), exception);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (writer != null) {
            writer.flush();
            writer.close();
        }
        if (fileOutputStream == null) return bl2;
        fileOutputStream.close();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean appendFile(String string, String string2) throws CMyException {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
                randomAccessFile.seek(randomAccessFile.length());
                randomAccessFile.writeBytes(string2);
                bl = true;
            }
            catch (Exception exception) {
                throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label8", "\u5411\u6587\u4ef6\u8ffd\u52a0\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.appendFile)"), exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (randomAccessFile == null) throw throwable;
                randomAccessFile.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (randomAccessFile == null) return bl;
        randomAccessFile.close();
        return bl;
    }

    public static boolean moveFile(String string, String string2) throws CMyException {
        return CMyFile.moveFile(string, string2, true);
    }

    public static boolean moveFile(String string, String string2, boolean bl) throws CMyException {
        CMyFile.copyFile(string, string2, bl);
        CMyFile.deleteFile(string);
        return false;
    }

    public static boolean copyFile(String string, String string2) throws CMyException {
        return CMyFile.copyFile(string, string2, true);
    }

    public static boolean copyFile(String string, String string2, boolean bl) throws CMyException {
        return CMyFile.copyFile(string, string2, bl, false);
    }

    /*
     * Loose catch block
     */
    public static boolean copyFile(String string, String string2, boolean bl, boolean bl2) throws CMyException {
        block28: {
            Exception exception322;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block27: {
                int n;
                File file;
                File file2;
                block24: {
                    Exception exception2222;
                    boolean bl3;
                    block25: {
                        fileInputStream = null;
                        fileOutputStream = null;
                        file2 = new File(string);
                        file = new File(string2);
                        if (!file2.equals(file)) break block24;
                        bl3 = true;
                        Object var11_13 = null;
                        if (fileOutputStream == null) break block25;
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    return bl3;
                }
                fileInputStream = new FileInputStream(file2);
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (bl) {
                        if (!CMyFile.makeDir(CMyFile.extractFilePath(string2), true)) {
                            throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label9", "\u4e3a\u76ee\u6807\u6587\u4ef6[") + string2 + I18NMessage.get(CMyFile.class, "CMyFile.label10", "]\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01"));
                        }
                        fileOutputStream = new FileOutputStream(string2);
                    }
                    throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label11", "\u6307\u5b9a\u76ee\u6807\u6587\u4ef6[") + string2 + I18NMessage.get(CMyFile.class, "CMyFile.label12", "]\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff01"), fileNotFoundException);
                }
                byte[] byArray = new byte[4096];
                while ((n = fileInputStream.read(byArray, 0, 4096)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.flush();
                Object var11_14 = null;
                if (fileOutputStream == null) break block27;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception322) {
                    // empty catch block
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception322) {}
            }
            break block28;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CMyException(55, I18NMessage.get(CMyFile.class, "CMyFile.label13", "\u8981\u590d\u5236\u7684\u539f\u6587\u4ef6\u6ca1\u6709\u53d1\u73b0(CMyFile.copyFile)"), fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label14", "\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.copyFile)"), iOException);
                }
            }
            catch (Throwable throwable) {
                Exception exception4222;
                Object var11_15 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception4222) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception4222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (bl2) {
            new File(string2).setLastModified(new File(string).lastModified());
        }
        return true;
    }

    public static void copyFileDir(String string, String string2, boolean bl) throws CMyException {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(string2)) {
            return;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (file.isFile() || file2.isFile()) {
            throw new CMyException("\u6e90\u76ee\u5f55\u548c\u76ee\u6807\u76ee\u5f55\u90fd\u4e0d\u80fd\u662f\u6587\u4ef6\uff01");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        string = CMyString.setStrEndWith(string, File.separatorChar);
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        if (bl) {
            File file3 = new File(string2 + file.getName());
            if (!file3.exists()) {
                file3.mkdir();
            }
            string2 = string2 + file.getName();
            string2 = string2 + File.separatorChar;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file4 = fileArray[i];
            if (file4 == null || "Thumbs.db".equals(file4.getName())) continue;
            if (!file4.isFile()) {
                String string3 = string2 + file4.getName();
                if (!CMyFile.fileExists(string3)) {
                    CMyFile.makeDir(string3, true);
                }
                CMyFile.copyFileDir(string + file4.getName(), string3, false);
                continue;
            }
            try {
                CMyFile.copyFile(string + file4.getName(), string2 + file4.getName(), true);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getStackTrace());
            }
        }
    }

    public static String mapResouceFullPath(String string) throws WCMException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + string + I18NMessage.get(CMyFile.class, "CMyFile.label16", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        String string2 = null;
        try {
            string2 = uRL.getFile();
            if (string2.indexOf(37) >= 0) {
                String string3 = System.getProperty("file.encoding", "GBK");
                string2 = URLDecoder.decode(uRL.getFile(), string3);
            }
        }
        catch (Exception exception) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + uRL.getFile() + I18NMessage.get(CMyFile.class, "CMyFile.label17", "]\u8f6c\u6362\u5931\u8d25\uff01"), exception);
        }
        return string2;
    }

    public static String mapResouceFullPath(String string, Class clazz) throws WCMException {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + string + I18NMessage.get(CMyFile.class, "CMyFile.label16", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        String string2 = null;
        try {
            string2 = uRL.getFile();
            if (string2.indexOf(37) >= 0) {
                String string3 = System.getProperty("file.encoding", "GBK");
                string2 = URLDecoder.decode(uRL.getFile(), string3);
            }
        }
        catch (Exception exception) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + uRL.getFile() + I18NMessage.get(CMyFile.class, "CMyFile.label17", "]\u8f6c\u6362\u5931\u8d25\uff01"), exception);
        }
        return string2;
    }

    public static boolean validImageFile(String string, int n, int n2) {
        BufferedImage bufferedImage;
        if (!CMyFile.fileExists(string)) {
            return false;
        }
        File file = new File(string);
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.error((Object)("\u8bfb\u53d6\u6587\u4ef6[" + string + "]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)iOException);
            }
            return false;
        }
        int n3 = bufferedImage.getWidth();
        if (n3 < n) {
            return false;
        }
        int n4 = bufferedImage.getHeight();
        return n4 >= n2;
    }

    public static void main(String[] stringArray) {
        try {
            CMyFile.writeFile("c:\\test.txt", I18NMessage.get(CMyFile.class, "CMyFile.label18", "\u4e2d\u56fd\u4ebatest"), "UTF-16LE", true);
            String string = "";
            string = "d:\\temp\\InfoRadar.pdf";
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            System.out.println(I18NMessage.get(CMyFile.class, "CMyFile.label19", "==============\u6240\u7528\u65f6\u95f4\uff1a") + (l2 - l) + "ms ==============");
            string = "d:\\write_test.html";
            String string2 = CMyFile.readFile(string);
            l = System.currentTimeMillis();
            CMyFile.writeFile(string + ".new", string2);
            l2 = System.currentTimeMillis();
            System.out.println(I18NMessage.get(CMyFile.class, "CMyFile.label19", "==============\u6240\u7528\u65f6\u95f4\uff1a") + (l2 - l) + "ms ==============");
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace(System.out);
        }
    }
}

