/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyString;
import java.math.BigInteger;

public class CMyBitsValue
implements Cloneable {
    protected long value = 0L;

    public CMyBitsValue() {
        this.value = 0L;
    }

    public CMyBitsValue(long l) {
        this.setValue(l);
    }

    public CMyBitsValue(String string) {
        this.setValue(string);
    }

    public CMyBitsValue(CMyBitsValue cMyBitsValue) {
        this.copy(cMyBitsValue);
    }

    public void copy(CMyBitsValue cMyBitsValue) {
        this.setValue(cMyBitsValue.getValue());
    }

    public Object clone() {
        return new CMyBitsValue(this);
    }

    public static boolean getBitOfInt(int n, int n2) {
        if (n2 < 0 || n2 > 31) {
            return false;
        }
        return BigInteger.valueOf(n).testBit(n2);
    }

    public static boolean getBit(long l, int n) {
        if (n < 0 || n > 63) {
            return false;
        }
        return BigInteger.valueOf(l).testBit(n);
    }

    public static long setBit(long l, int n, boolean bl) {
        if (n < 0 || n > 63) {
            return l;
        }
        BigInteger bigInteger = BigInteger.valueOf(l);
        bigInteger = bl ? bigInteger.setBit(n) : bigInteger.clearBit(n);
        return bigInteger.longValue();
    }

    protected static int setBitOfInt(int n, int n2, boolean bl) {
        if (n2 < 0 || n2 > 31) {
            return n;
        }
        return (int)CMyBitsValue.setBit(n, n2, bl);
    }

    public long getValue() {
        return this.value;
    }

    public int getValueAsInt() {
        return (int)this.value;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(String string) {
        if (string == null) {
            return;
        }
        BigInteger bigInteger = BigInteger.valueOf(0L);
        int n = string.length();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '1') {
                bigInteger = bigInteger.setBit(n2);
            }
            --n2;
        }
        this.value = bigInteger.longValue();
    }

    public boolean getBit(int n) {
        return CMyBitsValue.getBit(this.value, n);
    }

    public CMyBitsValue setBit(int n, boolean bl) {
        this.value = CMyBitsValue.setBit(this.value, n, bl);
        return this;
    }

    public void and(CMyBitsValue cMyBitsValue) {
        if (cMyBitsValue == null) {
            return;
        }
        this.and(cMyBitsValue.getValue());
    }

    public void and(long l) {
        BigInteger bigInteger = BigInteger.valueOf(this.value);
        bigInteger = bigInteger.and(BigInteger.valueOf(l));
        this.value = bigInteger.longValue();
    }

    public void or(CMyBitsValue cMyBitsValue) {
        if (cMyBitsValue == null) {
            return;
        }
        this.or(cMyBitsValue.getValue());
    }

    public void or(long l) {
        BigInteger bigInteger = BigInteger.valueOf(this.value);
        bigInteger = bigInteger.or(BigInteger.valueOf(l));
        this.value = bigInteger.longValue();
    }

    public int getRealLength() {
        return BigInteger.valueOf(this.value).bitLength();
    }

    public String toString() {
        return this.toString(this.getRealLength());
    }

    public String toString(int n) {
        String string = Long.toBinaryString(this.value);
        if (n > this.getRealLength()) {
            string = CMyString.expandStr(string, n, '0', false);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        int n;
        CMyBitsValue cMyBitsValue = new CMyBitsValue(0L);
        System.out.println(cMyBitsValue.toString(10));
        cMyBitsValue.setBit(31, true);
        System.out.println(cMyBitsValue.toString());
        cMyBitsValue.setBit(1, true);
        cMyBitsValue.setBit(2, false);
        cMyBitsValue.setBit(3, true);
        cMyBitsValue.setBit(10, true);
        cMyBitsValue.setBit(9, false);
        cMyBitsValue.setBit(8, true);
        cMyBitsValue.setBit(7, true);
        System.out.println(cMyBitsValue.toString());
        System.out.println("10=" + cMyBitsValue.getBit(10));
        System.out.println("1=" + cMyBitsValue.getBit(1));
        System.out.println("2=" + cMyBitsValue.getBit(2));
        int n2 = 64;
        cMyBitsValue.setValue(0L);
        for (n = 0; n < n2; ++n) {
            cMyBitsValue.setBit(n, true);
        }
        for (n = n2 - 1; n >= 0; --n) {
            System.out.print(n % 10 == 0 && n > 0 ? " " : String.valueOf(n % 10));
        }
        System.out.print("\n");
        System.out.println(cMyBitsValue.toString(n2));
        for (n = n2 - 1; n >= 0; --n) {
            System.out.print(cMyBitsValue.getBit(n) ? "1" : "0");
        }
        System.out.println("\n");
        System.out.println(CMyString.expandStr(Long.toBinaryString(Long.MAX_VALUE), 64, '0', true) + " : MAX=" + Long.MAX_VALUE);
        System.out.println(Long.toBinaryString(Long.MIN_VALUE) + " : MIN=" + Long.MIN_VALUE);
        System.out.println("\n========= Test for BigInteger ==========");
        BigInteger bigInteger = BigInteger.valueOf(0L);
        bigInteger = bigInteger.setBit(31).setBit(63);
        System.out.println(bigInteger.toString(2));
        long l = bigInteger.longValue();
        System.out.println(Long.toBinaryString(l));
        bigInteger = BigInteger.valueOf(l);
        System.out.println("\n");
        for (n = 63; n >= 0; --n) {
            System.out.print(bigInteger.testBit(n) ? "1" : "0");
        }
        int n3 = 0;
        n3 = CMyBitsValue.setBitOfInt(n3, 31, true);
        System.out.println("\n int = " + n3);
        for (n = 0; n < 32; ++n) {
            n3 = CMyBitsValue.setBitOfInt(n3, n, n % 2 == 1);
        }
        n3 = CMyBitsValue.setBitOfInt(n3, 31, false);
        for (n = 31; n >= 0; --n) {
            System.out.print(CMyBitsValue.getBitOfInt(n3, n) ? "1" : "0");
        }
        System.out.println("\n");
        System.out.println(Long.toBinaryString(n3));
        String string = "10101";
        cMyBitsValue.setValue(string);
        System.out.println("src = " + string);
        System.out.println("dst = " + cMyBitsValue.toString(10));
        cMyBitsValue.or(2L);
        System.out.println("or  = " + cMyBitsValue.toString());
        cMyBitsValue.and(5L);
        System.out.println("and = " + cMyBitsValue.toString());
    }
}

