/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.config.Configs;
import com.trs.infra.support.config.PathConfig;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FilesMan {
    private static Logger s_logger = Logger.getLogger(FilesMan.class);
    private static FilesMan m_filesMan = new FilesMan();
    public static final int FILENAME_MIN_LENGTH = 22;
    public static final int FILENAME_FLAG_LENGTH = 2;
    public static final int FILENAME_DATE_LENGTH = 8;
    public static final int FILENAME_TIME_LENGTH = 8;
    public static final int FILENAME_RANDOM_LENGTH = 4;
    private static final int TIMEZONE_RAWOFFSET = TimeZone.getDefault().getRawOffset();
    public static final String FLAG_NORMAL = "N0";
    public static final String FLAG_PROTECTED = "P0";
    public static final String FLAG_UPLOAD = "U0";
    public static final String FLAG_SYSTEMTEMP = "ST";
    public static final String FLAG_USERTEMP = "UT";
    public static final String FLAG_TEMPLATE = "TM";
    public static final String FLAG_LOCALPUB = "LP";
    public static final String FLAG_LOCALPREVIEW = "LV";
    public static final String FLAG_WEBFILE = "W0";
    public static final String FLAG_DOCUMENTSOURCE = "DS";
    public static final String FLAG_SITEFROM = "SF";
    public static final String FLAG_BIGTABLE = "BT";
    public static final String FLAG_INFOVIEW = "IV";
    public static final String FLAG_TRANSFORMER = "TF";
    public static final String FLAG_HELPSEARCH = "HS";
    public static final int PATH_LOCAL = 0;
    public static final int PATH_HTTP = 1;
    public static final int PATH_FTP = 2;
    private final HashMap m_hPathConfig = new HashMap(11);

    private FilesMan() {
    }

    public static FilesMan getFilesMan() {
        if (FilesMan.m_filesMan.m_hPathConfig.isEmpty()) {
            FilesMan.loadFilesMan();
        }
        return m_filesMan;
    }

    private synchronized void loadPathConfigs(boolean bl) throws WCMException {
        if (!FilesMan.m_filesMan.m_hPathConfig.isEmpty()) {
            return;
        }
        Configs configs = null;
        Config config = null;
        ConfigServer configServer = ConfigServer.getServer();
        try {
            configs = new Configs();
            configs.open(new WCMFilter("", "CType=10", ""));
            for (int i = 0; i < configs.size(); ++i) {
                config = (Config)configs.getAt(i);
                if (config == null) continue;
                String string = config.getConfigKey();
                String string2 = configServer.getInitProperty(string);
                if (CMyString.isEmpty(string2)) {
                    string2 = config.getValue();
                    configServer.setInitProperties(string, string2);
                }
                try {
                    this.putPathConfig(string, string2, bl);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.error((Object)(I18NMessage.get(FilesMan.class, "FilesMan.label1", "--->\u914d\u7f6e\u8bb0\u5f55\uff1aWCMConfig Id=[") + config.getId() + "] Key=[" + config.getConfigKey() + "]  Value=[" + config.getValue() + "] \uff09"), (Throwable)exception);
                }
            }
            configs.clear();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label2", "\u88c5\u8f7d\u6587\u4ef6\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u65f6\u5931\u8d25(FilesMan.loadPathConfigs)"), exception);
        }
    }

    public boolean putPathConfig(Config config, boolean bl) throws WCMException {
        if (config == null || !config.isValidInstance()) {
            return false;
        }
        try {
            String string = config.getConfigKey().trim();
            if (string.length() != 2) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label3", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d(FilesMan.loadPathConfig)"));
            }
            PathConfig pathConfig = new PathConfig(config.getValue());
            return this.putPathConfig(string, pathConfig, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label4", "\u88c5\u8f7d\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(FilesMan.putPathConfig)"), exception);
        }
    }

    public boolean putPathConfig(String string, String string2, boolean bl) throws WCMException {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(string2)) {
            return false;
        }
        try {
            string = string.trim();
            if (string.length() != 2) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label3", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d(FilesMan.loadPathConfig)"));
            }
            PathConfig pathConfig = new PathConfig(string2);
            return this.putPathConfig(string, pathConfig, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label4", "\u88c5\u8f7d\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(FilesMan.putPathConfig)"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putPathConfig(String string, PathConfig pathConfig, boolean bl) throws Exception {
        if (pathConfig == null) {
            return false;
        }
        String string2 = pathConfig.getLocalPath();
        if (!CMyFile.fileExists(string2)) {
            if (bl) {
                CMyFile.makeDir(string2, true);
            } else {
                throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label5", "\u672c\u5730\u8def\u5f84") + string2 + I18NMessage.get(FilesMan.class, "FilesMan.label6", "\u4e0d\u5b58\u5728(FilesMan.loadPathConfig)"));
            }
        }
        HashMap hashMap = this.m_hPathConfig;
        synchronized (hashMap) {
            this.m_hPathConfig.put(string.toUpperCase(), pathConfig);
        }
        return true;
    }

    public PathConfig removePathConfig(String string) {
        return null;
    }

    public PathConfig getPathConfig(String string) {
        return (PathConfig)this.m_hPathConfig.get(string);
    }

    public String getPathConfigValue(String string, int n) {
        String string2;
        PathConfig pathConfig = this.getPathConfig(string);
        if (pathConfig == null) {
            return null;
        }
        switch (n) {
            case 0: {
                string2 = pathConfig.getLocalPath();
                string2 = FilesMan.getLocalFormatPath(string2);
                break;
            }
            case 1: {
                string2 = pathConfig.getHttpPath();
                break;
            }
            case 2: {
                string2 = pathConfig.getFtpPath();
                break;
            }
            default: {
                return null;
            }
        }
        return string2;
    }

    private static String getLocalFormatPath(String string) {
        String string2;
        String string3;
        if (CMyString.isEmpty(string)) {
            return "";
        }
        if (File.separatorChar == '/') {
            string3 = "//";
            string2 = "/";
        } else {
            string3 = "\\\\\\\\";
            string2 = "\\\\";
        }
        return string.replaceAll(string3, string2);
    }

    public String mapFilePath(String string, int n) throws WCMException {
        String string2;
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label7", "\u6587\u4ef6\u540d\u4e3a\u7a7a(FilesMan.mapFilePath)"));
        }
        string = string.trim();
        if ((string = CMyFile.extractFileName(string)).length() < 22) {
            throw new WCMException(10, "[" + string + I18NMessage.get(FilesMan.class, "FilesMan.label8", "]\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.mapFilePath)"));
        }
        PathConfig pathConfig = null;
        pathConfig = this.getPathConfig(string.substring(0, 2));
        if (pathConfig == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label9", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5339\u914d\uff1a\u7c7b\u578b\u6807\u8bc6\u65e0\u6548(FilesMan.mapFilePath)"));
        }
        char c = n == 0 ? File.separatorChar : (char)'/';
        switch (n) {
            case 0: {
                string2 = pathConfig.getLocalPath();
                break;
            }
            case 1: {
                string2 = pathConfig.getHttpPath();
                break;
            }
            case 2: {
                string2 = pathConfig.getFtpPath();
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label10", "\u65e0\u6548\u7684\u8def\u5f84\u7c7b\u522b(FilesMan.mapFilePath)"));
            }
        }
        string2 = string2 + string.substring(0, 8) + c + string.substring(0, 10) + c;
        return string2;
    }

    public synchronized String getNextFileName(String string, String string2, CMyDateTime cMyDateTime, boolean bl) throws WCMException {
        PathConfig pathConfig = null;
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label11", "\u8def\u5f84\u6807\u8bc6\u4e3a\u7a7a\uff08FilesMan.getNextFileName\uff09"));
        }
        pathConfig = (PathConfig)this.m_hPathConfig.get(string = string.trim().toUpperCase());
        if (pathConfig == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label12", "\u65e0\u6548\u7684\u8def\u5f84\u6807\u8bc6\u53c2\u6570(FilesMan.getNextFileName)"));
        }
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            cMyDateTime = CMyDateTime.now();
        }
        String string3 = cMyDateTime.toString("yyyyMMdd");
        String string4 = pathConfig.getLocalPath() + string + string3.substring(0, 6) + File.separatorChar + string + string3.substring(0, 8) + File.separatorChar;
        if (!CMyFile.fileExists(string4)) {
            try {
                CMyFile.makeDir(string4, true);
            }
            catch (Exception exception) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label13", "\u6307\u5b9a\u8def\u5f84") + string4 + I18NMessage.get(FilesMan.class, "FilesMan.label14", "\u65e0\u6cd5\u521b\u5efa(FilesMan.getNextFileName)"));
            }
        }
        long l = (cMyDateTime.getTimeInMillis() + (long)TIMEZONE_RAWOFFSET) % 86400000L;
        String string5 = CMyString.numberToStr(l, 8, '0');
        String string6 = CMyString.numberToStr(Math.round(Math.random() * 10000.0), 4, '0');
        String string7 = string2.trim();
        if (string7.length() > 0 && string7.charAt(0) != '.') {
            string7 = "." + string7;
        }
        String string8 = string + string3 + string5 + string6;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                string8 = string8 + CMyString.numberToStr(Math.round(Math.random() * 100.0), 2, '0');
            }
            if (CMyFile.fileExists(string4 + string8 + string7)) continue;
            return (bl ? string4 : "") + string8 + string7;
        }
        return null;
    }

    public synchronized String getNextFileName(String string, String string2) throws WCMException {
        return this.getNextFileName(string, string2, null, false);
    }

    public synchronized String getNextFileName(String string, String string2, CMyDateTime cMyDateTime) throws WCMException {
        return this.getNextFileName(string, string2, cMyDateTime, false);
    }

    public synchronized String getNextFilePathName(String string, String string2) throws WCMException {
        return this.getNextFileName(string, string2, null, true);
    }

    public synchronized String getNextFilePathName(String string, String string2, CMyDateTime cMyDateTime) throws WCMException {
        return this.getNextFileName(string, string2, cMyDateTime, true);
    }

    public static String extractFileCrDateValue(String string) throws WCMException {
        if (string.length() < 22) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label15", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrDateValue)"));
        }
        String string2 = string.substring(2, 6) + "-" + string.substring(6, 8) + "-" + string.substring(8, 10);
        return string2;
    }

    public static long extractFileCrTimeValue(String string) throws WCMException {
        long l;
        if (string.length() < 22) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label16", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrTimeValue)"));
        }
        try {
            l = Integer.parseInt(string.substring(10, 18));
        }
        catch (Exception exception) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label16", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrTimeValue)"), exception);
        }
        return l;
    }

    public static CMyDateTime extractFileCrDate(String string) throws WCMException {
        CMyDateTime cMyDateTime;
        String string2 = FilesMan.extractFileCrDateValue(string);
        try {
            cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateWithString(string2, 0);
        }
        catch (CMyException cMyException) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label17", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrDate)"), cMyException);
        }
        return cMyDateTime;
    }

    public static CMyDateTime extractFileCrDateTime(String string) throws WCMException {
        CMyDateTime cMyDateTime = null;
        cMyDateTime = FilesMan.extractFileCrDate(string);
        long l = FilesMan.extractFileCrTimeValue(string);
        return new CMyDateTime(cMyDateTime.getTimeInMillis() + l);
    }

    public String copyFile(String string, String string2, boolean bl) throws WCMException {
        try {
            String string3 = CMyFile.extractFileExt(string);
            String string4 = this.getNextFilePathName(string2, string3);
            CMyFile.copyFile(string, string4);
            return bl ? string4 : CMyFile.extractFileName(string4);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label18", "\u590d\u5236\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.copyFile\uff09"), exception);
        }
    }

    public String moveFile(String string, String string2, boolean bl) throws WCMException {
        try {
            String string3 = this.copyFile(string, string2, bl);
            CMyFile.deleteFile(string);
            return string3;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label19", "\u79fb\u52a8\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.moveFile\uff09"), exception);
        }
    }

    public boolean deleteFile(String string) throws WCMException {
        try {
            string = CMyFile.extractFileName(string.trim());
            String string2 = this.mapFilePath(string, 0) + string;
            return CMyFile.deleteFile(string2);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label20", "\u5220\u9664\u6307\u5b9a\u7684\u6587\u4ef6\u5931\u8d25\uff08FilesMan.deleteFile\uff09"), exception);
        }
    }

    public String getTempAppendixFilePath(int n, int n2, boolean bl) throws WCMException {
        return this.getTemplateAppendixPath(103, n, n2, bl);
    }

    public String getTemplateAppendixPath(int n, int n2, int n3, boolean bl) throws WCMException {
        String string = this.getPathConfigValue(FLAG_TEMPLATE, n3);
        if (string == null) {
            throw new WCMException(1100, "Path config for TM missing!");
        }
        char c = n3 == 0 ? File.separatorChar : (char)'/';
        string = n == 103 ? string + "site" : string + "root" + Integer.toHexString(n) + c;
        string = string + n2 + "" + c;
        if (n3 == 0 && bl) {
            try {
                CMyFile.makeDir(string, true);
            }
            catch (Exception exception) {
                throw new WCMException(1100, "Failed to create template appendixes path:" + string, exception);
            }
        }
        return string;
    }

    public String getFileFlag(String string) {
        String string2 = "";
        String string3 = "";
        if (string == null) {
            string2 = "";
        }
        if ((string3 = string.substring(0, 2)).equals(FLAG_PROTECTED)) {
            string2 = FLAG_PROTECTED;
        }
        if (string3.equals(FLAG_NORMAL)) {
            string2 = FLAG_NORMAL;
        }
        if (string3.equals(FLAG_UPLOAD)) {
            string2 = FLAG_UPLOAD;
        }
        if (string3.equals(FLAG_SYSTEMTEMP)) {
            string2 = FLAG_SYSTEMTEMP;
        }
        if (string3.equals(FLAG_USERTEMP)) {
            string2 = FLAG_USERTEMP;
        }
        if (string3.equals(FLAG_TEMPLATE)) {
            string2 = FLAG_TEMPLATE;
        }
        if (string3.equals(FLAG_LOCALPUB)) {
            string2 = FLAG_LOCALPUB;
        }
        if (string3.equals(FLAG_WEBFILE)) {
            string2 = FLAG_WEBFILE;
        }
        return string2;
    }

    public String moveWCMFile(String string, String string2, boolean bl) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label21", "\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01"));
        }
        String string3 = this.mapFilePath(string, 0);
        try {
            String string4 = this.moveFile(string3 + string, string2, bl);
            return string4;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label19", "\u79fb\u52a8\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.moveFile\uff09"), exception);
        }
    }

    public String copyWCMFile(String string, String string2) throws WCMException {
        try {
            String string3 = this.mapFilePath(string, 0) + string;
            return this.copyFile(string3, string2, false);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label22", "\u590d\u5236WCM\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25"), exception);
        }
    }

    private static void loadFilesMan() {
        try {
            m_filesMan.loadPathConfigs(true);
            s_logger.info((Object)I18NMessage.get(FilesMan.class, "FilesMan.label23", "\u88c5\u8f7d\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210\uff01"));
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(FilesMan.class, "FilesMan.label24", "\u88c5\u8f7d\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u5931\u8d25"), (Throwable)exception);
        }
    }

    public static boolean isValidFile(String string, String string2) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            boolean bl;
            String string3 = string.substring(n + 1);
            if (string.trim().toUpperCase().indexOf("HTTP") == 0) {
                try {
                    if (!CMyFile.fileExists(FilesMan.getFilesMan().mapFilePath(string3, 0) + string3)) {
                        s_logger.error((Object)(I18NMessage.get(FilesMan.class, "FilesMan.label25", "\u6587\u4ef6[") + string3 + I18NMessage.get(FilesMan.class, "FilesMan.label26", "]\u4e0d\u5b58\u5728\uff01\u81ea\u52a8\u4ece[") + string + I18NMessage.get(FilesMan.class, "FilesMan.label27", "]\u4e0b\u8f7d\uff01")));
                        return false;
                    }
                }
                catch (WCMException wCMException) {
                    return false;
                }
                catch (Exception exception) {
                    s_logger.warn((Object)(I18NMessage.get(FilesMan.class, "FilesMan.label29", "\u6821\u9a8c\u6587\u4ef6[") + string3 + I18NMessage.get(FilesMan.class, "FilesMan.label30", "]\u683c\u5f0f\u65f6\u51fa\u73b0\u672a\u6355\u83b7\u7684\u5f02\u5e38\uff1a") + exception.getMessage()));
                    return false;
                }
            }
            if (!(bl = FilesMan.isValidFile(string3, string2))) {
                return false;
            }
            try {
                String string4 = FilesMan.getFilesMan().mapFilePath(string3, 1);
                return string.indexOf(string4) >= 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string == null || string.length() < 22) {
            return false;
        }
        return string.indexOf(string2) == 0;
    }

    public boolean fileExists(String string) {
        if (string == null) {
            return false;
        }
        try {
            String string2 = this.mapFilePath(string, 0) + string;
            if (CMyFile.fileExists(string2)) {
                return true;
            }
        }
        catch (WCMException wCMException) {
            s_logger.warn((Object)I18NMessage.get(FilesMan.class, "FilesMan.label31", "\u65e0\u6cd5\u6620\u5c04\u6587\u4ef6\u7684\u672c\u5730\u8def\u5f84\uff0c\u53ef\u80fd\u662f\u6b63\u5e38\u903b\u8f91\uff0c\u7a0b\u5e8f\u7ee7\u7eed\u8fd0\u884c\u3002"));
            return false;
        }
        return false;
    }

    public boolean refreshPathConfig(Config config) throws Exception {
        return true;
    }
}

