/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.StringTokenizer;

public class PathConfig
implements Cloneable {
    public static final String DELIM = ";";
    private String sLocalPath = null;
    private String sHttpPath = null;
    private String sFtpPath = null;

    public PathConfig() {
    }

    public PathConfig(PathConfig pathConfig) {
        this.sLocalPath = pathConfig.sLocalPath;
        this.sHttpPath = pathConfig.sHttpPath;
        this.sFtpPath = pathConfig.sFtpPath;
    }

    public PathConfig(String string) throws WCMException {
        this.set(string);
    }

    public String getLocalPath() {
        return this.sLocalPath;
    }

    public void setLocalPath(String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(PathConfig.class, "PathConfig.label1", "\u672c\u5730\u8def\u5f84\u4e3a\u7a7a(PathConfig.setLocalPath)"));
        }
        this.sLocalPath = CMyString.setStrEndWith(string.trim(), File.separatorChar);
    }

    public String getHttpPath() {
        return this.sHttpPath;
    }

    public void setHttpPath(String string) {
        this.sHttpPath = string == null || string.trim().length() == 0 ? "" : CMyString.setStrEndWith(string.trim(), '/');
    }

    public String getFtpPath() {
        return this.sFtpPath;
    }

    public void setFtpPath(String string) {
        this.sFtpPath = string == null || string.trim().length() == 0 ? "" : CMyString.setStrEndWith(string.trim(), '/');
    }

    public void set(String string) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(PathConfig.class, "PathConfig.label2", "\u5c5e\u6027\u503c\u4e3a\u7a7a(PathConfig.set)"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        try {
            block7: for (int i = 0; i < 3; ++i) {
                String string2 = (String)stringTokenizer.nextElement();
                switch (i) {
                    case 0: {
                        this.setLocalPath(string2);
                        continue block7;
                    }
                    case 1: {
                        this.setHttpPath(string2);
                        continue block7;
                    }
                    case 2: {
                        this.setFtpPath(string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(10, I18NMessage.get(PathConfig.class, "PathConfig.label3", "\u5c5e\u6027\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff08PathConfig.set\uff09"));
        }
    }

    public String toString() {
        return (this.sLocalPath == null ? "" : this.sLocalPath) + DELIM + (this.sHttpPath == null ? "" : this.sHttpPath) + DELIM + (this.sFtpPath == null ? "" : this.sFtpPath);
    }

    public void clear() {
        this.sLocalPath = null;
        this.sHttpPath = null;
        this.sFtpPath = null;
    }

    public Object clone() {
        return new PathConfig(this);
    }
}

