/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.config;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.Configs;
import com.trs.infra.support.config.SystemCollocationConfig;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigServer
extends BaseServer
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private HashMap m_hmSysConfigs = null;
    public static final String INI_FILENAME = "TRSWCMApp.ini";
    private Properties m_oINIProperties = null;
    private static final int TYPE_PROXY = 1;
    private static final String WCM_PATH_CONFIG = "WCM_PATH";
    private String[] m_arTypeNames = null;
    private int[] m_arTypeIds = null;

    public int[] getTypeIds() {
        if (this.m_arTypeIds == null) {
            this.loadTypes();
        }
        return this.m_arTypeIds;
    }

    public String[] getTypeNames() {
        if (this.m_arTypeNames == null) {
            this.loadTypes();
        }
        return this.m_arTypeNames;
    }

    public static ConfigServer createInstance() {
        ConfigServer configServer = (ConfigServer)DreamFactory.createObjectById("ConfigServer");
        return configServer;
    }

    public void updateConfigValue(String string, String string2) throws WCMException {
        if (string == null || string.length() == 0 || string2 == null) {
            return;
        }
        Config config = this.getSysConfig(string);
        if (config == null || string2.equals(config.getValue())) {
            return;
        }
        config.setValue(string2);
        config.update();
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || !(baseObj instanceof Config)) {
            return;
        }
        this.putConfigValue((Config)baseObj);
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj == null || !(baseObj instanceof Config)) {
            return;
        }
        this.putConfigValue((Config)baseObj);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || !(baseObj instanceof Config)) {
            return;
        }
        this.removeConfigValue((Config)baseObj);
    }

    public Config getSysConfig(String string) throws WCMException {
        return (Config)this.getSysConfigs().get(string.toUpperCase());
    }

    public String getSysConfigValue(String string, String string2) throws WCMException {
        Config config = this.getSysConfig(string);
        return config == null ? string2 : CMyString.showNull(config.getValue(), string2);
    }

    private synchronized boolean loadSysConfigs() throws WCMException {
        if (this.m_hmSysConfigs != null) {
            return true;
        }
        try {
            Configs configs = new Configs();
            configs.open(new WCMFilter("", "SiteId = 0", ""));
            this.m_hmSysConfigs = new HashMap(configs.size());
            for (int i = 0; i < configs.size(); ++i) {
                Config config = (Config)configs.getAt(i);
                if (config == null) continue;
                this.putConfigValue(config);
            }
            configs.clear();
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ConfigServer.class, "ConfigServer.label1", "\u88c5\u8f7d\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5931\u8d25"), exception);
        }
    }

    public synchronized void clear() {
        if (this.m_hmSysConfigs == null) {
            return;
        }
        this.m_hmSysConfigs.clear();
        this.m_hmSysConfigs = null;
        this.m_oINIProperties.clear();
        this.m_oINIProperties = null;
    }

    public static ConfigServer getServer() {
        return (ConfigServer)DreamFactory.createObjectById("ConfigServer");
    }

    public String getInitProperty(String string) {
        try {
            return (String)this.getProperties().get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Properties getProperties() throws WCMException {
        if (this.m_oINIProperties == null) {
            this.loadIniProperties();
        }
        return this.m_oINIProperties;
    }

    private void loadIniProperties() throws WCMException {
        if (this.m_oINIProperties != null) {
            return;
        }
        this.m_oINIProperties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(CMyFile.mapResouceFullPath(INI_FILENAME));
            this.m_oINIProperties.load(fileInputStream);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ConfigServer.class, "ConfigServer.label2", "\u88c5\u8f7d\u7cfb\u7edf\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff08Application.readIniProperties\uff09"), exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            String string;
            String string2;
            String string3 = (String)this.m_oINIProperties.get(WCM_PATH_CONFIG);
            if (File.separatorChar == '/') {
                string2 = "\\\\";
                string = "/";
            } else {
                string2 = "/";
                string = "\\\\";
            }
            string3 = string3.replaceAll(string2, string);
            this.m_oINIProperties.setProperty(WCM_PATH_CONFIG, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInitProperties(String string, String string2) throws WCMException {
        if (File.separatorChar == '\\') {
            string2 = string2.replaceAll("\\\\", "\\\\\\\\");
        }
        try {
            String string3 = CMyFile.mapResouceFullPath(INI_FILENAME);
            String string4 = CMyFile.readFile(string3, "GBK");
            String string5 = string + "=" + string2;
            string4 = string4.matches("(?m)^" + string + "=") ? string4.replaceFirst("(?m)^" + string + "=[^\n]+$", string5 + "\n") : string4 + "\n" + string5;
            CMyFile.writeFile(string3, string4, "GBK");
            this.m_oINIProperties.put(string, string2);
        }
        catch (Exception exception) {
            throw new WCMException("\u4fee\u6539\u6587\u4ef6\u914d\u7f6e\u51fa\u73b0\u9519\u8bef", exception);
        }
    }

    public void setInitProperties(Map map) throws WCMException {
        try {
            String string = CMyFile.mapResouceFullPath(INI_FILENAME);
            String string2 = CMyFile.readFile(string, "GBK");
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (File.separatorChar == '\\') {
                    string4 = string4.replaceAll("\\\\", "\\\\");
                }
                String string5 = string3 + "=" + string4;
                string2 = string2.matches("(?m)^" + string3 + "=") ? string2.replaceFirst("(?m)^" + string3 + "=[^\n]+$", string5 + "\n") : string2 + "\n" + string5;
                CMyFile.writeFile(string, string2, "GBK");
                this.m_oINIProperties.put(string3, string4);
            }
        }
        catch (Exception exception) {
            throw new WCMException("\u4fee\u6539\u6587\u4ef6\u914d\u7f6e\u51fa\u73b0\u9519\u8bef", exception);
        }
    }

    protected void doShutdown() {
        this.clear();
    }

    protected boolean doStart() throws WCMException {
        this.loadIniProperties();
        this.loadSysConfigs();
        return true;
    }

    protected void putConfigValue(Config config) throws WCMException {
        if (config.getType() == 1) {
            CMy3WLib.setProxyInfo(config.getConfigKey(), config.getValue());
        }
        this.getSysConfigs().put(config.getConfigKey().toUpperCase(), config);
    }

    protected void removeConfigValue(Config config) throws WCMException {
        this.getSysConfigs().remove(config.getConfigKey().toUpperCase());
    }

    protected HashMap getSysConfigs() throws WCMException {
        return this.getSysConfigs(true);
    }

    protected HashMap getSysConfigs(boolean bl) throws WCMException {
        if (!bl) {
            return this.m_hmSysConfigs;
        }
        if (this.m_hmSysConfigs == null) {
            this.loadSysConfigs();
        }
        return this.m_hmSysConfigs;
    }

    public String getTypeName(int n) {
        if (this.m_arTypeIds == null) {
            this.loadTypes();
        }
        if (this.m_arTypeIds == null) {
            return "";
        }
        for (int i = 0; i < this.m_arTypeIds.length; ++i) {
            if (n != this.m_arTypeIds[i]) continue;
            return this.m_arTypeNames[i];
        }
        return "";
    }

    private void loadTypes() {
        if (this.m_arTypeIds != null) {
            return;
        }
        List list = XMLConfigServer.getInstance().getConfigObjects(SystemCollocationConfig.class);
        if (list.size() == 0) {
            return;
        }
        this.m_arTypeIds = new int[list.size()];
        this.m_arTypeNames = new String[list.size()];
        for (int i = 0; i < this.m_arTypeIds.length; ++i) {
            SystemCollocationConfig systemCollocationConfig = (SystemCollocationConfig)list.get(i);
            this.m_arTypeIds[i] = systemCollocationConfig.getTypeId();
            this.m_arTypeNames[i] = systemCollocationConfig.getName();
        }
    }

    public boolean isShowDetailErrorInfo() {
        try {
            return "true".equals(this.getSysConfigValue("SHOW_ERROR_DETAILINFO", "false"));
        }
        catch (WCMException wCMException) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ConfigServer.getServer().getInitProperty(WCM_PATH_CONFIG));
            System.out.println("Type 10:" + ConfigServer.getServer().getTypeName(10));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

