/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.update;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class DBUpdateLog
extends BaseObj {
    public static final int TYPE_UPDATE = 1;
    public static final int TYPE_ADD = 2;
    public static final int DB_TYPE_SQL = 2;
    public static final int DB_TYPE_ORACLE = 1;
    public static final int DB_TYPE_DB2 = 3;
    public static final int DB_TYPE_SYBASE = 4;
    public static final int DB_TYPE_MYSQL = 7;
    public static final String[] DB_AUTO_COMMIT = new String[100];
    public static final int OBJ_TYPE = 3001;
    public static final String DB_TABLE_NAME = "WCMDBUPDATELOG";
    public static final String DB_ID_NAME = "DBUPDATELOGID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 3001;
    }

    public String getTitle() {
        return this.getPropertyAsString("LOGTITLE");
    }

    public boolean setTitile(String string) throws WCMException {
        return this.setProperty("LOGTITLE", string);
    }

    public String getMemo() {
        return this.getPropertyAsString("LOGMEMO");
    }

    public boolean setMemo(String string) throws WCMException {
        return this.setProperty("LOGMEMO", string);
    }

    public String getSubmitor() {
        return this.getPropertyAsString("SUBMITOR");
    }

    public boolean setSubmitor(String string) throws WCMException {
        return this.setProperty("SUBMITOR", string);
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String string) throws WCMException {
        return this.setProperty("TABLENAME", string);
    }

    public int getType() {
        return this.getPropertyAsInt("LOGTYPE", 0);
    }

    public String getTypeDesc() {
        switch (this.getType()) {
            case 2: {
                return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label1", "\u65b0\u589e");
            }
            case 1: {
                return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label2", "\u4fee\u6539");
            }
        }
        return I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label3", "\u672a\u77e5");
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("LOGTYPE", n);
    }

    public String getSQL(int n) throws WCMException {
        String string = null;
        switch (n) {
            case 2: {
                string = "print '" + CMyString.filterForSQL(this.toString()) + "'\n GO \n";
                string = string + this.getSQLServerSQL();
                break;
            }
            case 1: {
                string = this.getOracleSQL();
                if (string != null && string.indexOf(";") < 0) {
                    string = string + ";";
                }
                string = CMyString.showNull(string, "");
                string = "exec dbms_output.put_line('" + CMyString.filterForSQL(this.toString()) + "');\n" + string;
                break;
            }
            case 3: {
                string = this.getDB2SQL();
                break;
            }
            case 4: {
                string = this.getSysbaseSQL();
                break;
            }
            case 7: {
                string = this.getMysqlSQL();
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label4", "\u4e0d\u652f\u6301\u4f20\u5165\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01"));
            }
        }
        return string;
    }

    public String getSQLServerSQL() {
        CDBText cDBText = (CDBText)this.getProperty("SQLSERVER");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    public boolean setSQLServerSQL(String string) throws WCMException {
        return this.setProperty("SQLSERVER", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public String getOracleSQL() {
        CDBText cDBText = (CDBText)this.getProperty("ORACLESQL");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    public boolean setOracleSQL(String string) throws WCMException {
        return this.setProperty("ORACLESQL", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public String getDB2SQL() {
        CDBText cDBText = (CDBText)this.getProperty("DB2SQL");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    public boolean setDB2SQL(String string) throws WCMException {
        return this.setProperty("DB2SQL", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public String getSysbaseSQL() {
        CDBText cDBText = (CDBText)this.getProperty("SYSBASESQL");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    public boolean setSysbaseSQL(String string) throws WCMException {
        return this.setProperty("SYSBASESQL", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public String getMysqlSQL() {
        CDBText cDBText = (CDBText)this.getProperty("MYSQLSQL");
        if (cDBText == null) {
            return null;
        }
        return cDBText.getText();
    }

    public boolean setMysqlSQL(String string) throws WCMException {
        return this.setProperty("MYSQLSQL", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("LOGTITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label5", "\u5c5e\u6027Titile\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("SUBMITOR") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label6", "\u5c5e\u6027Submitor\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("TABLENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label7", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("LOGTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label8", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
            if (this.getProperty("SQLSERVER") == null) {
                throw new WCMException(1106, I18NMessage.get(DBUpdateLog.class, "DBUpdateLog.label9", "\u5c5e\u6027SQLServerSQL\u6ca1\u6709\u8bbe\u7f6e(DBUpdateLog.isValid)"));
            }
        }
        return true;
    }

    public static final DBUpdateLog findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (DBUpdateLog)BaseObj.findById(DBUpdateLog.class, n);
    }

    public static final DBUpdateLog createNewInstance() throws WCMException {
        return (DBUpdateLog)BaseObj.createNewInstance(DBUpdateLog.class);
    }

    public static final DBUpdateLog findByKey(Object object) throws WCMException {
        return (DBUpdateLog)BaseObj.findByKey(DBUpdateLog.class, object);
    }

    public String toString() {
        return "DBUpdate-" + this.getId() + " " + this.getTitle();
    }

    static {
        DBUpdateLog.DB_AUTO_COMMIT[1] = "GO";
        DBUpdateLog.DB_AUTO_COMMIT[0] = "COMMIT;";
        DBUpdateLog.DB_AUTO_COMMIT[2] = "COMMIT;";
        DBUpdateLog.DB_AUTO_COMMIT[3] = "GO";
    }
}

