/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.database.util.Row;
import com.trs.database.util.Utils;
import java.util.LinkedList;
import java.util.List;

class Plan {
    static List rows = new LinkedList();
    int maxOptLen = 0;
    int maxObjLen = 0;
    int maxCostLen = 0;
    int maxOptimizer = 0;

    Plan() {
    }

    void addRow(Row row) {
        rows.add(row);
        this.maxOptLen = Utils.max(this.maxOptLen, row.optlen);
        this.maxObjLen = Utils.max(this.maxObjLen, row.objlen);
        this.maxCostLen = Utils.max(this.maxCostLen, row.costlen);
    }

    void reset() {
        rows.clear();
        this.maxOptLen = 0;
        this.maxObjLen = 0;
        this.maxCostLen = 0;
        this.maxOptimizer = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        Row row = null;
        int n = rows.size();
        for (int i = 0; i < n; ++i) {
            row = (Row)rows.get(i);
            stringBuffer.append(row.option);
            stringBuffer.append(Utils.rpad(this.maxOptLen - row.optlen));
            stringBuffer.append('\t');
            stringBuffer.append(row.objname);
            stringBuffer.append(Utils.rpad(this.maxObjLen - row.objlen));
            stringBuffer.append('\t');
            stringBuffer.append(row.cost);
            stringBuffer.append(Utils.rpad(this.maxCostLen - row.costlen));
            stringBuffer.append('\t');
            stringBuffer.append(row.optimizer);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

