/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.wcmx.media;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.Events;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfo;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class MediaRemindedAgent {
    private Hashtable m_hMediaUsers;
    private Hashtable m_hMediaFreq;
    private Hashtable m_hCurrMediaNewsCount;
    private boolean IS_DEBUG = true;
    private static MediaRemindedAgent m_aSingleInstance = null;

    public MediaRemindedAgent() {
        try {
            this.init();
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label1", "\u521d\u59cb\u5316\u5931\u8d25\uff01"));
            exception.printStackTrace();
        }
    }

    public static synchronized MediaRemindedAgent getInstance() {
        if (m_aSingleInstance == null) {
            m_aSingleInstance = new MediaRemindedAgent();
        }
        return m_aSingleInstance;
    }

    public Sources getSourcesRemided(User user) throws Exception {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label2", "\u6307\u5b9a\u7684\u7528\u6237\u6709\u8bef\uff01(MediaRemindedAgent.getSourcesRemided)"));
        }
        String string = "XWCMMEDIAREMINDEDINFO.UserId=" + user.getId();
        WCMFilter wCMFilter = new WCMFilter("XWCMMEDIAREMINDEDINFO", string, "", "SOURCEID");
        try {
            Sources sources = new Sources(user);
            sources.open(wCMFilter);
            return sources;
        }
        catch (Exception exception) {
            System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label3", ":\u67e5\u8be2\u7528\u6237[") + user.getName() + "][" + user.getId() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label4", "]\u5b9a\u5236\u7684\u5a92\u4f53\u63d0\u9192\u5931\u8d25\uff01"));
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label5", "\u67e5\u8be2\u7684\u8bed\u53e5\u4e3a[") + wCMFilter.toSQL() + "]");
            exception.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label6", "\u67e5\u8be2\u7528\u6237[") + user.getName() + "][" + user.getId() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label4", "]\u5b9a\u5236\u7684\u5a92\u4f53\u63d0\u9192\u5931\u8d25\uff01"), exception);
        }
    }

    public int getFreqReminded(int n) throws Exception {
        if (this.m_hMediaFreq == null) {
            return -2;
        }
        Integer n2 = (Integer)this.m_hMediaFreq.get(new Integer(n));
        return n2 == null ? -1 : n2;
    }

    public void setFreqReminded(int n, int n2) {
        if (this.m_hMediaFreq == null) {
            return;
        }
        this.m_hMediaFreq.put(new Integer(n), new Integer(n2));
    }

    public synchronized void init() throws Exception {
        try {
            System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label7", ":\u5f00\u59cb\u521d\u59cb\u5316\u5a92\u4f53\u63d0\u9192\u7684\u7f13\u51b2\u533a\uff01"));
            if (this.m_hMediaFreq != null) {
                this.m_hMediaFreq.clear();
            } else {
                this.m_hMediaFreq = new Hashtable();
            }
            if (this.m_hMediaUsers != null) {
                this.m_hMediaUsers.clear();
            } else {
                this.m_hMediaUsers = new Hashtable();
            }
            if (this.m_hCurrMediaNewsCount != null) {
                this.m_hCurrMediaNewsCount.clear();
            } else {
                this.m_hCurrMediaNewsCount = new Hashtable();
            }
            MediaRemindedInfos mediaRemindedInfos = new MediaRemindedInfos(User.getSystem());
            mediaRemindedInfos.open(null);
            for (int i = 0; i < mediaRemindedInfos.size(); ++i) {
                this.putMediaRemindedInfoInCache((MediaRemindedInfo)mediaRemindedInfos.getAt(i));
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label8", "\u521d\u59cb\u5316\u5a92\u4f53\u9891\u7387\u5931\u8d25\uff01(MediaRemindedAgent.init)"), exception);
        }
        System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label9", ":\u521d\u59cb\u5316\u5a92\u4f53\u63d0\u9192\u7684\u7f13\u51b2\u533a\u5b8c\u6210\uff01"));
    }

    public void putMediaRemindedInfoInCache(MediaRemindedInfo mediaRemindedInfo) {
        Integer n = new Integer(mediaRemindedInfo.getUserID());
        this.setFreqReminded(mediaRemindedInfo.getUserID(), mediaRemindedInfo.getFreqReminded());
        Integer n2 = new Integer(mediaRemindedInfo.getSourceId());
        Vector<Integer> vector = (Vector<Integer>)this.m_hMediaUsers.get(n2);
        if (vector == null) {
            vector = new Vector<Integer>();
            vector.add(n);
            this.m_hMediaUsers.put(n2, vector);
        } else if (vector.indexOf(n) < 0) {
            vector.add(n);
        }
        this.setCurrMediaCount(mediaRemindedInfo.getSourceId(), mediaRemindedInfo.getUserID(), 0);
    }

    public Users getUsersByMediaReminded(int n) throws Exception {
        Users users = new Users(User.getSystem());
        Vector vector = (Vector)this.m_hMediaUsers.get(new Integer(n));
        if (vector == null) {
            return users;
        }
        for (int i = 0; i < vector.size(); ++i) {
            User user = User.findById((Integer)vector.get(i));
            if (user == null) continue;
            users.addElement(user);
        }
        return users;
    }

    public int getCurrMediaCount(int n, int n2) throws Exception {
        String string = n2 + "_" + n;
        Integer n3 = (Integer)this.m_hCurrMediaNewsCount.get(string);
        if (n3 == null) {
            return -1;
        }
        return n3;
    }

    public void setCurrMediaCount(int n, int n2, int n3) {
        String string = n2 + "_" + n;
        this.m_hCurrMediaNewsCount.put(string, new Integer(n3));
    }

    public void removeMediaRemindedInfoFromCache(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Vector vector = (Vector)this.m_hMediaUsers.get(n4);
        if (vector != null) {
            vector.remove(n3);
        }
        String string = n + "_" + n2;
        this.m_hCurrMediaNewsCount.remove(string);
    }

    public void updateMediaRemindedCache(MediaRemindedInfo mediaRemindedInfo) {
        this.setFreqReminded(mediaRemindedInfo.getUserID(), mediaRemindedInfo.getFreqReminded());
    }

    public void addMediaReminded(int n) throws Exception {
        Vector vector = (Vector)this.m_hMediaUsers.get(new Integer(n));
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            int n3 = this.getFreqReminded(n2);
            if (n3 < 0) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label10", "\u7528\u6237[") + n2 + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label11", "]\u6ca1\u6709\u8bbe\u5b9a\u6307\u5b9a\u5a92\u4f53[") + n + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label12", "]\u7684\u63d0\u9192\u9891\u7387\uff01"));
                continue;
            }
            int n4 = this.getCurrMediaCount(n, n2);
            if (n4 < 0) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label10", "\u7528\u6237[") + n2 + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label13", "]\u6ca1\u6709\u5728\u6307\u5b9a\u5a92\u4f53[") + n + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label14", "]\u6ca1\u6709\u79ef\u7d2f\u7684\u6761\u6570\uff01"));
                continue;
            }
            if (n4 >= n3 - 1) {
                this.sendRemindMessage(n, n2);
                this.setCurrMediaCount(n, n2, 0);
                continue;
            }
            this.setCurrMediaCount(n, n2, n4 + 1);
        }
    }

    public void sendRemindMessage(int n, int n2) throws Exception {
        Source source = Source.findById(n);
        if (source == null) {
            return;
        }
        User user = User.findById(n2);
        if (user == null) {
            return;
        }
        String string = I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label15", "\u5a92\u4f53\u3010") + source.getName() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label16", "\u3011\u6709\u3010") + this.getFreqReminded(n2) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label17", "\u3011\u7bc7\u6587\u6863\u9700\u8981\u5904\u7406\uff01");
        if (this.IS_DEBUG) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label18", "\u7ed9\u7528\u6237\u3010") + user.getName() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label19", "\u3011\u53d1\u9001\u6d88\u606f\uff01"));
        }
        if (this.IS_DEBUG) {
            System.out.println(string);
        }
        Events events = new Events(User.getSystem());
        Event event = (Event)events.addNew();
        CMyDateTime cMyDateTime = CMyDateTime.now();
        cMyDateTime.dateAdd(4, 8);
        event.setTitle(string);
        event.setDesc(string);
        event.setStartTime(CMyDateTime.now());
        event.setEndTime(cMyDateTime);
        event.setAheadRemindTime(0);
        event.setRemindBy(0, true);
        event.setCrUser(User.getSystem());
        event.setOwner(user);
        event.setType(9);
        event.setShare(false);
        events.update();
    }

    public static void main(String[] stringArray) {
        try {
            User user;
            int n;
            CMSObj cMSObj;
            int n2;
            User user2 = User.findByName("admin");
            MediaRemindedAgent mediaRemindedAgent = MediaRemindedAgent.getInstance();
            Users users = mediaRemindedAgent.getUsersByMediaReminded(1);
            System.out.println(users.size());
            for (n2 = 0; n2 < users.size(); ++n2) {
                cMSObj = (User)users.getAt(n2);
                if (cMSObj == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + ((User)cMSObj).getName());
            }
            for (n2 = 0; n2 < 20; ++n2) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label21", "\u6dfb\u52a0\u4e86\u7b2c[") + (n2 + 1) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label22", "]\u7bc7\u6587\u6863\uff01"));
                mediaRemindedAgent.addMediaReminded(1);
            }
            Sources sources = mediaRemindedAgent.getSourcesRemided(user2);
            System.out.println(sources.size());
            cMSObj = MediaRemindedInfo.findByUserAndSrc(user2, user2.getId(), 1);
            cMSObj.canEdit(user2);
            ((MediaRemindedInfo)cMSObj).setFreqReminded(5);
            ((MediaRemindedInfo)cMSObj).update(user2);
            System.out.println(mediaRemindedAgent.getFreqReminded(user2.getId()));
            users = mediaRemindedAgent.getUsersByMediaReminded(1);
            System.out.println(users.size());
            for (n = 0; n < users.size(); ++n) {
                user = (User)users.getAt(n);
                if (user == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + user.getName());
            }
            users = mediaRemindedAgent.getUsersByMediaReminded(2);
            System.out.println(users.size());
            for (n = 0; n < users.size(); ++n) {
                user = (User)users.getAt(n);
                if (user == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + user.getName());
            }
            for (n = 0; n < 20; ++n) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label21", "\u6dfb\u52a0\u4e86\u7b2c[") + (n + 1) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label22", "]\u7bc7\u6587\u6863\uff01"));
                int n3 = 1;
                mediaRemindedAgent.addMediaReminded(n3);
            }
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label23", "\u6d4b\u8bd5\u4ee3\u7801\u53d1\u751f\u5f02\u5e38\uff01"));
            exception.printStackTrace();
        }
    }
}

