/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser.formater;

import com.trs.components.common.publish.domain.tagparser.ITagFormatter;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;

public abstract class WCMTagFormatterDocumentsBase
implements ITagFormatter {
    protected static final String[] IMPART_ATTRIBUTE_NAMES = new String[]{"TARGET", "LINKTEXT", "EXTRA"};
    protected static final String[] REMOVE_ATTRIBUTE_NAMES = new String[]{"TARGET", "LINKTEXT", "EXTRA", "TYPE", "TRS_OUTLINE_DESC", "ICON", "ICO", "ALINK", "AUTOLINK"};

    public void standardize(TagItem tagItem) throws WCMException {
        if (!tagItem.getBooleanAttribute("AUTOLINK", true)) {
            this.removeAutoLink(tagItem);
        } else {
            this.impartLinkAttributes(tagItem);
        }
        for (int i = 0; i < REMOVE_ATTRIBUTE_NAMES.length; ++i) {
            tagItem.removeAttribute(REMOVE_ATTRIBUTE_NAMES[i]);
        }
        String string = tagItem.getAttribute("PARENT");
        if (tagItem.getAttribute("ID") == null && string != null) {
            tagItem.setAttribute("ID", string);
            tagItem.removeAttribute("PARENT");
        }
        this.standardizeSelf(tagItem);
    }

    protected abstract void standardizeSelf(TagItem var1) throws WCMException;

    private void removeAutoLink(TagItem tagItem) throws WCMException {
        List list = tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = tagItem.containsChild("TRS_RECORD");
        if (bl) {
            for (int i = 0; i < list.size(); ++i) {
                TagItem tagItem2;
                Object e = list.get(i);
                if (!(e instanceof TagItem) || !(tagItem2 = (TagItem)e).getName().equalsIgnoreCase("TRS_RECORD")) continue;
                this.removeAutoLink(tagItem2.getChildren());
            }
        } else {
            this.removeAutoLink(list);
        }
    }

    private void removeAutoLink(List list) throws WCMException {
        List list2 = list;
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (!(e instanceof TagItem)) continue;
            TagItem tagItem = (TagItem)e;
            String string = tagItem.getAttribute("FIELD");
            if (string == null || (string = string.trim()).length() <= 0) {
                string = tagItem.getAttribute("ID");
            }
            if (!"DOCTITLE".equalsIgnoreCase(string) || tagItem.getAttribute("AUTOLINK") != null) continue;
            tagItem.setAttribute("AUTOLINK", false);
        }
    }

    private void impartLinkAttributes(TagItem tagItem) throws WCMException {
        List list = tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = tagItem.containsChild("TRS_RECORD");
        if (bl) {
            for (int i = 0; i < list.size(); ++i) {
                TagItem tagItem2;
                Object e = list.get(i);
                if (!(e instanceof TagItem) || !(tagItem2 = (TagItem)e).getName().equalsIgnoreCase("TRS_RECORD")) continue;
                this.impartLinkAttributes(tagItem, tagItem2.getChildren());
            }
        } else {
            this.impartLinkAttributes(tagItem, list);
        }
    }

    private void impartLinkAttributes(TagItem tagItem, List list) throws WCMException {
        List list2 = list;
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        boolean bl = false;
        String string = tagItem.getAttribute("ALINK");
        if (string == null || (string = string.trim().toUpperCase()).length() == 0 || string.equals("DOCTITLE")) {
            string = "DOCTITLE";
            bl = true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            TagItem tagItem2;
            Object e = list2.get(i);
            if (!(e instanceof TagItem) || !(tagItem2 = (TagItem)e).getBooleanAttribute("AUTOLINK", true) || !tagItem2.getName().equalsIgnoreCase("TRS_COLUMN") && !tagItem2.getName().equalsIgnoreCase("TRS_DOCUMENT")) continue;
            String string2 = tagItem2.getAttribute("ID");
            if (string2 == null || string2.length() <= 0) {
                string2 = tagItem2.getAttribute("FIELD");
            }
            if (string2 == null || string2.length() <= 0) {
                string2 = "DOCID";
            }
            if (bl) {
                if (!string2.equalsIgnoreCase("DOCTITLE")) {
                    continue;
                }
            } else {
                if (string2.equalsIgnoreCase("DOCTITLE")) {
                    if (tagItem2.getBooleanAttribute("AUTOLINK", false)) continue;
                    tagItem2.setAttribute("AUTOLINK", false);
                    continue;
                }
                if (!string.equalsIgnoreCase(string2)) continue;
            }
            if (tagItem.getBooleanAttribute("AUTOLINK", true)) {
                tagItem2.setAttribute("AUTOLINK", true);
            }
            for (int j = 0; j < IMPART_ATTRIBUTE_NAMES.length; ++j) {
                String string3 = IMPART_ATTRIBUTE_NAMES[j];
                String string4 = tagItem2.getAttribute(string3);
                if (!CMyString.isEmpty(string4) || CMyString.isEmpty(string4 = tagItem.getAttribute(string3))) continue;
                tagItem2.setAttribute(IMPART_ATTRIBUTE_NAMES[j], string4);
            }
        }
    }
}

