/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.WCMDocumentImagesGenerator;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class XWCMContImgsTagParser
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(XWCMContImgsTagParser.class);
    protected static TagBeanInfo m_sTagBeanInfo = null;
    private List m_ContentImages;
    private Document m_oDocument;
    private int m_nCurrPos = 0;
    private PublishTagContext m_nextRecordContext = null;
    private Map hmImages = new HashMap();

    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_CONTIMGS");
            tagBeanInfo.setDesc("TRS_CONTIMGS");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("OWNER");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINWIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINHEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ONLYFROM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"content", "appendix"});
            tagBeanAttrInfo.setDefaultValue("content");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIRSTFROM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"content", "appendix"});
            tagBeanAttrInfo.setDefaultValue("");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            m_sTagBeanInfo = tagBeanInfo;
        }
        return m_sTagBeanInfo;
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public int getRecordSize() {
        return this.m_ContentImages == null ? 0 : this.m_ContentImages.size();
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            DefaultObj defaultObj = (DefaultObj)this.m_ContentImages.get(this.m_nCurrPos++);
            PublishContentDocumentImpl publishContentDocumentImpl = new PublishContentDocumentImpl(this.m_oDocument);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishContentDocumentImpl);
            this.hmImages.put("IMAGE", defaultObj);
            this.m_nextRecordContext.setExtraAttributes(this.hmImages);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        if (!publishTagContext.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(publishTagContext)) {
            return null;
        }
        CMSBaseObjs cMSBaseObjs = this.findObjects(publishTagContext);
        this.m_ContentImages = new ArrayList(cMSBaseObjs.size());
        int n = cMSBaseObjs.size();
        for (int i = 0; i < n; ++i) {
            DefaultObj defaultObj = (DefaultObj)cMSBaseObjs.getAt(i);
            if (defaultObj == null) continue;
            this.m_ContentImages.add(defaultObj);
        }
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, publishTagContext.getTagItem(), this);
        String[] stringArray = TagParseHelper.parse4List(publishTagContext.getTagItem(), publishTagContext, this);
        return stringArray;
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("ID");
        int n = publishTagContext.getAttribute("NUM", 20);
        this.m_oDocument = CMyString.isEmpty(string) || "OWNER".equalsIgnoreCase(string) ? WCMTagParserHelper.findDocumentHost(publishTagContext) : Document.findById(Integer.parseInt(string));
        if (this.m_oDocument == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u7684\u6587\u6863\uff01");
        }
        DefaultObjs defaultObjs = WCMDocumentImagesGenerator.getDocumentImages(publishTagContext, this.m_oDocument, n);
        return defaultObjs;
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("ID");
        return CMyString.isEmpty(string) || string.indexOf(",") <= -1;
    }
}

