/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;

public abstract class WCMTagParserLogoBase
extends BaseTagParser {
    public abstract IPublishElement findHost(PublishTagContext var1) throws WCMException;

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string;
        IPublishElement iPublishElement = this.findHost(publishTagContext);
        if (iPublishElement == null) {
            return null;
        }
        int n = publishTagContext.getAttribute("INDEX", 1);
        boolean bl = "TRUE".equalsIgnoreCase(publishTagContext.getAttribute("NAMEONLY"));
        boolean bl2 = "TRUE".equalsIgnoreCase(publishTagContext.getAttribute("SHOWPIC"));
        boolean bl3 = "TRUE".equalsIgnoreCase(publishTagContext.getAttribute("URLISABS"));
        String string2 = publishTagContext.getAttribute("SHOWMODE");
        Logo logo = Logo.findOf(iPublishElement.getType(), iPublishElement.getId(), n - 1);
        if (logo == null) {
            return null;
        }
        this.distributeLogoFile(publishTagContext, iPublishElement, logo);
        if (bl) {
            return new String[]{logo.getFileName()};
        }
        IPublishFolder iPublishFolder = null;
        iPublishFolder = !iPublishElement.isFolder() ? ((IPublishContent)iPublishElement).getOriginalHome() : (IPublishFolder)iPublishElement;
        if (iPublishFolder == null) {
            return null;
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl4 = publishTagContext.isPreview();
        String string3 = null;
        string3 = !bl4 ? publishPathCompass.getAbsoluteHttpPath(iPublishFolder) + "images" + "/" : publishPathCompass.getPreviewHttpPath(iPublishFolder) + "images" + "/";
        String string4 = HtmlUtil.calRelativePath(publishPathCompass.getAbsoluteHttpPath(iPublishFolder) + "images" + "/", publishTagContext.getPageHttpPath()) + logo.getFileName();
        String string5 = string = bl3 ? string3 + logo.getFileName() : string4;
        if (bl2) {
            return new String[]{"<img src='" + string + "'/>"};
        }
        if (string2 != null) {
            if (string2.equalsIgnoreCase("FILENAME")) {
                return new String[]{logo.getFileName()};
            }
            if (string2.equalsIgnoreCase("SHOWPIC")) {
                return new String[]{"<img src='" + string + "'/>"};
            }
        }
        return new String[]{string};
    }

    private void distributeLogoFile(PublishTagContext publishTagContext, IPublishElement iPublishElement, Logo logo) throws WCMException {
        IPublishFolder iPublishFolder = null;
        iPublishFolder = !iPublishElement.isFolder() ? ((IPublishContent)iPublishElement).getOriginalHome() : (IPublishFolder)iPublishElement;
        if (iPublishFolder == null) {
            return;
        }
        String string = logo.getFileName();
        String string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        if (!CMyFile.fileExists(string2)) {
            publishTagContext.addWarning(iPublishElement.getInfo() + "-Logo", iPublishElement.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label1", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + string + "]");
            return;
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string3 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishFolder, bl), File.separatorChar) + "images" + File.separatorChar;
        if (!logo.isUpdated() && CMyFile.fileExists(string3 + string)) {
            return;
        }
        PublishSyncGlobalTuner.insureLocalPathExists(string3);
        try {
            CMyFile.copyFile(string2, string3 + string);
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
            publishTagContext.addWarning(iPublishElement.getInfo() + "-Logo", iPublishElement.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label3", "\u62f7\u8d1d(") + iPublishElement.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + string + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label4", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(cMyException));
        }
        if (!bl) {
            publishTagContext.getFileDistributeShip().distributeFile(string2, iPublishFolder, "images", false);
            if (logo.isUpdated()) {
                logo.setUpdated(false);
                logo.update();
            }
        }
    }
}

