/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserHelper {
    private static Logger s_logger = Logger.getLogger(WCMTagParserHelper.class);

    public static int getChildIndex(PublishTagContext publishTagContext) throws WCMException {
        int n = publishTagContext.getAttribute("CHILDINDEX", -1);
        if (n < -2) {
            throw new WCMException(233, "Child index " + n + " is out of the minimum limitation " + -2);
        }
        return n;
    }

    public static int getChildIndex(TagItem tagItem) throws WCMException {
        int n = tagItem.getIntAttribute("CHILDINDEX", -1);
        if (n < -2) {
            throw new WCMException(233, "Child index " + n + " is out of the minimum limitation " + -2);
        }
        return n;
    }

    public static BaseChannel findFolderHost(TagItem tagItem, PublishTagContext publishTagContext, boolean bl) throws WCMException {
        return WCMTagParserHelper.findFolderHost(tagItem, publishTagContext, bl, false);
    }

    public static BaseChannel findFolderHost(TagItem tagItem, PublishTagContext publishTagContext, boolean bl, boolean bl2) throws WCMException {
        BaseChannel baseChannel;
        int n = WCMTagParserHelper.getChildIndex(publishTagContext);
        BaseChannel baseChannel2 = WCMTagParserHelper.findIdAppointedFolder(publishTagContext, bl2);
        if (baseChannel2 == null || baseChannel2.isDeleted()) {
            return null;
        }
        int n2 = publishTagContext.getAttribute("CHANNELTYPE", 0);
        if (n2 == 1 || n2 == 2) {
            return WCMTagParserHelper.findTopNewsOrPicChannel(baseChannel2, n2);
        }
        switch (n) {
            case -2: {
                if (baseChannel2.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                baseChannel = ((Channel)baseChannel2).getParent();
                if (baseChannel != null) break;
                if (((Channel)baseChannel2).getParentId() != 0) {
                    throw new WCMException(235, baseChannel2.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label1", "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!"));
                }
                baseChannel = baseChannel2.getSite();
                break;
            }
            case -1: {
                if (baseChannel2.isSite() && bl) {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label2", "\u7f6e\u6807 ") + tagItem.toString() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label3", "\u7684\u76f8\u5173\u5bf9\u8c61\u4e0d\u662f\u9891\u9053"));
                    return null;
                }
                baseChannel = baseChannel2;
                break;
            }
            default: {
                baseChannel = baseChannel2.getChildAt(n);
                if (baseChannel != null) break;
                s_logger.debug((Object)("Child " + n + " of " + baseChannel2.getInfo() + " is not found!"));
            }
        }
        return baseChannel;
    }

    public static BaseChannel findFolderHostByOldModal(TagItem tagItem, PublishTagContext publishTagContext, boolean bl) throws WCMException {
        BaseChannel baseChannel;
        int n = WCMTagParserHelper.getChildIndex(publishTagContext);
        BaseChannel baseChannel2 = WCMTagParserHelper.findIdAppointedFolder(publishTagContext, false);
        switch (n) {
            case -2: {
                if (baseChannel2.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                baseChannel = ((Channel)baseChannel2).getParent();
                if (baseChannel != null) break;
                if (((Channel)baseChannel2).getParentId() != 0) {
                    throw new WCMException(235, baseChannel2.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label1", "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!"));
                }
                baseChannel = baseChannel2.getSite();
                break;
            }
            case -1: {
                if (baseChannel2.isSite() && bl) {
                    throw new WCMException(235, "Host in tag <" + tagItem.getName() + "> must be channel but not site!");
                }
                baseChannel = baseChannel2;
                break;
            }
            default: {
                baseChannel = baseChannel2.getChildAt(n);
                if (baseChannel != null) break;
                s_logger.error((Object)("Child " + n + " of " + baseChannel2.getInfo() + " is not found!"));
            }
        }
        return baseChannel;
    }

    public static BaseChannel findTopNewsOrPicChannel(BaseChannel baseChannel, int n) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label4", "\u6ca1\u6709\u6307\u5b9a\u7236\u9891\u9053\uff01"));
        }
        BaseChannel baseChannel2 = baseChannel;
        User user = User.getSystem();
        int n2 = baseChannel2.getChildrenSize(user);
        for (int i = 0; i < n2 && i < 2; ++i) {
            Channel channel = baseChannel2.getChildAt(i);
            if (channel == null || channel.getType() != n) continue;
            return channel;
        }
        if (baseChannel2.isSite()) {
            throw new WCMException(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label5", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7c7b\u578b[") + n + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label6", "]\u7684\u9891\u9053\uff01"));
        }
        return WCMTagParserHelper.findTopNewsOrPicChannel(baseChannel2.getHost(), n);
    }

    private static BaseChannel findIdAppointedFolder(PublishTagContext publishTagContext, boolean bl) throws WCMException {
        IPublishFolder iPublishFolder;
        IPublishElement iPublishElement;
        String string = publishTagContext.getAttribute("ID");
        BaseChannel baseChannel = WCMTagParserHelper.makeBaseChannelFromID(string, iPublishElement = publishTagContext.getUpperHost(), iPublishFolder = publishTagContext.getRoot(), bl);
        if (baseChannel != null && !baseChannel.isDeleted()) {
            return baseChannel;
        }
        String string2 = I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label7", "\u6307\u5b9a\u7684\u9891\u9053 [") + string + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label8", "]\u5728") + iPublishFolder.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label9", "\u6ca1\u6709\u627e\u5230!");
        s_logger.warn((Object)string2);
        s_logger.warn((Object)"========Template Info=========");
        s_logger.warn((Object)publishTagContext.getPageContext().getTemplate());
        s_logger.warn((Object)"========TagItem Info=========");
        s_logger.warn((Object)publishTagContext.getTagItem());
        if (PublishServerConfigMapper.isIgnoreIfHostNotFound()) {
            publishTagContext.addWarning(string2);
            return null;
        }
        throw new WCMException(233, string2);
    }

    private static BaseChannel makeBaseChannelFromID(String string, IPublishElement iPublishElement, IPublishFolder iPublishFolder, boolean bl) throws WCMException {
        Object object;
        if (iPublishElement == null) {
            throw new WCMException("Upper Host is Null!");
        }
        int n = 0;
        if (string == null || (string = string.trim()).length() == 0) {
            n = bl ? 2545479 : 75627155;
        } else {
            String string2;
            object = string.toUpperCase();
            if (((String)object).startsWith(string2 = "SITEID:")) {
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string.substring(string2.length()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 > 0) {
                    return WebSite.findById(n2);
                }
                n = bl ? 2545479 : 75627155;
            } else if (((String)object).startsWith("CHANNELID:")) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string.substring("CHANNELID:".length()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 > 0) {
                    return Channel.findById(n3);
                }
                n = bl ? 2545479 : 75627155;
            } else if (string.indexOf(".") >= 0) {
                int n4 = 0;
                String[] stringArray = CMyString.split((String)object, ".");
                int n5 = stringArray.length;
                for (int i = 0; i < n5; ++i) {
                    int n6 = stringArray[i].trim().hashCode();
                    if (n6 != -1942094678) {
                        n4 = 0;
                        break;
                    }
                    ++n4;
                }
                if (n4 > 0) {
                    BaseChannel baseChannel = WCMTagParserHelper.getCurrChannelOrSite(iPublishElement);
                    if (baseChannel == null) {
                        return null;
                    }
                    if (baseChannel.isSite()) {
                        return baseChannel;
                    }
                    while (n4 > 0 && baseChannel != null && !baseChannel.isSite()) {
                        baseChannel = baseChannel.getHost();
                        --n4;
                    }
                    return baseChannel;
                }
            } else {
                n = ((String)object).hashCode();
            }
        }
        object = WCMTagParserHelper.getCurrChannelOrSite(iPublishElement);
        if (object == null) {
            return null;
        }
        switch (n) {
            case 2545479: {
                if (!((BaseChannel)object).isSite()) {
                    object = ((BaseChannel)object).getSite();
                }
                return object;
            }
            case 75627155: {
                return object;
            }
            case -1942094678: {
                if (!((BaseChannel)object).isSite()) {
                    object = ((BaseChannel)object).getHost();
                }
                return object;
            }
        }
        return Channel.findByName(iPublishFolder.getId(), string);
    }

    private static BaseChannel getCurrChannelOrSite(IPublishElement iPublishElement) throws WCMException {
        BaseChannel baseChannel = null;
        try {
            baseChannel = iPublishElement instanceof IPublishFolder ? (BaseChannel)iPublishElement.getSubstance() : (BaseChannel)iPublishElement.getFolder().getSubstance();
        }
        catch (ClassCastException classCastException) {
            throw new WCMException(10, "Upper host must be a channel or a site!");
        }
        return baseChannel;
    }

    public static Document findDocumentHost(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (!(iPublishElement instanceof PublishContentDocumentImpl)) {
            publishTagContext.addWarning(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label10", "\u5f53\u524dUpperHost\u4e0d\u662fDocument\uff01"));
            return null;
        }
        PublishContentDocumentImpl publishContentDocumentImpl = (PublishContentDocumentImpl)iPublishElement;
        return (Document)publishContentDocumentImpl.getSubstance();
    }
}

