/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.regex.Pattern;

public class WCMTagParserCurPage
implements ITagParser {
    private TagItem m_tagItem;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_CURPAGE");
            tagBeanInfo.setDesc("TRS_CURPAGE");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("VALUE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue(" > ");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_self");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("HOMEPAGEDESC");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("USEDNAME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEXNAME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FROMPOSITION");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("HIDECURRCHNL");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CURRCHNLNOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CURRCHNLCLS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        TemplateQuote templateQuote = new TemplateQuote();
        templateQuote.setQuotedFolderWithParent();
        templateQuote.setQuoteType(5);
        return new TemplateQuote[]{templateQuote};
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string;
        IPublishElement iPublishElement = publishTagContext.getPageElement();
        if (iPublishElement == null) {
            throw new WCMException(10, "Page element required in context!");
        }
        IPublishFolder iPublishFolder = iPublishElement.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig required in page element!");
        }
        BaseChannel baseChannel = (BaseChannel)iPublishFolder.getSubstance();
        if (baseChannel == null) {
            throw new WCMException(10, "Start folder substance required in page context!");
        }
        boolean bl = publishTagContext.getAttribute("only", false);
        boolean bl2 = publishTagContext.getAttribute("autolink", true);
        if (bl2) {
            String string2 = iPublishElement.isFolder() ? null : PublishPathCompass.calSubDirectory((IPublishContent)iPublishElement, false);
            string = this.getLinkedPath(publishTagContext, baseChannel, bl, string2);
        } else {
            string = this.getDescPath(publishTagContext, baseChannel, bl);
        }
        return new String[]{string};
    }

    private String getLinkedPath(PublishTagContext publishTagContext, BaseChannel baseChannel, boolean bl, String string) throws WCMException {
        try {
            String string2;
            Object object;
            String string3 = publishTagContext.getAttribute("TARGET");
            String string4 = publishTagContext.getAttribute("EXTRA");
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            String string5 = publishTagContext.getPathCompass().getFullDataPath(publishTagContext.getUpperHost(), false);
            String string6 = publishTagContext.getAttribute("INDEXNAME");
            if (string6 == null) {
                string6 = "";
            }
            String string7 = string == null || string.length() == 0 ? "./" : HtmlUtil.calParentRelativePath(string);
            string7 = string7 + string6;
            boolean bl2 = publishTagContext.getAttribute("USEDNAME", false);
            String string8 = null;
            string8 = bl2 ? baseChannel.getName() : baseChannel.getDispDesc();
            String string9 = "";
            if (!publishTagContext.getAttribute("HideCurrChnl", false)) {
                if (publishTagContext.getAttribute("CurrChnlNoLink", false)) {
                    string9 = string9 + string8;
                } else {
                    object = CMyString.showEmpty(publishTagContext.getAttribute("CurrChnlCls"), "CurrChnlCls");
                    string4 = CMyString.isEmpty(string4) ? "class=\"" + (String)object + "\"" : (Pattern.compile(string2 = "(?is)(class\\s*=\\s*)(['\"])(.*?)\\2").matcher(string4).find() ? string4.replaceFirst(string2, "$1$2$3 " + (String)object + "$2") : string4 + " class=\"" + (String)object + "\"");
                    string9 = string9 + HtmlUtil.renderLink(string7, string3, null, string4, string8);
                }
            }
            object = this.getFromPosition(publishTagContext);
            if (!bl && !baseChannel.isSite()) {
                String string10;
                Object object2;
                IPublishFolder iPublishFolder2;
                string2 = this.getDelim(publishTagContext);
                IPublishFolder iPublishFolder3 = iPublishFolder;
                if (bl2) {
                    for (iPublishFolder2 = iPublishFolder3.getParent(); iPublishFolder2 != null && !iPublishFolder2.isRoot(); iPublishFolder2 = iPublishFolder2.getParent()) {
                        object2 = (BaseChannel)iPublishFolder2.getSubstance();
                        if (object == null || ((String[])object).length <= 0 || ((BaseChannel)object2).isSite() || !object[0].equals("CHANNEL") || !((BaseChannel)object2).getName().equals(object[1])) {
                            if (((BaseChannel)object2).isSite() || !((Channel)object2).isOnlyManager()) {
                                string10 = publishTagContext.getPathCompass().getFullDataPath(iPublishFolder2, false);
                                string7 = HtmlUtil.calRelativePath(string10, string5);
                                string7 = string7 + string6;
                                string8 = ((BaseChannel)object2).getName();
                                string9 = HtmlUtil.renderLink(string7, string3, null, string4, string8) + (CMyString.isEmpty(string9) ? "" : string2) + string9;
                            }
                            iPublishFolder3 = iPublishFolder2;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (iPublishFolder2 != null && !iPublishFolder2.isRoot()) {
                        object2 = (BaseChannel)iPublishFolder2.getSubstance();
                        if (object == null || ((String[])object).length <= 0 || ((BaseChannel)object2).isSite() || !object[0].equals("CHANNEL") || !((BaseChannel)object2).getName().equals(object[1])) {
                            if (((BaseChannel)object2).isSite() || !((Channel)object2).isOnlyManager()) {
                                string10 = publishTagContext.getPathCompass().getFullDataPath(iPublishFolder2, false);
                                string7 = HtmlUtil.calRelativePath(string10, string5);
                                string7 = string7 + string6;
                                string8 = ((BaseChannel)object2).getDispDesc();
                                string9 = HtmlUtil.renderLink(string7, string3, null, string4, string8) + (CMyString.isEmpty(string9) ? "" : string2) + string9;
                            }
                            iPublishFolder3 = iPublishFolder2;
                            iPublishFolder2 = iPublishFolder2.getParent();
                            continue;
                        }
                        break;
                    }
                }
                if (object == null || ((String[])object).length <= 0) {
                    object2 = iPublishFolder.getRoot();
                    string10 = publishTagContext.getPathCompass().getFullDataPath((IPublishFolder)object2, false);
                    string7 = HtmlUtil.calRelativePath(string10, string5);
                    string7 = string7 + string6;
                    string8 = this.getHomePageDesc(publishTagContext, (BaseChannel)object2.getSubstance());
                    string9 = HtmlUtil.renderLink(string7, string3, null, string4, string8) + (CMyString.isEmpty(string9) ? "" : string2) + string9;
                }
            }
            return string9;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to assemble the linked path of current folder!", exception);
        }
    }

    private String getDescPath(PublishTagContext publishTagContext, BaseChannel baseChannel, boolean bl) throws WCMException {
        boolean bl2 = publishTagContext.getAttribute("USEDNAME", false);
        String string = null;
        string = bl2 ? baseChannel.getName() : baseChannel.getDispDesc();
        if (!bl && !baseChannel.isSite()) {
            Channel channel;
            String[] stringArray = this.getFromPosition(publishTagContext);
            String string2 = this.getDelim(publishTagContext);
            if (bl2) {
                for (channel = ((Channel)baseChannel).getParent(); !(channel == null || stringArray != null && stringArray.length > 0 && stringArray[0].equals("CHANNEL") && channel.getName().equals(stringArray[1])); channel = channel.getParent()) {
                    if (channel.isOnlyManager()) continue;
                    string = channel.getName() + string2 + string;
                }
            } else {
                while (channel != null) {
                    if (!channel.isOnlyManager()) {
                        string = channel.getDispDesc() + string2 + string;
                    }
                    channel = channel.getParent();
                }
            }
            String string3 = this.getHomePageDesc(publishTagContext, baseChannel);
            string = string3 + string2 + string;
        }
        return string;
    }

    private String getHomePageDesc(PublishTagContext publishTagContext, BaseChannel baseChannel) throws WCMException {
        String string = null;
        String string2 = publishTagContext.getAttribute("HOMEPAGEDESC");
        if (CMyString.isEmpty(string2)) {
            boolean bl = false;
            try {
                bl = "true".equals(ConfigServer.getServer().getSysConfigValue("TAGCURPAGE_USEDESC", "false"));
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
            string = bl ? baseChannel.getSite().getDispDesc() : I18NMessage.get(WCMTagParserCurPage.class, "WCMTagParserCurPage.label1", "\u9996\u9875");
        } else {
            string = "@truename".equals(string2.toLowerCase()) ? baseChannel.getSite().getDispDesc() : string2;
        }
        return string;
    }

    private String getDelim(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("VALUE");
        if (string == null || (string = string.trim()).length() == 0) {
            string = "&nbsp;&gt;&nbsp;";
        }
        return string;
    }

    private String[] getFromPosition(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("fromPosition");
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split(":");
        stringArray[0] = stringArray[0].toUpperCase();
        return stringArray;
    }
}

