/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;

public class WCMTagParserChannels
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    private List m_channels;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_CHANNELS");
            tBI.setDesc("TRS_CHANNELS");
            tBI.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("SITE");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setEnumValue(new String[]{"-1", "0", "1", "2", "11"});
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDINDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("order");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("PAGESIZE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_channels != null) {
            this.m_channels = null;
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    protected int getQuoteType() {
        return 5;
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public int getRecordSize() {
        return this.m_channels == null ? 0 : this.m_channels.size();
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl publishFolderChannelImpl = new PublishFolderChannelImpl(channel);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishFolderChannelImpl);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        List list = this.m_tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        BaseChannel baseChannel = this.findHost(publishTagContext, false, true);
        if (baseChannel == null) {
            return null;
        }
        if (publishTagContext.getAttribute("ONLY", false) && !baseChannel.isSite()) {
            this.m_channels = new ArrayList(1);
            this.m_channels.add(baseChannel);
        } else {
            String string = publishTagContext.getAttribute("order");
            if (!CMyString.isEmpty(string)) {
                WCMFilter wCMFilter = new WCMFilter();
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("status >= 0");
                stringBuffer.append("and parentId=?");
                wCMFilter.addSearchValues(baseChannel.getId());
                int n = publishTagContext.getAttribute("CHILDTYPE", 0);
                if (n >= 0) {
                    stringBuffer.append("and chnlType=?");
                    wCMFilter.addSearchValues(n);
                }
                wCMFilter.setWhere(stringBuffer.toString());
                wCMFilter.setOrder(string);
                Channels channels = Channels.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
                this.m_channels = new ArrayList(channels.size());
                int n2 = channels.size();
                for (int i = 0; i < n2; ++i) {
                    Channel channel = (Channel)channels.getAt(i);
                    if (channel == null) continue;
                    this.m_channels.add(channel);
                }
            } else {
                int n = publishTagContext.getAttribute("CHILDTYPE", 0);
                if (n < 0 && n != -1) {
                    n = -1;
                }
                this.m_channels = baseChannel.getChildren(ContextHelper.getLoginUser(), n);
            }
        }
        int n = 0;
        int n3 = publishTagContext.getAttribute("NUM", 0);
        if (n3 <= 0 || n3 > this.m_channels.size()) {
            n3 = this.m_channels.size();
        }
        for (int i = this.m_channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)this.m_channels.get(i);
            if (channel == null || !channel.isCanPub()) {
                this.m_channels.remove(i);
                continue;
            }
            ++n;
        }
        try {
            this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
            String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
            Object var13_19 = null;
            this.clear();
            return stringArray;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(220, "Failed to parse the channels list!", exception);
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                this.clear();
                throw throwable;
            }
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl publishFolderChannelImpl = new PublishFolderChannelImpl(channel);
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(publishFolderChannelImpl);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            TagBeanInfoHelper.checkChannelName(iPublishFolder, tagItem, stringBuffer);
        }
    }
}

