/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserChannel
extends TagParserFolderBase {
    private static Logger logger = Logger.getLogger(WCMTagParserChannel.class);
    private static boolean SUPPORT_CHNLLOG_PROPERTY = true;
    private static int MAX_NUM_CHNLLOG = 10;
    private static final int CHNL_DESC = 100;
    private static final int DATA_COUNT = 101;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_CHANNEL");
            tBI.setDesc("TRS_CHANNEL");
            tBI.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("OWNER");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDINDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("CHNLDESC");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("DATEFORMAT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("yyyy-MM-dd HH:mm:ss");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMAT");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMATTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "XML"});
            tagBeanAttrInfo.setDefaultValue("HTML");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_self");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("COUNTWHERE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKALT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKALTTEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKTEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TRUNCATEDFLAG");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("...");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TemplateName");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FromSite");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ALL");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INCLUDECHILDREN");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("COUNTWHERE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        boolean bl = !publishTagContext.getAttribute("FromSite", false);
        BaseChannel baseChannel = WCMTagParserHelper.findFolderHost(this.m_tagItem, publishTagContext, bl);
        if (bl || baseChannel == null) {
            return baseChannel;
        }
        return baseChannel.getSite();
    }

    protected String getDefaultField() {
        return "CHNLDESC";
    }

    protected boolean mayAutoLink(PublishTagContext publishTagContext) {
        if (!(this.m_host instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)this.m_host;
        if (channel == null) {
            return false;
        }
        int n = channel.getType();
        if (n == 2 || n == 1) {
            return false;
        }
        return super.mayAutoLink(publishTagContext);
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLDESC", 100);
        this.registerHostSpecialProperty("_DATACOUNT", 101);
        for (int i = 0; SUPPORT_CHNLLOG_PROPERTY && i < MAX_NUM_CHNLLOG; ++i) {
            this.registerHostSpecialProperty("CHNLLOG" + i, i + 1);
        }
    }

    protected String[] parseHostSpecialProperty(int n, PublishTagContext publishTagContext) throws WCMException {
        if (this.m_host == null) {
            logger.error((Object)(publishTagContext.getTagItem() + I18NMessage.get(WCMTagParserChannel.class, "WCMTagParserChannel.label1", "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173\u9891\u9053\u6ca1\u6709\u627e\u5230\uff01")));
            return null;
        }
        Channel channel = (Channel)this.m_host;
        switch (n) {
            case 100: {
                String string = channel.getDesc();
                if (string == null || (string = string.trim()).length() <= 0) {
                    string = channel.getName();
                }
                return this.parseProperty(string, publishTagContext);
            }
            case 101: {
                return this.parseDataCount(publishTagContext, channel);
            }
        }
        if (n > 0 && n <= MAX_NUM_CHNLLOG) {
            return new String[]{this.m_host.getAttributeValue("CHNLLOG" + (n - 1))};
        }
        return null;
    }

    protected String[] parseDataCount(PublishTagContext publishTagContext, Channel channel) throws WCMException {
        Object object;
        WCMFilter wCMFilter = null;
        if (publishTagContext.getAttribute("ALL", false)) {
            wCMFilter = null;
        } else {
            wCMFilter = new WCMFilter("", "", "");
            object = publishTagContext.getAttribute("COUNTWHERE");
            if (CMyString.isEmpty((String)object)) {
                wCMFilter.setWhere("WCMCHNLDOC.DOCSTATUS=?");
                wCMFilter.addSearchValues(10);
            } else {
                wCMFilter.setWhere((String)object);
            }
        }
        object = DocumentsGetHelper.makeChannelFilter(channel, wCMFilter);
        DBManager dBManager = DBManager.getDBManager();
        int n = dBManager.sqlExecuteCountQuery((WCMFilter)object);
        if (publishTagContext.getAttribute("INCLUDECHILDREN", false)) {
            n += this.getChildrenCount(dBManager, channel, wCMFilter);
        }
        return new String[]{String.valueOf(n)};
    }

    private int getChildrenCount(DBManager dBManager, Channel channel, WCMFilter wCMFilter) throws WCMException {
        List list = channel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int n = list.size() - 1;
        int n2 = 0;
        if (wCMFilter == null) {
            for (int i = n; i >= 0; --i) {
                Channel channel2 = (Channel)list.get(i);
                if (channel2 == null) continue;
                WCMFilter wCMFilter2 = DocumentsGetHelper.makeChannelFilter(channel2, null);
                n2 += dBManager.sqlExecuteCountQuery(wCMFilter2);
                n2 += this.getChildrenCount(dBManager, channel2, wCMFilter);
            }
        } else {
            for (int i = n; i >= 0; --i) {
                Channel channel3 = (Channel)list.get(i);
                if (channel3 == null) continue;
                WCMFilter wCMFilter3 = DocumentsGetHelper.makeChannelFilter(channel3, new WCMFilter(wCMFilter));
                n2 += dBManager.sqlExecuteCountQuery(wCMFilter3);
                n2 += this.getChildrenCount(dBManager, channel3, wCMFilter);
            }
        }
        return n2;
    }

    private class TBI
    extends TagBeanInfo {
        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            TagBeanInfoHelper.checkChannelName(iPublishFolder, tagItem, stringBuffer);
        }
    }
}

