/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.wcm.photo.ImageLibHelper;
import java.io.File;
import org.apache.log4j.Logger;

public class WCMAppendixGenerator {
    private static Logger m_oLogger = Logger.getLogger(WCMAppendixGenerator.class);
    public static final int RETURN_NONE = 0;
    public static final int RETURN_NAME = 1;
    public static final int RETURN_HTML = 2;

    private WCMAppendixGenerator() {
    }

    public static String generateAppendixes(Document document, int n, PublishTagContext publishTagContext, int n2) throws WCMException {
        String string;
        block15: {
            BaseObjs baseObjs = null;
            Appendix appendix = null;
            PublishContentDocumentImpl publishContentDocumentImpl = null;
            int n3 = 0;
            String string2 = null;
            try {
                String string3;
                AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
                WCMFilter wCMFilter = null;
                String string4 = publishTagContext.getAttribute("Where");
                StringBuffer stringBuffer = new StringBuffer(128);
                if (!CMyString.isEmpty(string4)) {
                    stringBuffer.append(string4);
                }
                if (!CMyString.isEmpty(string3 = publishTagContext.getAttribute("RELATEDCOLUMN"))) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(" RELATEDCOLUMN=?");
                }
                if (stringBuffer.length() > 0) {
                    wCMFilter = new WCMFilter("", stringBuffer.toString(), "");
                    if (!CMyString.isEmpty(string3)) {
                        wCMFilter.addSearchValues(string3);
                    }
                    stringBuffer.setLength(0);
                }
                baseObjs = appendixMgr.getAppendixes(document, n, wCMFilter);
                String string5 = publishTagContext.getAttribute("SEPERATOR");
                if (string5 == null) {
                    String string6 = publishTagContext.getAttribute("FIELD");
                    string5 = string6 != null && (string6 = string6.trim()).length() > 0 ? "\n" : "<BR/>";
                }
                if (baseObjs != null && !baseObjs.isEmpty()) {
                    int n4 = publishTagContext.getAttribute("STARTPOS", 0);
                    if (n4 <= 0) {
                        n4 = 1;
                    }
                    for (int i = n4 - 1; i < baseObjs.size(); ++i) {
                        appendix = (Appendix)baseObjs.getAt(i);
                        if (appendix == null) continue;
                        if (publishContentDocumentImpl == null) {
                            publishContentDocumentImpl = new PublishContentDocumentImpl(document);
                            IPublishFolder iPublishFolder = publishTagContext.getUpperFolder();
                            if (iPublishFolder == null) {
                                throw new WCMException(1100, "The channel where the document [" + document.getId() + "] lies not found!");
                            }
                            publishContentDocumentImpl.setFolder(iPublishFolder);
                        }
                        if (appendix.getFlag() == 20 && !WCMAppendixGenerator.validPic(appendix, publishTagContext)) continue;
                        string2 = string2 != null ? string2 + string5 : "";
                        string2 = string2 + WCMAppendixGenerator.generateAppendix(appendix, publishContentDocumentImpl, publishTagContext, n2);
                        ++n3;
                    }
                }
                string = string2;
                Object var19_21 = null;
                if (baseObjs == null) break block15;
            }
            catch (Exception exception) {
                try {
                    throw new WCMException(1100, "Failed to generate document appendixes!", exception);
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var19_22 = null;
                        if (baseObjs == null) break block16;
                        baseObjs.clear();
                    }
                    throw throwable;
                }
            }
            baseObjs.clear();
        }
        return string;
    }

    public static boolean validPic(Appendix appendix, PublishTagContext publishTagContext) throws WCMException {
        String string = appendix.getFile();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0) + string;
        String string3 = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
        int[] nArray = CMyString.splitToInt(string3, ",");
        int n = publishTagContext.getAttribute("MinWidth", nArray[0]);
        int n2 = publishTagContext.getAttribute("MinHeight", nArray[1]);
        return CMyFile.validImageFile(string2, n, n2);
    }

    public static String generateAppendix(Appendix appendix, IPublishContent iPublishContent, PublishTagContext publishTagContext, int n) throws WCMException {
        if (appendix == null || iPublishContent == null || publishTagContext == null) {
            throw new WCMException(10, "Invalid parameters!");
        }
        String string = publishTagContext.getAttribute("FIELD");
        if (string != null && (string = string.trim()).length() > 0) {
            if (publishTagContext.getAttribute("UPLOAD", false)) {
                WCMAppendixGenerator.distributeFile(appendix, iPublishContent, publishTagContext, 0);
            }
            if (string.equalsIgnoreCase("_RECURL")) {
                String string2 = appendix.getFile();
                if (appendix.getFlag() == 40) {
                    return string2;
                }
                if (appendix.getFlag() == 20 && string2.indexOf(47) >= 0) {
                    FilesMan filesMan = FilesMan.getFilesMan();
                    if (string2.startsWith(filesMan.getPathConfigValue("W0", 1))) {
                        string2 = CMyFile.extractFileName(string2, "/");
                    } else {
                        return string2;
                    }
                }
                int n2 = publishTagContext.getAttribute("Width", 0);
                string2 = FileHelper.makeNewZoomInFileName(string2, n2);
                return WCMAppendixGenerator.makeAppendixURL(publishTagContext, iPublishContent, string2);
            }
            String string3 = appendix.getPropertyAsString(string);
            if (string3 == null) {
                string3 = "";
            }
            string3 = TagParseHelper.formatTextIfNeeded(publishTagContext, string3);
            if (n == 2) {
                string3 = CMyString.showNull(publishTagContext.getAttribute("BEGINHTML")) + string3;
                string3 = string3 + CMyString.showNull(publishTagContext.getAttribute("ENDHTML"));
            }
            return string3;
        }
        return WCMAppendixGenerator.distributeFile(appendix, iPublishContent, publishTagContext, n);
    }

    private static final String distributeFile(Appendix appendix, IPublishContent iPublishContent, PublishTagContext publishTagContext, int n) throws WCMException {
        try {
            String string;
            String string2;
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            boolean bl = publishTagContext.isPreview();
            String string3 = string2 = appendix.getFile();
            int n2 = appendix.getFlag();
            if (n2 != 40) {
                string = null;
                int n3 = ImageLibHelper.getTypeQuotedImageLib(appendix);
                switch (n3) {
                    case 0: {
                        string3 = CMyFile.extractFileName(string3);
                        int n4 = publishTagContext.getAttribute("Width", 0);
                        string = FileHelper.makeAbsoluteFilePathOfImage(string3, n4);
                        string3 = CMyFile.extractFileName(string);
                        break;
                    }
                    case 1: {
                        string3 = CMyFile.extractFileName(string3);
                        string = FilesMan.getFilesMan().mapFilePath(string3, 0) + string3;
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                if (string != null) {
                    if (!CMyFile.fileExists(string)) {
                        publishTagContext.addWarning(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label1", "\u6587\u6863\u9644\u4ef6"), appendix.getId(), I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label2", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230\u6587\u6863(") + iPublishContent.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label3", ")\u7684\u9644\u4ef6[") + string3 + "]");
                    } else {
                        String string4 = publishPathCompass.getLocalPath(iPublishContent, bl);
                        PublishSyncGlobalTuner.insureLocalPathExists(string4);
                        boolean bl2 = true;
                        File file = new File(string4 + string3);
                        if (!file.exists()) {
                            try {
                                CMyFile.copyFile(string, string4 + string3);
                            }
                            catch (CMyException cMyException) {
                                if (new File(string).exists() && file.exists()) {
                                    m_oLogger.debug((Object)I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label4", "\u5ffd\u7565\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\u4e14\u76ee\u6807\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236."));
                                }
                                throw cMyException;
                            }
                        } else {
                            bl2 = false;
                            m_oLogger.debug((Object)I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label5", "\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236."));
                        }
                        if (!bl && bl2) {
                            IPublishFolder iPublishFolder = iPublishContent.getFolder();
                            if (iPublishFolder == null) {
                                iPublishFolder = iPublishContent.getOriginalHome();
                                iPublishContent.setFolder(iPublishFolder);
                            }
                            publishTagContext.getFileDistributeShip().distributeFile(string, iPublishContent, null, true);
                        }
                    }
                }
            }
            switch (n) {
                case 1: {
                    return string3;
                }
                case 2: {
                    if (n2 != 40 && string3.indexOf(47) < 0) {
                        string3 = WCMAppendixGenerator.makeAppendixURL(publishTagContext, iPublishContent, string3);
                    }
                    string = null;
                    String string5 = publishTagContext.getAttribute("EXTRA");
                    if (n2 == 20 || n2 == 30) {
                        String string6;
                        string = HtmlUtil.renderImage(string3, appendix.getAlt(), string5, publishTagContext.getAttribute("WIDTH"), publishTagContext.getAttribute("HEIGHT"));
                        if (publishTagContext.getAttribute("MEMO", false) && (string6 = appendix.getDesc()) != null && string6.length() > 0) {
                            string = string + CMyString.showNull(publishTagContext.getAttribute("BEGINMEMO")) + string6 + CMyString.showNull(publishTagContext.getAttribute("ENDMEMO"));
                        }
                        if (publishTagContext.getAttribute("AUTOLINK", false)) {
                            string = WCMAppendixGenerator.addAutoLink(string, publishTagContext);
                        }
                    } else {
                        String string7 = appendix.getDesc();
                        if (string7 == null || string7.length() == 0) {
                            string7 = string2;
                        }
                        string = publishTagContext.getAttribute("AUTOLINK", true) ? HtmlUtil.renderLink(string3, publishTagContext.getAttribute("TARGET"), appendix.getAlt(), string5, string7) : string7;
                    }
                    return CMyString.showNull(publishTagContext.getAttribute("BEGINHTML")) + string + CMyString.showNull(publishTagContext.getAttribute("ENDHTML"));
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label6", "\u751f\u6210\u6587\u6863[") + iPublishContent.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label7", "]\u9644\u4ef6\u6216\u5916\u90e8\u6587\u4ef6\u5931\u8d25"), exception);
        }
    }

    public static String makeAppendixURL(PublishTagContext publishTagContext, IPublishContent iPublishContent, String string) throws WCMException {
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"));
        String string2 = publishPathCompass.getAbsoluteHttpPath(iPublishContent);
        if (bl && !publishTagContext.isPreview()) {
            string2 = PublishPathCompass.calFullDataPath(iPublishContent, false);
            return WCMAppendixGenerator.convertURL2ImageURL(string2, publishTagContext) + string;
        }
        boolean bl2 = publishTagContext.getAttribute("UrlIsAbs", false);
        if (bl2) {
            if (publishTagContext.isPreview()) {
                string2 = publishPathCompass.getPreviewHttpPath(iPublishContent);
            }
            return string2 + string;
        }
        return HtmlUtil.calRelativePath(string2, publishTagContext.getPageHttpPath()) + string;
    }

    protected static String addAutoLink(String string, PublishTagContext publishTagContext) throws WCMException {
        String string2 = publishTagContext.getAttribute("TARGET");
        String string3 = "";
        String string4 = publishTagContext.getAttribute("LINKTEXT");
        String string5 = null;
        String string6 = WCMAppendixGenerator.getAutoLinkUrl(publishTagContext);
        if (!publishTagContext.getUpperHost().isLink()) {
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string6, string2, string5, string3, string, string4);
    }

    protected static String getAutoLinkUrl(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label8", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label9", "\u5f53\u524dUpperHost[") + iPublishElement.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label10", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        switch (iPublishContent.getBodyType()) {
            case 40: {
                String string = iPublishContent.getFileName();
                return publishPathCompass.getAbsoluteHttpPath(publishTagContext.getUpperHost()) + string;
            }
            case 30: {
                return iPublishContent.getLinkUrl();
            }
        }
        return publishPathCompass.getHttpUrl((IPublishContent)publishTagContext.getUpperHost(), 0);
    }

    protected static String getApdHttpPath(IPublishContent iPublishContent, PublishTagContext publishTagContext) throws WCMException {
        String string = "";
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label8", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label9", "\u5f53\u524dUpperHost[") + iPublishElement.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label10", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        string = bl ? publishPathCompass.getPreviewHttpPath(iPublishContent) : publishPathCompass.getAbsoluteHttpPath(iPublishElement);
        return string;
    }

    private static String convertURL2ImageURL(String string, PublishTagContext publishTagContext) throws WCMException {
        String string2 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String string3 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String string4 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
        int n = Integer.parseInt(string4);
        PublishPageContext publishPageContext = publishTagContext.getPageContext();
        String string5 = publishPageContext.getExtraAttribute("CurrImageSiteIndex");
        int n2 = Integer.parseInt(string5 = CMyString.showNull(string5, "1"));
        if (n2 >= n) {
            publishPageContext.setExtraAttribute("CurrImageSiteIndex", "1");
        } else {
            publishPageContext.setExtraAttribute("CurrImageSiteIndex", String.valueOf(n2 + 1));
        }
        if (n2 == 1) {
            return "http://" + string2 + "." + string3 + "/" + string;
        }
        return "http://" + string2 + (n2 - 1) + "." + string3 + "/" + string;
    }
}

