/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.logo;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.publish.logo.Logos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;

public class Logo
extends CMSObj {
    public static final int OBJ_TYPE = 1718600976;
    public static final String DB_TABLE_NAME = "XWCMLOGO";
    public static final String DB_ID_NAME = "LOGOID";
    static final String MOVE_FORWORD_SQL = "update XWCMLogo set LogoOrder=LogoOrder+1 where HostType=? and HostId=? and LogoOrder>=? and LogoOrder<?";
    static final String MOVE_AFTER_SQL = "update XWCMLogo set LogoOrder=LogoOrder-1 where HostType=? and HostId=? and LogoOrder<=? and LogoOrder>?";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1718600976;
    }

    public boolean isUpdated() {
        return this.getPropertyAsBoolean("UPDATED", true);
    }

    public boolean setUpdated(boolean bl) throws WCMException {
        return this.setProperty("UPDATED", bl);
    }

    public int getHostType() {
        return this.getPropertyAsInt("HOSTTYPE", 0);
    }

    public boolean setHostType(int n) throws WCMException {
        return this.setProperty("HOSTTYPE", n);
    }

    public int getHostId() {
        return this.getPropertyAsInt("HOSTID", 0);
    }

    public boolean setHostId(int n) throws WCMException {
        return this.setProperty("HOSTID", n);
    }

    public String getFileName() {
        return this.getPropertyAsString("FILENAME");
    }

    public boolean setFileName(String string) throws WCMException {
        return this.setProperty("FILENAME", string);
    }

    public int getLogoOrder() {
        return this.getPropertyAsInt("LOGOORDER", 0);
    }

    public boolean setLogoOrder(int n) throws WCMException {
        return this.setProperty("LOGOORDER", n);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            if (this.getProperty("HOSTTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label1", "\u5c5e\u6027HostType\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            if (this.getProperty("HOSTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label2", "\u5c5e\u6027HostId\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            if (this.getProperty("FILENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label3", "\u5c5e\u6027FileName\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            string = this.getFileName();
            if (this.getProperty("LOGOORDER") == null) {
                int n = DBManager.getDBManager().sqlExecuteIntQuery("select max(LogoOrder) from XWCMLOGO where HostType=? and HostId=?", new int[]{this.getHostType(), this.getHostId()});
                if (n < 0) {
                    n = 0;
                }
                this.setLogoOrder(++n);
            }
            if (string != null) {
                string = FilesMan.getFilesMan().moveWCMFile(string, "P0", false);
                this.setFileName(string);
            }
            this.setUpdated(true);
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Logo.class, "Logo.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Logo.isValid)"));
            }
            if (this.isChangeProperty("FILENAME")) {
                string = this.getNewPropertyAsString("FILENAME");
            }
            if (this.isChangeProperty("LOGOORDER")) {
                this.changeOrder(this.getNewPropertyAsInt("LOGOORDER", this.getLogoOrder()));
            }
            if (string != null) {
                FilesMan filesMan = FilesMan.getFilesMan();
                string = filesMan.mapFilePath(string, 0) + string;
                String string2 = filesMan.mapFilePath(this.getFileName(), 0) + this.getFileName();
                try {
                    CMyFile.copyFile(string, string2);
                    CMyFile.deleteDir(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.setFileName(this.getFileName());
                this.setUpdated(true);
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    private void changeOrder(int n) throws WCMException {
        int n2 = this.getLogoOrder();
        if (n2 == n) {
            return;
        }
        int[] nArray = new int[]{this.getHostType(), this.getHostId(), n, n2};
        String[] stringArray = new String[]{n2 > n ? MOVE_FORWORD_SQL : MOVE_AFTER_SQL};
        DBManager.getDBManager().sqlExecuteUpdate(stringArray, nArray);
    }

    public static final Logo findOf(int n, int n2, int n3) throws WCMException {
        Logos logos = Logos.findOf(null, n, n2, null);
        if (logos.size() <= n3) {
            return null;
        }
        return (Logo)logos.getAt(n3);
    }

    public static final Logo findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Logo)BaseObj.findById(Logo.class, n);
    }

    public static final Logo createNewInstance() throws WCMException {
        return (Logo)BaseObj.createNewInstance(Logo.class);
    }

    public static final Logo findByKey(Object object) throws WCMException {
        return (Logo)BaseObj.findByKey(Logo.class, object);
    }
}

