/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class FlowEmployLCListenerForChange
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(FlowEmployLCListenerForChange.class);
    private FlowServer m_oFlowServer = null;

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof FlowEmploy)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        FlowEmploy flowEmploy = (FlowEmploy)baseObj;
        int n2 = flowEmploy.getEmployerId();
        int n3 = flowEmploy.getPropertyAsInt("FLOWID", 0);
        int n4 = flowEmploy.getNewPropertyAsInt("FLOWID", 0);
        if (n3 <= 0 || n3 == n4) {
            return;
        }
        String string = "exists(select NodeId from WCMFlowNode where WCMFlowDoc.NodeId=NodeId and FlowId=" + n3 + ")";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), wCMFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        for (int i = 0; i < flowDocs.size(); ++i) {
            this.updateFolwDoc((FlowDoc)flowDocs.getAt(i), n2, n4);
        }
    }

    private void updateFolwDoc(FlowDoc flowDoc, int n, int n2) throws WCMException {
        if (flowDoc == null) {
            return;
        }
        IFlowContent iFlowContent = flowDoc.getFlowContent();
        if (iFlowContent.getContentType() != 605) {
            return;
        }
        Document document = (Document)iFlowContent.getSubinstance();
        if (document == null || document.getChannelId() != n) {
            return;
        }
        try {
            this.getFlowServer().forceDocToEnd(iFlowContent, User.getSystem());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label3", "\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c\u53d1\u751f\u5f02\u5e38"), exception);
        }
        if (n2 > 0) {
            String string = I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label4", "\u56e0\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6539\u53d8\u800c\u91cd\u65b0\u6d41\u8f6c");
            this.getFlowServer().startContentInFlow(User.getSystem(), iFlowContent, string);
        }
    }

    private FlowServer getFlowServer() throws WCMException {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        return this.m_oFlowServer;
    }
}

