/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.Filters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilterMgr {
    private static Logger logger = Logger.getLogger(FilterMgr.class);
    private Map m_mOptionIdMapping;

    public Filters queryByChannel(Channel channel, WCMFilter wCMFilter) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label1", "\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u7b5b\u9009\u5668\u6570\u636e\uff01"));
        }
        User user = this.getLoginUser();
        boolean bl = AuthServer.hasRight(user, (CMSObj)channel, 14);
        if (!bl) {
            throw new WCMException(CMyString.format(I18NMessage.get(FilterMgr.class, "FilterMgr.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[{0}]\u4e0b\u7684\u7b5b\u9009\u5668\uff01"), new String[]{channel.getDesc()}));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "ChannelId=?", "");
        wCMFilter2.addSearchValues(channel.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Filters.openWCMObjs(user, wCMFilter2);
    }

    public FilterOptionGroups queryGroupsByFilter(Filter filter, WCMFilter wCMFilter) throws WCMException {
        if (filter == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label3", "\u7b5b\u9009\u5668\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int n = filter.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "FILTERID=?", "FORDER ASC");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return FilterOptionGroups.openWCMObjs(null, wCMFilter2);
    }

    public FilterOptions queryFilterOptionsByGroup(FilterOptionGroup filterOptionGroup, WCMFilter wCMFilter) throws WCMException {
        if (filterOptionGroup == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label4", "\u9009\u9879\u7ec4\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int n = filterOptionGroup.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "GROUPID=?", "FORDER ASC");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return FilterOptions.openWCMObjs(null, wCMFilter2);
    }

    public FilterOptions queryOptionsByFilter(Filter filter, WCMFilter wCMFilter) throws WCMException {
        String string = "exists(select 1 from xwcmfilteroptiongroup where xwcmfilteroptiongroup.filterOPTIONGROUPID = xwcmfilteroption.groupid and exists(select 1 from xwcmfilter where xwcmfilter.filterid = ? and xwcmfilter.filterid = xwcmfilteroptiongroup.filterid))";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "FORDER ASC");
        wCMFilter2.addSearchValues(filter.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return FilterOptions.openWCMObjs(null, wCMFilter2);
    }

    public void deleteFilter(Filter filter) throws WCMException {
        if (filter == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label5", "\u5f85\u5220\u9664\u7684\u7b5b\u9009\u5668\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        FilterOptionGroups filterOptionGroups = this.queryGroupsByFilter(filter, null);
        for (int i = filterOptionGroups.size() - 1; i >= 0; --i) {
            FilterOptionGroup filterOptionGroup = (FilterOptionGroup)filterOptionGroups.getAt(i);
            if (filterOptionGroup == null) continue;
            this.deleteFilterOptionGroup(filterOptionGroup);
        }
        filter.delete();
    }

    public void deleteFilterOptionGroup(FilterOptionGroup filterOptionGroup) throws WCMException {
        if (filterOptionGroup == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label6", "\u5f85\u5220\u9664\u7684\u9009\u9879\u7ec4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        FilterOptions filterOptions = this.queryFilterOptionsByGroup(filterOptionGroup, null);
        for (int i = filterOptions.size() - 1; i >= 0; --i) {
            FilterOption filterOption = (FilterOption)filterOptions.getAt(i);
            if (filterOption == null) continue;
            this.deleteFilterOption(filterOption);
        }
        filterOptionGroup.delete();
    }

    public void deleteFilterOption(FilterOption filterOption) throws WCMException {
        if (filterOption == null) {
            throw new WCMException(10, I18NMessage.get(FilterMgr.class, "FilterMgr.label7", "\u5f85\u5220\u9664\u7684\u9009\u9879\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        filterOption.delete();
    }

    public void copy(Filter filter, Channels channels, User user) throws WCMException {
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.copy(filter, channel, user);
        }
    }

    public void copy(Filter filter, Channel channel, User user) throws WCMException {
        this.m_mOptionIdMapping = new HashMap();
        Filter filter2 = (Filter)filter.cloneToNewObj();
        filter2.setChannelId(channel.getId());
        filter2.save(user);
        FilterOptionGroups filterOptionGroups = this.queryGroupsByFilter(filter, null);
        int n = filterOptionGroups.size();
        for (int i = 0; i < n; ++i) {
            FilterOptionGroup filterOptionGroup = (FilterOptionGroup)filterOptionGroups.getAt(i);
            if (filterOptionGroup == null) continue;
            this.copy(filterOptionGroup, filter2, user);
        }
        this.afterFilterSave(filter2);
    }

    private void afterFilterSave(Filter filter) throws WCMException {
        FilterOptions filterOptions = this.queryOptionsByFilter(filter, null);
        int n = filterOptions.size();
        for (int i = 0; i < n; ++i) {
            FilterOption filterOption = (FilterOption)filterOptions.getAt(i);
            if (filterOption == null) continue;
            boolean bl = false;
            String string = filterOption.getNotAllowedSelectOptions();
            if (!CMyString.isEmpty(string)) {
                String string2 = this.getNewOptionIds(string);
                filterOption.setNotAllowedSelectOptions(string2);
                bl = true;
            }
            if (!bl) continue;
            filterOption.save(ContextHelper.getLoginUser());
        }
        String string = filter.getPropertyAsString("disabledoptions");
        if (!CMyString.isEmpty(string)) {
            String string3 = this.getNewOptionIds(string);
            filter.setPropertyWithString("disabledoptions", string3);
            filter.save(ContextHelper.getLoginUser());
        }
    }

    private void copy(FilterOptionGroup filterOptionGroup, Filter filter, User user) throws WCMException {
        FilterOptionGroup filterOptionGroup2 = (FilterOptionGroup)filterOptionGroup.cloneToNewObj();
        filterOptionGroup2.setFilterId(filter.getId());
        filterOptionGroup2.save(user);
        FilterOptions filterOptions = this.queryFilterOptionsByGroup(filterOptionGroup, null);
        int n = filterOptions.size();
        for (int i = 0; i < n; ++i) {
            FilterOption filterOption = (FilterOption)filterOptions.getAt(i);
            if (filterOption == null) continue;
            this.copy(filterOption, filterOptionGroup2, user);
        }
    }

    private void copy(FilterOption filterOption, FilterOptionGroup filterOptionGroup, User user) throws WCMException {
        FilterOption filterOption2 = (FilterOption)filterOption.cloneToNewObj();
        filterOption2.setGroupId(filterOptionGroup.getId());
        String[] stringArray = new String[]{"FIRSTPIC", "SECONDPIC", "THIRDPIC"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = filterOption.getPropertyAsString(stringArray[i]);
            if (CMyString.isEmpty(string)) continue;
            FilesMan filesMan = FilesMan.getFilesMan();
            if (!filesMan.fileExists(string)) {
                logger.error((Object)CMyString.format("\u7b5b\u9009\u5668\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{string}));
                continue;
            }
            String string2 = filesMan.copyWCMFile(string, "P0");
            filterOption2.setPropertyWithString(stringArray[i], string2);
        }
        filterOption2.save(user);
        this.m_mOptionIdMapping.put(filterOption.getKey(), filterOption2.getKey());
    }

    private String getNewOptionIds(String string) {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = (Integer)this.m_mOptionIdMapping.get(new Integer(nArray[i]));
            if (n == null) continue;
            stringBuffer.append(n).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

