/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ChannelSyn
extends CMSObj {
    public static final int OBJ_TYPE = 903;
    public static final String DB_TABLE_NAME = "WCMCHANNELSYN";
    public static final String DB_ID_NAME = "CHANNELSYNID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 903;
    }

    public int getSrcChannelId() {
        return this.getPropertyAsInt("SRCCHANNEL", 0);
    }

    public Channel getSrcChannel() throws WCMException {
        return Channel.findById(this.getSrcChannelId());
    }

    public boolean setSrcChannelId(int n) throws WCMException {
        if (!this.isAddMode() && n == this.getSrcChannelId()) {
            return false;
        }
        return this.setProperty("SRCCHANNEL", n);
    }

    public int getToChannelId() {
        return this.getPropertyAsInt("TOCHANNEL", 0);
    }

    public Channel getToChannel() throws WCMException {
        return Channel.findById(this.getToChannelId());
    }

    public boolean setToChannelId(int n) throws WCMException {
        if (!this.isAddMode() && n == this.getToChannelId()) {
            return false;
        }
        return this.setProperty("TOCHANNEL", n);
    }

    public String getWhereSql() {
        return this.getPropertyAsString("WHERESQL");
    }

    public boolean setWhereSql(String string) throws WCMException {
        return this.setProperty("WHERESQL", string);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("SDATE");
    }

    public boolean setStartTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label1", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setStartTime)"));
        }
        return this.setProperty("SDATE", cMyDateTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EDATE");
    }

    public boolean setEndTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label2", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setEndTime)"));
        }
        return this.setProperty("EDATE", cMyDateTime);
    }

    public CMyDateTime getDocStartTime() {
        return (CMyDateTime)this.getProperty("DOCSDATE");
    }

    public boolean setDocStartTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label3", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setDocStartTime)"));
        }
        return this.setProperty("DOCSDATE", cMyDateTime);
    }

    public CMyDateTime getDocEndTime() {
        return (CMyDateTime)this.getProperty("DOCEDATE");
    }

    public boolean setDocEndTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label4", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setDocEndTime)"));
        }
        return this.setProperty("DOCEDATE", cMyDateTime);
    }

    public String getStatusIds() {
        String string = this.getPropertyAsString("STATUSES");
        return string == null ? "" : string;
    }

    public Statuses getStatuses(User user) throws WCMException {
        Statuses statuses = null;
        try {
            String string = this.getStatusIds();
            statuses = new Statuses(user);
            if (string == null || string.length() == 0) {
                return statuses;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Status status = null;
            while (stringTokenizer.hasMoreElements()) {
                int n = Integer.parseInt((String)stringTokenizer.nextElement());
                status = Status.findById(n);
                if (status == null) continue;
                statuses.addElement(status);
            }
            return statuses;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label5", "\u53d6\u5141\u8bb8\u5206\u53d1\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08ChannelSyn.getStatuses\uff09"), exception);
        }
    }

    public boolean setStatus(String string) throws WCMException {
        if (string == null) {
            string = "";
        } else if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                try {
                    Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label6", "\u65e0\u6548\u7684\u6587\u6863\u72b6\u6001\uff1a") + string2 + "\uff08ChannelSyn.setStatus\uff09");
                }
            }
        }
        return this.setProperty("STATUSES", string);
    }

    public boolean addStatus(int n) throws WCMException {
        Status status = Status.findById(n);
        return this.addStatus(status);
    }

    public boolean addStatus(Status status) throws WCMException {
        if (status == null) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label7", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u5bf9\u8c61\u4e3a\u7a7a\uff08ChannelSyn.addStatus\uff09"));
        }
        try {
            String string = String.valueOf(status.getId());
            String string2 = (String)this.getNewProperty("STATUSES");
            if (string2 == null) {
                string2 = this.getStatusIds();
            }
            if (("," + string2 + ",").indexOf("," + string + ",") >= 0) {
                return false;
            }
            return this.setProperty("STATUSES", (string2.length() == 0 ? "" : string2 + ",") + string);
        }
        catch (WCMException wCMException) {
            throw wCMException;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label8", "\u6dfb\u52a0\u5141\u8bb8\u5206\u53d1\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff08ChannelSyn.addStatus\uff09"), exception);
        }
    }

    public int getTransmitType() {
        String string = this.getAttributeValue("TransmitType");
        if (CMyString.isEmpty(string)) {
            return 2;
        }
        return Integer.parseInt(string);
    }

    public void setTransmitType(int n) throws WCMException {
        this.setAttribute("TransmitType", Integer.toString(n));
    }

    private boolean validateTransmitType() {
        int n = this.getTransmitType();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("SRCCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label9", "\u5c5e\u6027SrcChannelId\u6ca1\u6709\u8bbe\u7f6e(ChannelSyn.isValid)"));
            }
            if (this.getAllProperty().get("TOCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label10", "\u5c5e\u6027ToChannelId\u6ca1\u6709\u8bbe\u7f6e(ChannelSyn.isValid)"));
            }
            if (!this.validateTransmitType()) {
                throw new WCMException(1104, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label11", "\u4f20\u5165\u4e86\u65e0\u6548\u7684\u8f6c\u53d1\u7c7b\u578b\uff01(ChannelSyn.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label12", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ChannelSyn.isValid)"));
        }
        return true;
    }

    public static final ChannelSyn findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ChannelSyn)BaseObj.findById(ChannelSyn.class, n);
    }

    public static final ChannelSyn createNewInstance() throws WCMException {
        return (ChannelSyn)BaseObj.createNewInstance(ChannelSyn.class);
    }

    public static final ChannelSyn findByKey(Object object) throws WCMException {
        return (ChannelSyn)BaseObj.findByKey(ChannelSyn.class, object);
    }

    public static boolean isValid(int n, int n2) throws WCMException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(n));
        arrayList.add(new Integer(n2));
        return !ChannelSyn.containsToChannelId(n2, arrayList);
    }

    private static boolean containsToChannelId(int n, ArrayList arrayList) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(DB_TABLE_NAME, "SRCCHANNEL=?", "", "distinct ToChannel");
        wCMFilter.addSearchValues(n);
        int[] nArray = DBManager.getDBManager().sqlExecuteIntsQuery(wCMFilter);
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Integer n2 = new Integer(nArray[i]);
            if (arrayList.indexOf(n2) >= 0) {
                return true;
            }
            arrayList.add(n2);
            if (!ChannelSyn.containsToChannelId(nArray[i], arrayList)) continue;
            return true;
        }
        return false;
    }
}

