/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChannelNameMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class ChannelNameMgr
implements IChannelNameMgr {
    private LRUCacheContainer m_lruCache = null;
    public static final int MAX_CACHE_SIZE = 1000;
    private int m_nMaxCachSize = 1000;
    private static Logger s_logger = Logger.getLogger(ChannelNameMgr.class);

    public void clear() {
        if (this.m_lruCache == null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label1", "\u6b63\u5728\u6e05\u7a7a\u9891\u9053\u540d\u79f0\u7f13\u51b2..."));
        this.m_lruCache.clear();
        this.m_lruCache = null;
        s_logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label2", "\u6e05\u7a7a\u9891\u9053\u540d\u79f0\u7f13\u51b2\u5b8c\u6210\uff01"));
    }

    public int getMaxCacheSize() {
        return this.m_nMaxCachSize;
    }

    public void setMaxCacheSize(int n) {
        this.m_nMaxCachSize = n;
    }

    private Object makeKey(int n, String string) {
        return Integer.toHexString(n) + ':' + string;
    }

    private void putToCache(int n, String string, Channel channel) throws WCMException {
        this.getCache().put(this.makeKey(n, string), channel.getKey());
    }

    public Channel findByName(int n, String string) throws WCMException {
        try {
            Object object = this.getCache().get(this.makeKey(n, string));
            if (object != null) {
                return Channel.findByKey(object);
            }
            return this.loadByName(n, string);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label3", "\u63d0\u53d6\u6307\u5b9a\u540d\u79f0\u7684\u9891\u9053\u5931\u8d25(SiteId=") + n + ",Name=" + string + ")findByName", exception);
        }
    }

    private boolean change(int n, String string, Channel channel) throws WCMException {
        if (channel == null) {
            return false;
        }
        try {
            Object object = this.makeKey(n, string);
            if (this.getCache().get(object) != null) {
                this.getCache().remove(object);
            }
            int n2 = channel.getNewPropertyAsInt("SITEID", channel.getSiteId());
            String string2 = channel.getNewPropertyAsString("CHNLNAME");
            if (string2 == null) {
                string2 = channel.getName();
            }
            this.putToCache(n2, string2, channel);
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label4", "\u66f4\u65b0\u9891\u9053\u540d\u79f0\u7f13\u51b2\u5931\u8d25(ChannelId=") + channel.getId() + ",OldName=" + string + ")notifyNameChanged", exception);
        }
    }

    private void remove(Channel channel) throws WCMException {
        this.getCache().remove(this.makeKey(channel.getSiteId(), channel.getName()));
    }

    /*
     * Loose catch block
     */
    private Channel loadByName(int n, String string) throws Exception {
        Exception exception322;
        Channel channel;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block23: {
            Channel channel2;
            block20: {
                Exception exception2222;
                Channel channel3;
                block21: {
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    channel2 = null;
                    String string2 = null;
                    connection = DBManager.getDBManager().getConnection();
                    preparedStatement = connection.prepareStatement("select ChannelId from WCMCHANNEL where SiteId=? and ChnlName=?");
                    preparedStatement.setInt(1, n);
                    string2 = DBManager.getDBManager().getDBType().encodeStrToWrite(string);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setMaxRows(1);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        channel2 = Channel.findById(resultSet.getInt(1));
                    }
                    if (channel2 != null) break block20;
                    channel3 = null;
                    Object var11_11 = null;
                    if (resultSet == null) break block21;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    DBManager.getDBManager().freeConnection(connection);
                }
                return channel3;
            }
            this.putToCache(n, string, channel2);
            channel = channel2;
            Object var11_12 = null;
            if (resultSet == null) break block23;
            try {
                resultSet.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        if (connection != null) {
            DBManager.getDBManager().freeConnection(connection);
        }
        return channel;
        catch (Exception exception4) {
            try {
                throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label5", "\u4ece\u6570\u636e\u5e93\u4e2d\u63d0\u53d6\u9891\u9053\u5bf9\u8c61(SiteId=") + n + ",ChnlName=" + string + I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label6", ")\u5931\u8d25"), exception4);
            }
            catch (Throwable throwable) {
                block25: {
                    Exception exception5222;
                    Object var11_13 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (connection == null) break block25;
                    DBManager.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.putToCache((Channel)baseObj);
    }

    private void putToCache(Channel channel) throws WCMException {
        this.putToCache(channel.getSiteId(), channel.getName(), channel);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.remove((Channel)baseObj);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        s_logger.debug((Object)(baseObj + "...." + baseObj.isChangeProperty("CHNLNAME")));
        if (baseObj.isChangeProperty("SITEID") || baseObj.isChangeProperty("CHNLNAME")) {
            Channel channel = (Channel)baseObj;
            this.change(channel.getSiteId(), channel.getName(), channel);
        }
    }

    public boolean init() throws WCMException {
        if (this.m_lruCache != null) {
            return true;
        }
        s_logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label7", "\u6b63\u5728\u521d\u59cb\u5316\u9891\u9053\u540d\u79f0\u7f13\u51b2..."));
        this.m_lruCache = new LRUCacheContainer();
        this.m_lruCache.setMaxSize(this.getMaxCacheSize());
        WCMFilter wCMFilter = new WCMFilter("", "", "CHANNELID desc ", "", this.getMaxCacheSize());
        Channels channels = Channels.openWCMObjs(null, wCMFilter);
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.putToCache(channel);
        }
        s_logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label8", "\u521d\u59cb\u5316\u9891\u9053\u540d\u79f0\u7f13\u51b2\u5b8c\u6210\uff01"));
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public boolean isDoNotify(BaseObj baseObj) {
        return baseObj != null && baseObj.getWCMType() == 101;
    }

    public LRUCacheContainer getCache() throws WCMException {
        if (this.m_lruCache == null) {
            this.init();
        }
        return this.m_lruCache;
    }

    public static void main(String[] stringArray) {
        ChannelNameMgr channelNameMgr = new ChannelNameMgr();
        try {
            System.out.println(channelNameMgr.findByName(2, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label9", "\u4e13\u9898\u680f\u76ee")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

