/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DocumentAuthServer {
    private static Logger logger = Logger.getLogger(DocumentAuthServer.class);
    public static int[] INDEXES_OWNER_HAS = new int[]{32, 34, 33, 34, 34, 34, WCMRightTypes.DOC_MOVE, 33, 30};
    private static int[] ENTITY_RIGHT_INDEX;
    private static int[] INDEXES_DEFINE_ON_FLOW;

    public static boolean hasRight(User user, ChnlDoc chnlDoc, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, (BaseChannel)chnlDoc.getChannel(), chnlDoc.getDocument(), n);
    }

    public static boolean hasRight(User user, BaseChannel baseChannel, Document document, int n) throws WCMException {
        Cloneable cloneable;
        boolean bl;
        if (user == null) {
            return false;
        }
        int n2 = n;
        if (document == null || document.isAddMode()) {
            if (n2 == 80) {
                n2 = 31;
            }
            if (user.isAdministrator()) {
                return true;
            }
            Channel channel = DocumentAuthServer.findCurrentChannel(baseChannel, document);
            if (user.getName().equalsIgnoreCase(channel.getCrUserName())) {
                return true;
            }
            return AuthServer.hasRight(user, (CMSObj)channel, n2);
        }
        if (n2 == 80) {
            n2 = 32;
        }
        if (n2 == 32 && (bl = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("EDIT_DOCUMENT_USE_ST_INDEX", "false")))) {
            switch (document.getStatusId()) {
                case 10: 
                case 16: 
                case 18: {
                    cloneable = Status.findById(16);
                    n2 = ((Status)cloneable).getRightIndex();
                    break;
                }
            }
        }
        if ((bl = DocumentAuthServer.isRightIndexOwnerHas(n2)) && user.equals(document.getCrUser())) {
            return true;
        }
        if (DocumentAuthServer.isDefineRightOnDocument(document)) {
            cloneable = new RightValue();
            ((RightValue)cloneable).load(user, 605, document.getId(), true);
            return ((RightValue)cloneable).isHasRight(n2);
        }
        if (user.isAdministrator()) {
            return true;
        }
        cloneable = DocumentAuthServer.findCurrentChannel(baseChannel, document);
        if (((BaseObj)cloneable).getId() != document.getChannelId() && !DocumentAuthServer.isRightIndexDefineOnChannel(n2, (Channel)cloneable)) {
            cloneable = document.getChannel();
        }
        if (!AuthServer.hasRight(user, (CMSObj)cloneable, n2)) {
            return false;
        }
        return DocumentAuthServer.hasRightByDocLevel(user, (Channel)cloneable, document);
    }

    private static Channel findCurrentChannel(BaseChannel baseChannel, Document document) throws WCMException {
        Channel channel = null;
        if (baseChannel != null && !baseChannel.isSite()) {
            channel = (Channel)baseChannel;
        } else {
            if (document == null) {
                throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label1", "hasRight\u65b9\u6cd5\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9,\u5373\u6ca1\u6709\u6587\u6863\u4e5f\u6ca1\u6709\u76f8\u5173\u680f\u76ee![BaseChannel:") + baseChannel + "]");
            }
            channel = document.getChannel();
        }
        if (channel == null) {
            throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label2", "\u6587\u6863\u76f8\u5173\u680f\u76ee\u4e0d\u5b58\u5728![DocId:") + document.getId() + ",Title:" + document.getTitle() + "]");
        }
        return channel;
    }

    public static boolean hasRight(User user, BaseChannel baseChannel, Documents documents, int n) throws WCMException {
        if (user == null) {
            return false;
        }
        Channel channel = null;
        if (baseChannel != null && !baseChannel.isSite()) {
            channel = (Channel)baseChannel;
        } else if (documents == null) {
            throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label1", "hasRight\u65b9\u6cd5\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9,\u5373\u6ca1\u6709\u6587\u6863\u4e5f\u6ca1\u6709\u76f8\u5173\u680f\u76ee![BaseChannel:") + baseChannel + "]");
        }
        if (documents == null) {
            return AuthServer.hasRight(user, (CMSObj)channel, n);
        }
        int n2 = documents.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 / 2);
        for (int i = 0; i < n2; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            int n3 = -1;
            n3 = channel == null || channel.isOnlySearch() ? document.getChannelId() : (DocumentAuthServer.isRightIndexDefineOnChannel(n, channel) ? channel.getId() : document.getChannelId());
            Integer n4 = new Integer(n3);
            if (arrayList.contains(n4)) continue;
            if (!DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, n)) {
                return false;
            }
            arrayList.add(n4);
        }
        return true;
    }

    public static String makeLogicRightValue(User user, Channel channel, Document document) throws WCMException {
        if (user == null) {
            throw new WCMException("The Current User is null!");
        }
        if (document == null) {
            throw new WCMException("The Current Document is null!");
        }
        if (DocumentAuthServer.isDefineRightOnDocument(document)) {
            return AuthServer.getRightValue((CMSObj)document, user).toString();
        }
        if (user.isAdministrator()) {
            return RightValue.getAdministratorValues();
        }
        boolean bl = true;
        Channel channel2 = channel;
        Channel channel3 = null;
        if (channel == null || channel.isOnlySearch()) {
            channel3 = channel2 = document.getChannel();
        } else if (channel.getId() == document.getId()) {
            channel3 = channel2;
        } else {
            channel3 = document.getChannel();
            bl = false;
        }
        if (channel3 == null) {
            logger.warn((Object)(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label3", "\u6587\u6863[") + document + I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label4", "]\u6240\u5c5e\u680f\u76ee[Id=") + document.getChannelId() + I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label5", "]\u4e0d\u5b58\u5728\uff01")));
            return "0";
        }
        RightValue rightValue = AuthServer.getRightValue((CMSObj)channel3, user);
        if (bl) {
            return rightValue.toString();
        }
        int[] nArray = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(channel.getSiteId());
        int n = nArray.length;
        if (n == 0) {
            return rightValue.toString();
        }
        RightValue rightValue2 = AuthServer.getRightValue((CMSObj)channel2, user);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            rightValue.setBit(n2, rightValue2.getBit(n2));
        }
        return rightValue.toString();
    }

    public static String formatLogicRightValue(User user, Document document, String string) {
        if (!user.equals(document.getCrUser())) {
            return string;
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < ENTITY_RIGHT_INDEX.length; ++i) {
            int n;
            if (ENTITY_RIGHT_INDEX[i] >= string.length() || string.charAt(n = string.length() - ENTITY_RIGHT_INDEX[i] - 1) != '0') continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.setCharAt(n, '1');
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static boolean hasFlowDocRight(User user, Document document, int n) throws WCMException {
        if (document.isAddMode()) {
            return false;
        }
        if (!DocumentAuthServer.isRightIndexDefineOnFlow(n)) {
            return false;
        }
        FlowServer flowServer = FlowServer.getFlowServer();
        FlowDoc flowDoc = flowServer.getFlowDoc(605, document.getId());
        if (flowDoc == null) {
            return false;
        }
        FlowNode flowNode = flowDoc.getNode();
        if (flowNode == null) {
            return false;
        }
        Users users = flowNode.getOperUsers(user, true);
        boolean bl = false;
        for (int i = 0; i < users.size(); ++i) {
            User user2 = (User)users.getAt(i);
            if (user2 == null || user.getId() != user2.getId()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        if (n == 34) {
            return true;
        }
        if (n == 32 && flowNode.canEditDoc()) {
            return true;
        }
        if (n == 33 && flowNode.canDelDoc()) {
            return true;
        }
        return n == 39 && flowNode.canPubDoc();
    }

    private static boolean isRightIndexOwnerHas(int n) {
        for (int i = 0; i < INDEXES_OWNER_HAS.length; ++i) {
            if (n != INDEXES_OWNER_HAS[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightIndexDefineOnChannel(int n, Channel channel) {
        int[] nArray = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(channel.getSiteId());
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isRightIndexDefineOnFlow(int n) {
        for (int i = 0; i < INDEXES_DEFINE_ON_FLOW.length; ++i) {
            if (n != INDEXES_DEFINE_ON_FLOW[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefineRightOnDocument(Document document) throws WCMException {
        return DocumentAuthServer.isDefineRightOnDocument(document.getId());
    }

    public static boolean isDefineRightOnDocument(int n) throws WCMException {
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return rightCacheMgr.isExistsRight(605, n);
    }

    public static boolean hasRightByDocLevel(User user, Channel channel, Document document) throws WCMException {
        if (user == null || channel == null) {
            return false;
        }
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(channel.getCrUserName())) {
            return true;
        }
        boolean bl = channel.isUseDocLevel();
        if (!bl) {
            return true;
        }
        DocLevel docLevel = document.getDocLevel();
        int n = docLevel.getLValue();
        if (n == 0) {
            return true;
        }
        DocLevel docLevel2 = user.getDocLevel();
        int n2 = docLevel2.getLValue();
        if (n2 == 0) {
            return false;
        }
        return n2 - n <= 0;
    }

    static {
        try {
            String string = ConfigServer.getServer().getSysConfigValue("DOC_CRUSER_HAS_RIGHT_INDEXES", "");
            if (!CMyString.isEmpty(string)) {
                INDEXES_OWNER_HAS = CMyString.splitToInt(string, ",");
            }
        }
        catch (WCMException wCMException) {
            logger.error((Object)"exception occurs when initialing the right indexes for document creator from system config.", (Throwable)wCMException);
        }
        ENTITY_RIGHT_INDEX = new int[]{80, 31, 32, 34};
        INDEXES_DEFINE_ON_FLOW = new int[]{34, 33, 39, 32};
    }
}

